/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.harmony.luni.util.TwoKeyHashMap;
import org.apache.harmony.security.SecurityUtils;
import org.apache.harmony.security.fortress.Services;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class Provider
extends Properties {
    private static final long serialVersionUID = -4298000515446427739L;
    private String name;
    private double version;
    private transient String versionString;
    private String info;
    private transient int providerNumber = -1;
    private transient TwoKeyHashMap<String, String, Service> serviceTable;
    private transient TwoKeyHashMap<String, String, Service> aliasTable;
    private transient TwoKeyHashMap<String, String, Service> propertyServiceTable;
    private transient TwoKeyHashMap<String, String, Service> propertyAliasTable;
    private transient Properties changedProperties;
    private transient Service returnedService;
    private transient String lastAlgorithm;
    private transient String lastServiceName;
    private transient Set<Service> lastServicesSet;
    private transient String lastType;
    private transient Service lastServicesByType;

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
        this.versionString = String.valueOf(d);
        this.putProviderInfo();
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return this.name + " version " + this.version;
    }

    @Override
    public synchronized void clear() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("clearProviderProperties." + this.name);
        }
        super.clear();
        if (this.serviceTable != null) {
            this.serviceTable.clear();
        }
        if (this.propertyServiceTable != null) {
            this.propertyServiceTable.clear();
        }
        if (this.aliasTable != null) {
            this.aliasTable.clear();
        }
        if (this.propertyAliasTable != null) {
            this.propertyAliasTable.clear();
        }
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        this.putProviderInfo();
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
        this.servicesChanged();
    }

    @Override
    public synchronized void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.myPutAll(properties);
    }

    @Override
    public synchronized void putAll(Map<?, ?> map) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("putProviderProperty." + this.name);
        }
        this.myPutAll(map);
    }

    private void myPutAll(Map<?, ?> map) {
        if (this.changedProperties == null) {
            this.changedProperties = new Properties();
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getKey();
            if (obj instanceof String && ((String)obj).startsWith("Provider.")) continue;
            Object obj2 = entry.getValue();
            super.put(obj, obj2);
            if (this.changedProperties.remove(obj) == null) {
                this.removeFromPropertyServiceTable(obj);
            }
            this.changedProperties.put(obj, obj2);
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<Object> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("putProviderProperty." + this.name);
        }
        if (object instanceof String && ((String)object).startsWith("Provider.")) {
            return null;
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
        if (this.changedProperties != null && this.changedProperties.remove(object) == null) {
            this.removeFromPropertyServiceTable(object);
        }
        if (this.changedProperties == null) {
            this.changedProperties = new Properties();
        }
        this.changedProperties.put(object, object2);
        return super.put(object, object2);
    }

    @Override
    public synchronized Object remove(Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeProviderProperty." + this.name);
        }
        if (object instanceof String && ((String)object).startsWith("Provider.")) {
            return null;
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
        if (this.changedProperties != null && this.changedProperties.remove(object) == null) {
            this.removeFromPropertyServiceTable(object);
        }
        return super.remove(object);
    }

    boolean implementsAlg(String string, String string2, String string3, String string4) {
        String string5 = string + "." + string2;
        String string6 = this.getPropertyIgnoreCase(string5);
        if (string6 == null && (string2 = this.getPropertyIgnoreCase("Alg.Alias." + string5)) != null) {
            string5 = string + "." + string2;
            string6 = this.getPropertyIgnoreCase(string5);
        }
        if (string6 != null) {
            if (string3 == null) {
                return true;
            }
            return this.checkAttribute(string5, string3, string4);
        }
        return false;
    }

    private boolean checkAttribute(String string, String string2, String string3) {
        String string4 = this.getPropertyIgnoreCase(string + ' ' + string2);
        return string4 != null && (SecurityUtils.equalsIgnoreCase(string2, "KeySize") ? Integer.valueOf(string4).compareTo(Integer.valueOf(string3)) >= 0 : SecurityUtils.equalsIgnoreCase(string4, string3));
    }

    void setProviderNumber(int n) {
        this.providerNumber = n;
    }

    int getProviderNumber() {
        return this.providerNumber;
    }

    synchronized Service getService(String string) {
        this.updatePropertyServiceTable();
        if (this.lastServicesByType != null && string.equals(this.lastType)) {
            return this.lastServicesByType;
        }
        for (Service service : this.getServices()) {
            if (!string.equals(service.type)) continue;
            this.lastType = string;
            this.lastServicesByType = service;
            return service;
        }
        return null;
    }

    public synchronized Service getService(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (string.equals(this.lastServiceName) && SecurityUtils.equalsIgnoreCase(string2, this.lastAlgorithm)) {
            return this.returnedService;
        }
        String string3 = string2.toUpperCase(Locale.US);
        Object object = null;
        if (this.serviceTable != null) {
            object = this.serviceTable.get((Object)string, (Object)string3);
        }
        if (object == null && this.aliasTable != null) {
            object = this.aliasTable.get((Object)string, (Object)string3);
        }
        if (object == null) {
            this.updatePropertyServiceTable();
        }
        if (object == null && this.propertyServiceTable != null) {
            object = this.propertyServiceTable.get((Object)string, (Object)string3);
        }
        if (object == null && this.propertyAliasTable != null) {
            object = this.propertyAliasTable.get((Object)string, (Object)string3);
        }
        if (object != null) {
            this.lastServiceName = string;
            this.lastAlgorithm = string2;
            this.returnedService = (Service)object;
            return this.returnedService;
        }
        return null;
    }

    public synchronized Set<Service> getServices() {
        this.updatePropertyServiceTable();
        if (this.lastServicesSet != null) {
            return this.lastServicesSet;
        }
        this.lastServicesSet = this.serviceTable != null ? new HashSet<Service>(this.serviceTable.values()) : new HashSet<Service>();
        if (this.propertyServiceTable != null) {
            this.lastServicesSet.addAll(this.propertyServiceTable.values());
        }
        this.lastServicesSet = Collections.unmodifiableSet(this.lastServicesSet);
        return this.lastServicesSet;
    }

    protected synchronized void putService(Service service) {
        if (service == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("putProviderProperty." + this.name);
        }
        if ("Provider".equals(service.getType())) {
            return;
        }
        this.servicesChanged();
        if (this.serviceTable == null) {
            this.serviceTable = new TwoKeyHashMap(128);
        }
        this.serviceTable.put((Object)service.type, (Object)service.algorithm.toUpperCase(Locale.US), (Object)service);
        if (service.aliases != null) {
            if (this.aliasTable == null) {
                this.aliasTable = new TwoKeyHashMap(256);
            }
            Iterator<String> iterator = service.getAliases();
            while (iterator.hasNext()) {
                this.aliasTable.put((Object)service.type, (Object)iterator.next().toUpperCase(Locale.US), (Object)service);
            }
        }
        this.serviceInfoToProperties(service);
    }

    protected synchronized void removeService(Service service) {
        if (service == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess("removeProviderProperty." + this.name);
        }
        this.servicesChanged();
        if (this.serviceTable != null) {
            this.serviceTable.remove((Object)service.type, (Object)service.algorithm.toUpperCase(Locale.US));
        }
        if (this.aliasTable != null && service.aliases != null) {
            Iterator<String> iterator = service.getAliases();
            while (iterator.hasNext()) {
                this.aliasTable.remove((Object)service.type, (Object)iterator.next().toUpperCase(Locale.US));
            }
        }
        this.serviceInfoFromProperties(service);
    }

    private void serviceInfoToProperties(Service service) {
        super.put(service.type + "." + service.algorithm, service.className);
        if (service.aliases != null) {
            Iterator<Object> iterator = service.aliases.iterator();
            while (iterator.hasNext()) {
                super.put("Alg.Alias." + service.type + "." + (String)iterator.next(), service.algorithm);
            }
        }
        if (service.attributes != null) {
            for (Map.Entry entry : service.attributes.entrySet()) {
                super.put(service.type + "." + service.algorithm + " " + (String)entry.getKey(), entry.getValue());
            }
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
    }

    private void serviceInfoFromProperties(Service service) {
        super.remove(service.type + "." + service.algorithm);
        if (service.aliases != null) {
            Iterator<Object> iterator = service.aliases.iterator();
            while (iterator.hasNext()) {
                super.remove("Alg.Alias." + service.type + "." + (String)iterator.next());
            }
        }
        if (service.attributes != null) {
            for (Map.Entry entry : service.attributes.entrySet()) {
                super.remove(service.type + "." + service.algorithm + " " + (String)entry.getKey());
            }
        }
        if (this.providerNumber != -1) {
            Services.setNeedRefresh();
        }
    }

    private void removeFromPropertyServiceTable(Object object) {
        if (object == null || !(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (string.startsWith("Provider.")) {
            return;
        }
        String string2 = null;
        String string3 = null;
        if (string.startsWith("Alg.Alias.")) {
            String string4 = string.substring(10);
            int n = string4.indexOf(".");
            String string5 = string4.substring(0, n);
            String string6 = string4.substring(n + 1);
            if (this.propertyAliasTable != null) {
                this.propertyAliasTable.remove((Object)string5, (Object)string6.toUpperCase(Locale.US));
            }
            if (this.propertyServiceTable != null) {
                for (Service service : this.propertyServiceTable.values()) {
                    if (!service.aliases.contains(string6)) continue;
                    service.aliases.remove(string6);
                    return;
                }
            }
            return;
        }
        int n = string.indexOf(".");
        if (n == -1) {
            return;
        }
        int n2 = string.indexOf(" ");
        if (n2 == -1) {
            Service service;
            String string7 = string.substring(0, n);
            string2 = string.substring(n + 1);
            if (this.propertyServiceTable != null && (service = (Service)this.propertyServiceTable.remove((Object)string7, (Object)string2.toUpperCase(Locale.US))) != null && this.propertyAliasTable != null && service.aliases != null) {
                Iterator iterator = service.aliases.iterator();
                while (iterator.hasNext()) {
                    this.propertyAliasTable.remove((Object)string7, (Object)((String)iterator.next()).toUpperCase(Locale.US));
                }
            }
        } else {
            Object object2;
            string3 = string.substring(n2 + 1);
            String string8 = string.substring(0, n);
            string2 = string.substring(n + 1, n2);
            if (this.propertyServiceTable != null && (object2 = this.propertyServiceTable.get((Object)string8, (Object)string2.toUpperCase(Locale.US))) != null) {
                Service service = (Service)object2;
                service.attributes.remove(string3);
            }
        }
    }

    private void updatePropertyServiceTable() {
        if (this.changedProperties == null || this.changedProperties.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : this.changedProperties.entrySet()) {
            Cloneable cloneable;
            String string;
            Service service;
            Object object;
            Object object2;
            String string2;
            String string3;
            int n;
            String string4;
            Object object3 = entry.getKey();
            Object object4 = entry.getValue();
            if (object3 == null || object4 == null || !(object3 instanceof String) || !(object4 instanceof String)) continue;
            String string5 = (String)object3;
            String string6 = (String)object4;
            if (string5.startsWith("Provider")) continue;
            if (string5.startsWith("Alg.Alias.")) {
                string4 = string5.substring(10);
                n = string4.indexOf(".");
                string3 = string4.substring(0, n);
                String string7 = string4.substring(n + 1);
                string2 = string6;
                object2 = string2.toUpperCase(Locale.US);
                object = null;
                if (this.propertyServiceTable == null) {
                    this.propertyServiceTable = new TwoKeyHashMap(128);
                } else {
                    object = this.propertyServiceTable.get((Object)string3, object2);
                }
                if (object != null) {
                    service = (Service)object;
                    service.aliases.add(string7);
                    if (this.propertyAliasTable == null) {
                        this.propertyAliasTable = new TwoKeyHashMap(256);
                    }
                    this.propertyAliasTable.put((Object)string3, (Object)string7.toUpperCase(Locale.US), (Object)service);
                    continue;
                }
                string = (String)this.changedProperties.get(string3 + "." + string2);
                if (string == null) continue;
                cloneable = new ArrayList<String>();
                cloneable.add(string7);
                service = new Service(this, string3, string2, string, (List<String>)((Object)cloneable), new HashMap<String, String>());
                this.propertyServiceTable.put((Object)string3, object2, (Object)service);
                if (this.propertyAliasTable == null) {
                    this.propertyAliasTable = new TwoKeyHashMap(256);
                }
                this.propertyAliasTable.put((Object)string3, (Object)string7.toUpperCase(Locale.US), (Object)service);
                continue;
            }
            int n2 = string5.indexOf(".");
            if (n2 == -1) continue;
            n = string5.indexOf(" ");
            if (n == -1) {
                string3 = string5.substring(0, n2);
                string2 = string5.substring(n2 + 1);
                string4 = string2.toUpperCase(Locale.US);
                object2 = null;
                if (this.propertyServiceTable != null) {
                    object2 = this.propertyServiceTable.get((Object)string3, (Object)string4);
                }
                if (object2 != null) {
                    service = (Service)object2;
                    service.className = string6;
                    continue;
                }
                service = new Service(this, string3, string2, string6, new ArrayList<String>(), new HashMap<String, String>());
                if (this.propertyServiceTable == null) {
                    this.propertyServiceTable = new TwoKeyHashMap(128);
                }
                this.propertyServiceTable.put((Object)string3, (Object)string4, (Object)service);
                continue;
            }
            string3 = string5.substring(0, n2);
            string2 = string5.substring(n2 + 1, n);
            string4 = string5.substring(n + 1);
            object2 = string2.toUpperCase(Locale.US);
            object = null;
            if (this.propertyServiceTable != null) {
                object = this.propertyServiceTable.get((Object)string3, object2);
            }
            if (object != null) {
                service = (Service)object;
                service.attributes.put(string4, string6);
                continue;
            }
            string = (String)this.changedProperties.get(string3 + "." + string2);
            if (string == null) continue;
            cloneable = new HashMap();
            cloneable.put(string4, string6);
            service = new Service(this, string3, string2, string, new ArrayList<String>(), (Map<String, String>)((Object)cloneable));
            if (this.propertyServiceTable == null) {
                this.propertyServiceTable = new TwoKeyHashMap(128);
            }
            this.propertyServiceTable.put((Object)string3, object2, (Object)service);
        }
        this.servicesChanged();
        this.changedProperties.clear();
    }

    private void servicesChanged() {
        this.lastServicesByType = null;
        this.lastServiceName = null;
        this.lastServicesSet = null;
    }

    private void putProviderInfo() {
        super.put("Provider.id name", null != this.name ? this.name : "null");
        super.put("Provider.id version", this.versionString);
        super.put("Provider.id info", null != this.info ? this.info : "null");
        super.put("Provider.id className", this.getClass().getName());
    }

    private String getPropertyIgnoreCase(String string) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!SecurityUtils.equalsIgnoreCase(string, string3)) continue;
            return this.getProperty(string3);
        }
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws NotActiveException, IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.versionString = String.valueOf(this.version);
        this.providerNumber = -1;
    }

    public static class Service {
        private Provider provider;
        private String type;
        private String algorithm;
        private String className;
        private List<String> aliases;
        private Map<String, String> attributes;
        private Class<?> implementation;
        private String lastClassName;

        public Service(Provider provider, String string, String string2, String string3, List<String> list, Map<String, String> map) {
            if (provider == null || string == null || string2 == null || string3 == null) {
                throw new NullPointerException();
            }
            this.provider = provider;
            this.type = string;
            this.algorithm = string2;
            this.className = string3;
            this.aliases = list;
            this.attributes = map;
        }

        public final String getType() {
            return this.type;
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final Provider getProvider() {
            return this.provider;
        }

        public final String getClassName() {
            return this.className;
        }

        public final String getAttribute(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(string);
        }

        Iterator<String> getAliases() {
            if (this.aliases == null) {
                this.aliases = new ArrayList<String>(0);
            }
            return this.aliases.iterator();
        }

        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            Class[] classArray;
            if (!(this.implementation != null && this.className.equals(this.lastClassName) || (classArray = AccessController.doPrivileged(new PrivilegedAction<NoSuchAlgorithmException>(){

                @Override
                public NoSuchAlgorithmException run() {
                    ClassLoader classLoader = Service.this.provider.getClass().getClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    try {
                        Service.this.implementation = Class.forName(Service.this.className, true, classLoader);
                    }
                    catch (Exception exception) {
                        return new NoSuchAlgorithmException(Messages.getString("security.11", new Object[]{Service.this.type, Service.this.algorithm, exception}));
                    }
                    Service.this.lastClassName = Service.this.className;
                    return null;
                }
            })) == null)) {
                throw classArray;
            }
            classArray = new Class[1];
            if (object != null && !this.supportsParameter(object)) {
                throw new InvalidParameterException(Messages.getString("security.12", this.type));
            }
            Object[] objectArray = new Object[]{object};
            try {
                if (SecurityUtils.equalsIgnoreCase(this.type, "CertStore")) {
                    classArray[0] = Class.forName("java.security.cert.CertStoreParameters");
                } else if (SecurityUtils.equalsIgnoreCase(this.type, "Configuration")) {
                    classArray[0] = Class.forName("javax.security.auth.login.Configuration$Parameters");
                }
                if (classArray[0] == null) {
                    if (object == null) {
                        return this.implementation.newInstance();
                    }
                    classArray[0] = object.getClass();
                }
                return this.implementation.getConstructor(classArray).newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException(Messages.getString("security.199", this.type, this.algorithm), exception);
            }
        }

        public boolean supportsParameter(Object object) {
            return true;
        }

        public String toString() {
            String string = "Provider " + this.provider.getName() + " Service " + this.type + "." + this.algorithm + " " + this.className;
            if (this.aliases != null) {
                string = string + "\nAliases " + this.aliases.toString();
            }
            if (this.attributes != null) {
                string = string + "\nAttributes " + this.attributes.toString();
            }
            return string;
        }
    }
}

