/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.apache.harmony.security.fortress.BootstrapHelper;
import org.apache.harmony.security.fortress.Engine;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String SERVICE = "MessageDigest";
    private static Engine engine = new Engine("MessageDigest");
    private Provider provider;
    private String algorithm;

    protected MessageDigest(String string) {
        this.algorithm = string;
    }

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        string = MessageDigest.getAlgorithm(string);
        Engine.ServiceResult serviceResult = engine.getInstance(string, null);
        if (serviceResult.spi instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)serviceResult.spi;
            messageDigest.algorithm = string;
            messageDigest.provider = serviceResult.provider;
            return messageDigest;
        }
        MessageDigestImpl messageDigestImpl = new MessageDigestImpl((MessageDigestSpi)serviceResult.spi, serviceResult.provider, string);
        return messageDigestImpl;
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.02"));
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(Messages.getString("security.03", string2));
        }
        return MessageDigest.getInstance(string, provider);
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException(Messages.getString("security.04"));
        }
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.01"));
        }
        string = MessageDigest.getAlgorithm(string);
        Engine.ServiceResult serviceResult = engine.getInstance(string, provider, null);
        if (serviceResult.spi instanceof MessageDigest) {
            MessageDigest messageDigest = (MessageDigest)serviceResult.spi;
            messageDigest.algorithm = string;
            messageDigest.provider = provider;
            return messageDigest;
        }
        MessageDigestImpl messageDigestImpl = new MessageDigestImpl((MessageDigestSpi)serviceResult.spi, provider, string);
        return messageDigestImpl;
    }

    public void reset() {
        this.engineReset();
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        if (byArray == null || (long)n + (long)n2 > (long)byArray.length) {
            throw new IllegalArgumentException(Messages.getString("security.05"));
        }
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException(Messages.getString("security.06"));
        }
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        if (byArray == null || (long)n + (long)n2 > (long)byArray.length) {
            throw new IllegalArgumentException(Messages.getString("security.05"));
        }
        return this.engineDigest(byArray, n, n2);
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return "MESSAGE DIGEST " + this.algorithm;
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getDigestLength() {
        int n = this.engineGetDigestLength();
        if (n != 0) {
            return n;
        }
        if (!(this instanceof Cloneable)) {
            return 0;
        }
        try {
            MessageDigest messageDigest = (MessageDigest)this.clone();
            return messageDigest.digest().length;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return 0;
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public final void update(ByteBuffer byteBuffer) {
        this.engineUpdate(byteBuffer);
    }

    private static String getAlgorithm(String string) {
        if (!BootstrapHelper.isInJarVerify()) {
            return string;
        }
        if (string.equals("SHA-1")) {
            return "SHA1";
        }
        return string;
    }

    private static class MessageDigestImpl
    extends MessageDigest {
        private MessageDigestSpi spiImpl;

        private MessageDigestImpl(MessageDigestSpi messageDigestSpi, Provider provider, String string) {
            super(string);
            ((MessageDigest)this).provider = provider;
            this.spiImpl = messageDigestSpi;
        }

        @Override
        protected void engineReset() {
            this.spiImpl.engineReset();
        }

        @Override
        protected byte[] engineDigest() {
            return this.spiImpl.engineDigest();
        }

        @Override
        protected int engineGetDigestLength() {
            return this.spiImpl.engineGetDigestLength();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.spiImpl.engineUpdate(by);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            this.spiImpl.engineUpdate(byArray, n, n2);
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            if (this.spiImpl instanceof Cloneable) {
                MessageDigestSpi messageDigestSpi = (MessageDigestSpi)this.spiImpl.clone();
                return new MessageDigestImpl(messageDigestSpi, this.getProvider(), this.getAlgorithm());
            }
            throw new CloneNotSupportedException();
        }
    }
}

