/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;
import org.apache.harmony.security.internal.nls.Messages;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 6279438298436773498L;

    public BasicPermission(String string) {
        super(string);
        this.checkName(string);
    }

    public BasicPermission(String string, String string2) {
        super(string);
        this.checkName(string);
    }

    private final void checkName(String string) {
        if (string == null) {
            throw new NullPointerException(Messages.getString("security.28"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("security.29"));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return this.getName().equals(((Permission)object).getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission != null && permission.getClass() == this.getClass()) {
            String string = this.getName();
            String string2 = permission.getName();
            if (this instanceof RuntimePermission) {
                if (string2.equals("exitVM")) {
                    string2 = "exitVM.*";
                } else if (string.equals("exitVM")) {
                    string = "exitVM.*";
                }
            }
            return BasicPermission.nameImplies(string, string2);
        }
        return false;
    }

    static boolean nameImplies(String string, String string2) {
        if (string == string2) {
            return true;
        }
        int n = string.length();
        if (n > string2.length()) {
            return false;
        }
        if (string.charAt(--n) == '*' && (n == 0 || string.charAt(n - 1) == '.')) {
            --n;
        } else if (n != string2.length() - 1) {
            return false;
        }
        for (int i = n; i >= 0; --i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.checkName(this.getName());
    }
}

