/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpConsole;
import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9Jvm;
import java.util.Iterator;
import java.util.Vector;

public class J9Monitor {
    private String name;
    private long id;
    private long owner;
    private String idAsString;
    private String ownerAsString;
    private long objectAddr;
    private String objectAddrAsString;

    public J9Monitor(String idIn, String nameIn, String ownerIn, String objectIn) {
        this.idAsString = idIn;
        this.name = nameIn;
        this.id = DumpUtils.parseLongHex(idIn);
        this.ownerAsString = ownerIn;
        this.objectAddrAsString = objectIn;
        if (null != ownerIn) {
            this.owner = DumpUtils.parseLongHex(ownerIn);
        }
        if (null == this.name) {
            this.name = "Un-named Monitor@" + this.idAsString;
        }
        if (null != objectIn) {
            this.objectAddr = DumpUtils.parseLongHex(objectIn);
        }
        J9JVMConsole.addMonitor(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n" + this.name);
        sb.append("\n\tid= " + this.idAsString);
        if (this.owner != 0L) {
            sb.append("\n\towner= " + this.ownerAsString);
        }
        if (this.objectAddr != 0L) {
            sb.append("\n\tobject= " + this.objectAddrAsString);
        }
        return sb.toString();
    }

    public long getId() {
        return this.id;
    }

    public String getIdAsString() {
        return this.idAsString;
    }

    public String getName() {
        return this.name;
    }

    public long getOwner() {
        return this.owner;
    }

    public long getObjectAddr() {
        return this.objectAddr;
    }

    public Vector getEnterWaiters() {
        Vector<GenericThread> v = new Vector<GenericThread>();
        J9Jvm jvm = DumpConsole.getTheDump().getCurrentJvm();
        Iterator threads = jvm.getJavaThreads();
        while (threads.hasNext()) {
            GenericThread t = (GenericThread)threads.next();
            if (null == t.monitorId || !t.monitorId.equals(this.idAsString) || !t.getState().equals("Waiting")) continue;
            v.add(t);
        }
        return v;
    }

    public Vector getNotifyWaiters() {
        Vector<GenericThread> v = new Vector<GenericThread>();
        J9Jvm jvm = DumpConsole.getTheDump().getCurrentJvm();
        Iterator threads = jvm.getJavaThreads();
        while (threads.hasNext()) {
            GenericThread t = (GenericThread)threads.next();
            if (null == t.monitorId || !t.monitorId.equals(this.idAsString) || !t.getState().equals("Blocked")) continue;
            v.add(t);
        }
        return v;
    }

    public String getObjectAddrAsString() {
        return this.objectAddrAsString;
    }
}

