/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.systemdump;

import com.ibm.jvm.j9.dump.commandconsole.DumpUtils;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.GenericThread;
import com.ibm.jvm.j9.dump.systemdump.J9AddressSpace;
import com.ibm.jvm.j9.dump.systemdump.J9Module;
import com.ibm.jvm.j9.dump.systemdump.J9Process;
import com.ibm.jvm.j9.dump.systemdump.MemoryRange;
import com.ibm.jvm.j9.dump.systemdump.NativeThreadContext;
import com.ibm.jvm.j9.dump.systemdump.ProgramHeaderElement;
import com.ibm.jvm.j9.dump.systemdump.Register;
import com.ibm.jvm.j9.dump.systemdump.SectionHeaderElement;
import com.ibm.jvm.j9.dump.systemdump.Symbol;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class Elfdump
extends Dump {
    private static boolean verbose = false;
    private int wordLength;
    private int machine;
    private long version;
    private long entry;
    private long dllLoadPoint;
    private long programHeaderOffset;
    private long sectionHeaderOffset;
    private long flags;
    private long elfHeaderSize;
    private long programHeaderEntrySize;
    private long numProgramHeaders;
    private long sectionHeaderEntrySize;
    private long numSectionHeaders;
    private long stringTable;
    private Map pHMap;
    private Vector pT_Dynamic_Entries;
    private Vector shVector = new Vector();
    PrPsInfo proc;
    private static Vector debugFiles;
    private Vector stringTableEntries = new Vector();
    private boolean isExec = false;
    private boolean isDll = false;
    SectionHeaderElement symTableEl;
    SectionHeaderElement symTableStringsEl;
    static final int NT_PRSTATUS = 1;
    static final int NT_PRFPREG = 2;
    static final int NT_PRPSINFO = 3;
    static final int NT_TASKSTRUCT = 4;
    static final int NT_PRXFPREG = 1189489535;
    static final int EI_NIDENT = 16;
    static final int ELFCLASS32 = 1;
    static final int ELFCLASS64 = 2;
    static final int ELFDATA2LSB = 1;
    static final int ELFDATA2MSB = 2;
    static final int ARCH_SPARC = 2;
    static final int ARCH_IA32 = 3;
    static final int ARCH_IA64 = 50;
    static final int ARCH_PPC32 = 20;
    static final int ARCH_PPC64 = 21;
    static final int ARCH_S390 = 22;
    static final int ARCH_AMD64 = 62;
    static final long DT_NULL = 0L;
    static final long DT_DEBUG = 21L;
    private static String[] archStrings;

    public Elfdump(String filename) throws FileNotFoundException {
        this(filename, false, false, 0L);
    }

    public Elfdump(String filename, boolean executable, boolean dll, long dllLoadAddress) throws FileNotFoundException {
        super(filename, "r");
        this.setExec(executable);
        this.setDll(dll);
        this.dllLoadPoint = dllLoadAddress;
        this.addressSpaces = new J9AddressSpace[1];
        this.addressSpaces[0] = new J9AddressSpace("ELFAS", this, 0);
        this.proc = new PrPsInfo("temp");
        this.setSystemType(2);
        byte[] signature = new byte[16];
        try {
            ProgramHeaderElement pHElement;
            int i;
            this.read(signature);
            String s = new String(signature);
            s = s.toUpperCase();
            if (-1 != s.indexOf("ELF")) {
                if (verbose) {
                    System.err.println("It is an elf core file or executable ");
                }
            } else {
                throw new Exception("ELF signature not found in dump file.");
            }
            byte[] eiClassData = new byte[]{signature[4], signature[5]};
            this.setArchitecture(eiClassData);
            int objecttype = this.readHalf();
            if (verbose) {
                System.out.println("Object Type = " + objecttype);
            }
            this.machine = this.readHalf();
            switch (this.machine) {
                case 20: 
                case 21: 
                case 50: {
                    int uidSize = 4;
                    break;
                }
                case 22: {
                    int uidSize = this.wordLength / 2;
                    break;
                }
                default: {
                    int uidSize = 2;
                }
            }
            if (this.is32bit()) {
                this.read32bitHeader();
            } else {
                this.read64bitHeader();
            }
            if (this.isExec || this.isDll) {
                SectionHeaderElement sHElement;
                this.readStringTable();
                i = 0;
                while ((long)i < this.numSectionHeaders) {
                    this.seek(this.sectionHeaderOffset + (long)i * this.sectionHeaderEntrySize);
                    sHElement = SectionHeaderElement.readSectionHeaderElement(this, this.is32bit());
                    this.shVector.add(sHElement);
                    ++i;
                }
                i = 0;
                while ((long)i < this.numSectionHeaders) {
                    sHElement = (SectionHeaderElement)this.shVector.get(i);
                    if (sHElement.sh_type == 2L || sHElement.sh_type == 11L) {
                        this.createSymbols(sHElement);
                    }
                    ++i;
                }
            }
            this.pHMap = new HashMap((int)this.numProgramHeaders);
            i = 0;
            while ((long)i < this.numProgramHeaders) {
                this.seek(this.programHeaderOffset + (long)i * this.programHeaderEntrySize);
                pHElement = ProgramHeaderElement.readProgramHeaderElement(this, this.is32bit());
                if (pHElement.memsize != 0L) {
                    this.pHMap.put(new Long(pHElement.virtaddr), pHElement);
                }
                if (verbose) {
                    System.err.println(pHElement.toString());
                }
                ++i;
            }
            i = 0;
            while ((long)i < this.numProgramHeaders) {
                this.seek(this.programHeaderOffset + (long)i * this.programHeaderEntrySize);
                pHElement = ProgramHeaderElement.readProgramHeaderElement(this, this.is32bit());
                if (pHElement.type == 2L) {
                    if (null == this.pT_Dynamic_Entries) {
                        this.pT_Dynamic_Entries = new Vector();
                    }
                    this.pT_Dynamic_Entries.add(pHElement);
                }
                if (pHElement.type == 4L) {
                    this.readNote(pHElement);
                }
                if (verbose) {
                    System.err.println(pHElement.toString());
                }
                ++i;
            }
            this.pHMap = new TreeMap(this.pHMap);
            debugFiles = Elfdump.findDebugFiles(null, this, true);
            if (verbose) {
                ProgramHeaderElement[] allpH = this.pHMap.values().toArray(new ProgramHeaderElement[0]);
                long totalMemSize = 0L;
                int i2 = 0;
                while ((long)i2 < this.numProgramHeaders) {
                    totalMemSize += allpH[i2].memsize;
                    switch ((int)allpH[i2].type) {
                        case 1: {
                            if (allpH[i2].filesize == 0L || !verbose) break;
                            System.err.println("Its a LOAD entry thats dumped memory 0x" + Long.toHexString(allpH[i2].virtaddr) + "for " + Long.toHexString(allpH[i2].memsize) + " bytes. Offset in dump file is 0x" + Long.toHexString(allpH[i2].offset));
                            break;
                        }
                        case 4: {
                            if (!verbose) break;
                            System.err.println("It's a NOTE entry");
                            break;
                        }
                        case 2: {
                            if (!verbose) break;
                            System.err.println("It's a DYNAMIC entry");
                            break;
                        }
                    }
                    ++i2;
                }
                if (verbose) {
                    System.out.println("Total Memory Size =" + totalMemSize);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception reading dump file");
        }
    }

    private void read32bitHeader() throws IOException {
        this.version = this.readUnsignInt();
        this.entry = this.readUnsignInt();
        this.programHeaderOffset = this.readUnsignInt();
        this.sectionHeaderOffset = this.readUnsignInt();
        this.flags = this.readUnsignInt();
        this.elfHeaderSize = this.readHalf();
        this.programHeaderEntrySize = this.readHalf();
        this.numProgramHeaders = this.readHalf();
        this.sectionHeaderEntrySize = this.readHalf();
        this.numSectionHeaders = this.readHalf();
        this.stringTable = this.readHalf();
        if (verbose) {
            System.out.println("32bit");
            System.out.println("version =" + this.version);
            System.out.println("entry =" + this.entry);
            System.out.println("programHeaderOffset =" + this.programHeaderOffset);
            System.out.println("sectionHeaderOffset =" + this.sectionHeaderOffset);
        }
    }

    private void read64bitHeader() throws IOException {
        this.version = this.readUnsignInt();
        this.entry = this.readUnsignLong();
        this.programHeaderOffset = this.readUnsignLong();
        this.sectionHeaderOffset = this.readUnsignLong();
        this.flags = this.readUnsignInt();
        this.elfHeaderSize = this.readHalf();
        this.programHeaderEntrySize = this.readHalf();
        this.numProgramHeaders = this.readHalf();
        this.sectionHeaderEntrySize = this.readHalf();
        this.numSectionHeaders = this.readHalf();
        this.stringTable = this.readHalf();
        if (verbose) {
            System.out.println("64bit");
            System.out.println("version =" + this.version);
            System.out.println("entry =" + this.entry);
            System.out.println("programHeaderOffset =" + this.programHeaderOffset);
            System.out.println("sectionHeaderOffset =" + this.sectionHeaderOffset);
        }
    }

    public static boolean isSupportedDump(RandomAccessFile raf) {
        byte[] signature = new byte[16];
        try {
            raf.seek(0L);
            raf.read(signature);
            String s = new String(signature);
            s = s.toUpperCase();
            if (-1 != s.indexOf("ELF")) {
                if (verbose) {
                    System.err.println("isSupportedDump: it's an elf core file");
                }
                return true;
            }
        }
        catch (IOException e) {
            return false;
        }
        return false;
    }

    private void setArchitecture(byte[] archFlags) throws IOException {
        switch (archFlags[0]) {
            case 1: {
                this.set32Bit(true);
                break;
            }
            case 2: {
                this.set32Bit(false);
                break;
            }
            default: {
                throw new IOException("Unexpected bitness flag detected in core file.");
            }
        }
        switch (archFlags[1]) {
            case 1: {
                Elfdump.setLittleEndian(true);
                break;
            }
            case 2: {
                Elfdump.setLittleEndian(false);
                break;
            }
            default: {
                throw new IOException("Unexpected endianess flag detected in core file.");
            }
        }
        if (verbose) {
            if (this.is32bit()) {
                System.err.println("Its a 32-bit dump");
            } else {
                System.err.println("Its a 64-bit dump");
            }
            if (bIsLittleEndian) {
                System.err.println("Its a little endian dump");
            } else {
                System.err.println("Its a big endian dump");
            }
        }
    }

    protected MemoryRange[] getRawMemoryRanges() {
        MemoryRange[] result = new MemoryRange[this.pHMap.size()];
        int i = 0;
        for (ProgramHeaderElement element : this.pHMap.values()) {
            result[i] = element.getRange();
            ++i;
        }
        return result;
    }

    public long readUnsignInt() throws IOException {
        long[] ia = new long[4];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.readUnsignedByte();
            ia[i] = ia[i] & 0xFFL;
        }
        if (this.isLittleEndian()) {
            return ia[0] + (ia[1] << 8) + (ia[2] << 16) + (ia[3] << 24);
        }
        return ia[3] + (ia[2] << 8) + (ia[1] << 16) + (ia[0] << 24);
    }

    public int readHalf() throws IOException {
        int[] ia = new int[2];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.readUnsignedByte();
            ia[i] = ia[i] & 0xFF;
        }
        if (this.isLittleEndian()) {
            return ia[0] + (ia[1] << 8);
        }
        return ia[1] + (ia[0] << 8);
    }

    public long readUnsignLong() throws IOException {
        long[] ia = new long[8];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.readUnsignedByte();
            ia[i] = ia[i] & 0xFFL;
        }
        if (this.isLittleEndian()) {
            return ia[0] + (ia[1] << 8) + (ia[2] << 16) + (ia[3] << 24) + (ia[4] << 32) + (ia[5] << 40) + (ia[6] << 48) + (ia[7] << 56);
        }
        return ia[7] + (ia[6] << 8) + (ia[5] << 16) + (ia[4] << 24) + (ia[3] << 32) + (ia[2] << 40) + (ia[1] << 48) + (ia[0] << 56);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("\n\tSystem subtype : ");
        result.append(archStrings[this.machine]);
        result.append('\n');
        return result.toString();
    }

    private void readNote(ProgramHeaderElement noteElement) {
        PrPsInfo process = null;
        long nextNote = noteElement.offset;
        while (nextNote < noteElement.offset + noteElement.filesize) {
            try {
                this.seek(nextNote);
                int nameLen = this.readIntEx();
                if (nameLen > 4) {
                    nameLen = 8;
                }
                int dataSize = this.readIntEx();
                int type = this.readIntEx();
                String name = this.readString(nameLen);
                nextNote = this.getFilePointer() + (long)dataSize;
                switch (type) {
                    case 1: {
                        if (this.isDll || this.isExec) break;
                        this.proc.addThread(new prStatus());
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 1189489535: {
                        break;
                    }
                    case 3: {
                        process = new PrPsInfo(this.proc, this.getFilePointer() + (long)dataSize);
                        this.addressSpaces[0].addProcess(process);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
            }
            catch (IOException ioe) {}
        }
    }

    long readWord() throws IOException {
        long retLong = 0L;
        retLong = this.bIs32Bit ? (long)this.readIntEx() : this.readLongEx();
        return retLong;
    }

    String readString(int len) throws IOException {
        byte[] b = new byte[len];
        this.read(b);
        return new String(b);
    }

    public long readUid() throws IOException {
        return this.readIntEx();
    }

    public int readBuffer(byte[] buffer) throws IOException {
        long len = this.read(buffer);
        return (int)len;
    }

    public static Vector findDebugFiles(String execNameOverRide, Dump core, boolean createModules) {
        String dir = null;
        if (debugFiles != null) {
            return debugFiles;
        }
        debugFiles = new Vector();
        Vector<String> retFileNames = new Vector<String>();
        String execFileName = null;
        RandomAccessFile execRAF = null;
        J9Process proc = (J9Process)core.addressSpaces[0].processes.get(0);
        String exec = proc.getExecutable();
        String command = proc.getCommand();
        Vector<String> v = new Vector<String>();
        Vector<J9Module> modules = new Vector<J9Module>();
        boolean bChangeSeparator = false;
        if (File.separator.equals("\\")) {
            exec = DumpUtils.changeFileSeperator(exec, '\\');
        }
        if (execNameOverRide != null) {
            v.add(execNameOverRide);
        }
        if (exec.startsWith("/") || exec.startsWith("\\")) {
            v.add(exec);
        }
        if (exec.startsWith("./") || exec.startsWith(".\\") || exec.startsWith("/") || exec.startsWith("\\")) {
            v.add(exec);
            exec = exec.startsWith("./") || exec.startsWith(".\\") ? exec.substring(2) : exec.substring(1);
            v.add(exec);
            String dumpName = core.getDumpName();
            int p = dumpName.lastIndexOf("\\");
            if (p == -1) {
                p = dumpName.lastIndexOf("/");
            }
            dir = dumpName.substring(0, p + 1);
            String exec1 = dir.concat(exec);
            v.add(exec1);
            exec1 = dir.concat(command);
            v.add(exec1);
        }
        boolean found = false;
        Iterator list = v.iterator();
        while (!found && list.hasNext()) {
            execFileName = ((String)list.next()).trim();
            try {
                execRAF = new RandomAccessFile(execFileName, "r");
                found = true;
                break;
            }
            catch (FileNotFoundException e) {
            }
        }
        if (found && execFileName != null) {
            Elfdump execRdr = null;
            try {
                execRdr = new Elfdump(execFileName, true, false, 0L);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
            Iterator it = execRdr.pT_Dynamic_Entries.iterator();
            retFileNames.add(execFileName);
            while (it.hasNext()) {
                ProgramHeaderElement pHE = (ProgramHeaderElement)it.next();
                long loadedPtr = pHE.virtaddr;
                int i = core.findWhichMemoryRange(loadedPtr);
                if (i != -1) {
                    if (createModules) {
                        modules.add(new J9Module(execRdr.getDumpName(), loadedPtr, pHE.memsize));
                    }
                    core.seekToMemoryAddress(loadedPtr);
                    try {
                        long tag = core.readPtr();
                        while (tag != 0L) {
                            if (tag == 21L) {
                                long linkMapPtr;
                                long address = core.readPtr();
                                core.seekToMemoryAddress(address);
                                long r_version = core.readPtr();
                                long next = linkMapPtr = core.readPtr();
                                while (next != 0L) {
                                    MemoryRange mr;
                                    core.seekToMemoryAddress(next);
                                    long addr1 = core.readPtr();
                                    long section = core.readPtr();
                                    long dynamic = core.readPtr();
                                    next = core.readPtr();
                                    if (addr1 == 0L) continue;
                                    core.seekToMemoryAddress(section);
                                    String name = core.readString();
                                    retFileNames.add(name);
                                    if (!createModules) continue;
                                    long size = -1L;
                                    int memRangeId = core.findWhichMemoryRange(addr1);
                                    if (-1 != memRangeId && (mr = core.getMemoryRanges()[memRangeId]).getVaddr() == addr1) {
                                        size = mr.getSize();
                                    }
                                    modules.add(new J9Module(name, addr1, size));
                                    int lastSlashPosition = name.lastIndexOf("\\");
                                    if (-1 == lastSlashPosition) {
                                        lastSlashPosition = name.lastIndexOf("/");
                                    }
                                    name = dir.concat(name.substring(lastSlashPosition + 1));
                                    try {
                                        Elfdump module = new Elfdump(name, false, true, addr1);
                                    }
                                    catch (FileNotFoundException fnfe) {}
                                }
                                tag = 0L;
                                continue;
                            }
                            core.readPtr();
                            tag = core.readPtr();
                        }
                        continue;
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                return null;
            }
        }
        for (int i = 0; i < modules.size(); ++i) {
            J9Module j9m = (J9Module)modules.get(i);
            proc.addModule(modules.size(), i, j9m.getName(), j9m.getStartAddress(), j9m.getSize());
        }
        debugFiles = retFileNames;
        return retFileNames;
    }

    private void readStringTable() {
        try {
            this.seek(this.sectionHeaderOffset + this.stringTable * this.sectionHeaderEntrySize);
            boolean bDone = false;
            SectionHeaderElement stSectionHeader = SectionHeaderElement.readSectionHeaderElement(this, this.is32bit());
            if (stSectionHeader.sh_off != 0L && stSectionHeader.sh_size > 0L) {
                this.seek(stSectionHeader.sh_off);
                byte[] stBytes = new byte[(int)stSectionHeader.sh_size];
                this.read(stBytes);
                this.stringTableEntries = this.convertByteArrayToStringTable(stBytes);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setExec(boolean isExec) {
        this.isExec = isExec;
    }

    private void createSymbols(SectionHeaderElement symtabEl) {
        byte[] ba = null;
        String modname = this.dumpName;
        int lastSlashPosition = this.dumpName.lastIndexOf("\\");
        if (-1 == lastSlashPosition) {
            lastSlashPosition = this.dumpName.lastIndexOf("/");
        }
        if (-1 != lastSlashPosition) {
            modname = this.dumpName.substring(lastSlashPosition + 1) + "::";
        }
        modname.concat("::");
        try {
            SectionHeaderElement stringTableEl = (SectionHeaderElement)this.shVector.get((int)symtabEl.sh_link);
            this.seek(stringTableEl.sh_off);
            ba = new byte[(int)stringTableEl.sh_size];
            this.read(ba);
        }
        catch (IOException ioe) {
            return;
        }
        try {
            this.seek(symtabEl.sh_off);
            int count = (int)symtabEl.sh_size / 24;
            long st_name = 0L;
            long st_value = 0L;
            byte st_info = 0;
            byte st_other = 0;
            short st_shndx = 0;
            if (this.is32bit()) {
                count *= 2;
                for (int i = 0; i < count; ++i) {
                    String funcName;
                    st_name = this.readUnsignInt();
                    st_value = this.readUnsignInt();
                    long st_size = this.readUnsignInt();
                    st_info = this.readByte();
                    st_other = this.readByte();
                    st_shndx = this.readShortEx();
                    if (st_info != 2 && st_info != 18 || (funcName = this.getStringFromByteArray(ba, (int)st_name)) == null || st_value == 0L) continue;
                    if (this.isDll) {
                        st_value += this.dllLoadPoint;
                    }
                    Symbol symbol = new Symbol(modname + funcName, st_value, (int)st_size, 2, st_info);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    String funcName;
                    st_name = this.readUnsignInt();
                    st_info = this.readByte();
                    st_other = this.readByte();
                    st_shndx = this.readShortEx();
                    st_value = this.readUnsignLong();
                    long st_size = this.readUnsignLong();
                    if (st_info != 2 && st_info != 18 || (funcName = this.getStringFromByteArray(ba, (int)st_name)) == null || st_value == 0L) continue;
                    if (this.isDll) {
                        st_value += this.dllLoadPoint;
                    }
                    Symbol symbol = new Symbol(modname + funcName, st_value, (int)st_size, 2, st_info);
                }
            }
        }
        catch (IOException ioe) {
            return;
        }
    }

    private Vector convertByteArrayToStringTable(byte[] stBytes) {
        Vector<String> v = new Vector<String>();
        int prevPos = 0;
        for (int i = 0; i < stBytes.length; ++i) {
            if (stBytes[i] != 0) continue;
            String s = new String(stBytes, prevPos, i - prevPos);
            prevPos = i + 1;
            v.add(s);
        }
        return v;
    }

    private String getStringFromByteArray(byte[] stBytes, int offset) {
        String retString = null;
        try {
            for (int i = offset; i < stBytes.length; ++i) {
                if (stBytes[i] != 0) continue;
                retString = new String(stBytes, offset, i - offset);
                return retString;
            }
        }
        catch (Exception e) {
            boolean z = true;
        }
        return retString;
    }

    public void setDll(boolean isDll) {
        this.isDll = isDll;
    }

    static {
        Dump.registerDumpSupport(Elfdump.class);
        archStrings = new String[100];
        Elfdump.archStrings[2] = "Sun Sparc";
        Elfdump.archStrings[3] = "IA/32";
        Elfdump.archStrings[50] = "IA/64";
        Elfdump.archStrings[20] = "PPC/32";
        Elfdump.archStrings[21] = "PPC/64";
        Elfdump.archStrings[22] = "s390";
        Elfdump.archStrings[62] = "AMD64";
    }

    class PrPsInfo
    extends J9Process {
        long pid;
        long signalNumber;
        long thread;

        PrPsInfo(String name) {
            super(name, 0);
        }

        PrPsInfo(PrPsInfo process, long end) throws IOException {
            super("ELFProc", 0);
            if (process != null) {
                this.pid = process.pid;
                this.signalNumber = process.signalNumber;
                ((J9Process)this).signalNumber = (int)process.signalNumber;
                this.SignalNumberAvailable = true;
                this.threads = process.threads;
            }
            process = this;
            byte[] buffer = Elfdump.this.bIs32Bit ? new byte[4] : new byte[8];
            Elfdump.this.readBuffer(buffer);
            long state = buffer[0];
            long sname = buffer[1];
            long zombie = buffer[2];
            long nice = buffer[3];
            long flags = 0L;
            flags = Elfdump.this.bIs32Bit ? (long)Elfdump.this.readIntEx() : Elfdump.this.readLongEx();
            long uid = Elfdump.this.readUid();
            long gid = Elfdump.this.readUid();
            long pid = Elfdump.this.readWord();
            this.setProcessName(Long.toString(pid));
            long ppid = Elfdump.this.readWord();
            long pgrp = Elfdump.this.readWord();
            long sid = Elfdump.this.readWord();
            Elfdump.this.seek(end - 96L);
            this.command = Elfdump.this.readString(16).trim();
            this.commandLine = Elfdump.this.readString(80).trim();
            this.generateExecutable(this.command, this.commandLine);
        }

        void generateExecutable(String command, String commandLine) {
            this.command = command;
            this.commandLine = commandLine;
            StringTokenizer t = new StringTokenizer(commandLine, " ");
            if (t.hasMoreTokens()) {
                this.executable = t.nextToken();
            }
        }
    }

    class prStatus
    extends GenericThread {
        prStatus() throws IOException {
            super("threadId", 0L, 0, 0);
            long signalNumber = Elfdump.this.readIntEx();
            long code = Elfdump.this.readIntEx();
            long errno = Elfdump.this.readIntEx();
            long cursig = Elfdump.this.readHalf();
            long dummy = Elfdump.this.readHalf();
            long pending = 0L;
            long blocked = 0L;
            if (Elfdump.this.bIs32Bit) {
                pending = Elfdump.this.readIntEx();
                blocked = Elfdump.this.readIntEx();
            } else {
                pending = Elfdump.this.readLongEx();
                blocked = Elfdump.this.readLongEx();
            }
            long pid = Elfdump.this.readIntEx();
            long ppid = Elfdump.this.readIntEx();
            long pgroup = Elfdump.this.readIntEx();
            long session = Elfdump.this.readIntEx();
            long utime_sec = 0L;
            long utime_usec = 0L;
            long stime_sec = 0L;
            long stime_usec = 0L;
            long cutime_sec = 0L;
            long cutime_usec = 0L;
            long cstime_sec = 0L;
            long cstime_usec = 0L;
            if (Elfdump.this.bIs32Bit) {
                utime_sec = Elfdump.this.readIntEx();
                utime_usec = Elfdump.this.readIntEx();
                stime_sec = Elfdump.this.readIntEx();
                stime_usec = Elfdump.this.readIntEx();
                cutime_sec = Elfdump.this.readIntEx();
                cutime_usec = Elfdump.this.readIntEx();
                cstime_sec = Elfdump.this.readIntEx();
                cstime_usec = Elfdump.this.readIntEx();
            } else {
                utime_sec = Elfdump.this.readLongEx();
                utime_usec = Elfdump.this.readLongEx();
                stime_sec = Elfdump.this.readLongEx();
                stime_usec = Elfdump.this.readLongEx();
                cutime_sec = Elfdump.this.readLongEx();
                cutime_usec = Elfdump.this.readLongEx();
                cstime_sec = Elfdump.this.readLongEx();
                cstime_usec = Elfdump.this.readLongEx();
            }
            switch (Elfdump.this.machine) {
                case 20: 
                case 21: {
                    this.readRegistersPPC();
                    break;
                }
                case 50: {
                    this.readRegistersIA64();
                    break;
                }
                case 22: {
                    this.readRegistersS390();
                    break;
                }
                default: {
                    this.readRegistersIA32();
                }
            }
            if (this.context != null) {
                long spValue = this.context.getSp();
                int mrId = Elfdump.this.findWhichMemoryRange(spValue);
                if (mrId != -1) {
                    this.stacksize = (int)Elfdump.this.getMemoryRanges()[mrId].getSize();
                    this.stackstart = Elfdump.this.getMemoryRanges()[mrId].getVaddr();
                }
                Elfdump.this.analyseStack(this);
            }
        }

        void readRegistersIA32() throws IOException {
            int ebx = Elfdump.this.readIntEx();
            int ecx = Elfdump.this.readIntEx();
            int edx = Elfdump.this.readIntEx();
            int esi = Elfdump.this.readIntEx();
            int edi = Elfdump.this.readIntEx();
            int ebp = Elfdump.this.readIntEx();
            long eax = Elfdump.this.readIntEx();
            int ds = Elfdump.this.readIntEx();
            int es = Elfdump.this.readIntEx();
            int fs = Elfdump.this.readIntEx();
            int gs = Elfdump.this.readIntEx();
            int orig_eax = Elfdump.this.readIntEx();
            int eip = Elfdump.this.readIntEx();
            int cs = Elfdump.this.readIntEx();
            int efl = Elfdump.this.readIntEx();
            int esp = Elfdump.this.readIntEx();
            int ss = Elfdump.this.readIntEx();
            this.addRegister(new Register("ebx", 32, ebx));
            this.addRegister(new Register("ecx", 32, ecx));
            this.addRegister(new Register("edx", 32, edx));
            this.addRegister(new Register("esi", 32, esi));
            this.addRegister(new Register("edi", 32, edi));
            this.addRegister(new Register("ebp", 32, ebp));
            this.addRegister(new Register("eax", 32, eax));
            this.addRegister(new Register("ds", 32, ds));
            this.addRegister(new Register("es", 32, es));
            this.addRegister(new Register("fs", 32, fs));
            this.addRegister(new Register("gs", 32, gs));
            this.addRegister(new Register("cs", 32, cs));
            this.addRegister(new Register("efl", 32, efl));
            this.addRegister(new Register("esp", 32, esp));
            this.addRegister(new Register("eip", 32, eip));
            this.addRegister(new Register("ss", 32, ss));
            this.context = new NativeThreadContext(32, 0L, eip, 0L, esp, ebp);
        }

        void readRegistersIA64() throws IOException {
            for (int i = 0; i < 32; ++i) {
                Elfdump.this.readLongEx();
            }
            long nat = Elfdump.this.readLongEx();
            long pr = Elfdump.this.readLongEx();
            for (int i = 0; i < 8; ++i) {
                Elfdump.this.readLongEx();
            }
            long ip = Elfdump.this.readLongEx();
            long cfm = Elfdump.this.readLongEx();
            long psr = Elfdump.this.readLongEx();
            long rsc = Elfdump.this.readLongEx();
            long bsp = Elfdump.this.readLongEx();
            long bspstore = Elfdump.this.readLongEx();
            long rnat = Elfdump.this.readLongEx();
            long ccv = Elfdump.this.readLongEx();
            long unat = Elfdump.this.readLongEx();
            long fpsr = Elfdump.this.readLongEx();
            long pfs = Elfdump.this.readLongEx();
            long lc = Elfdump.this.readLongEx();
            long ec = Elfdump.this.readLongEx();
            Elfdump.this.readBuffer(new byte[584]);
            this.addRegister(new Register("nat", 64, nat));
            this.addRegister(new Register("pr", 64, pr));
            this.addRegister(new Register("ip", 64, ip));
            this.addRegister(new Register("cfm", 64, cfm));
            this.addRegister(new Register("psr", 64, psr));
            this.addRegister(new Register("rsc", 64, rsc));
            this.addRegister(new Register("bsp", 64, bsp));
            this.addRegister(new Register("bspstore", 64, bspstore));
            this.addRegister(new Register("rnat", 64, rnat));
            this.addRegister(new Register("ccv", 64, ccv));
            this.addRegister(new Register("unat", 64, unat));
            this.addRegister(new Register("fpsr", 64, fpsr));
            this.addRegister(new Register("pfs", 64, pfs));
            this.addRegister(new Register("lc", 64, lc));
            this.addRegister(new Register("ec", 64, ec));
            this.context = null;
        }

        void readRegistersPPC() throws IOException {
            long[] gpr = new long[32];
            for (int i = 0; i < 32; ++i) {
                gpr[i] = Elfdump.this.readPtr();
            }
            long nip = Elfdump.this.readPtr();
            long msr = Elfdump.this.readPtr();
            long origgpr3 = Elfdump.this.readPtr();
            long ctr = Elfdump.this.readPtr();
            long link = Elfdump.this.readPtr();
            long xer = Elfdump.this.readPtr();
            long ccr = Elfdump.this.readPtr();
            long mq = Elfdump.this.readPtr();
            long trap = Elfdump.this.readPtr();
            long dar = Elfdump.this.readPtr();
            long dsisr = Elfdump.this.readPtr();
            long result = Elfdump.this.readPtr();
            long q1 = Elfdump.this.readPtr();
            long q2 = Elfdump.this.readPtr();
            long q3 = Elfdump.this.readPtr();
            long q4 = Elfdump.this.readPtr();
            int ptrSize = 64;
            if (Elfdump.this.bIs32Bit) {
                ptrSize = 32;
            }
            for (int i = 0; i < 32; ++i) {
                this.addRegister(new Register("gpr" + i, ptrSize, gpr[i]));
            }
            this.addRegister(new Register("nat", ptrSize, nip));
            this.addRegister(new Register("pr", ptrSize, msr));
            this.addRegister(new Register("ip", ptrSize, origgpr3));
            this.addRegister(new Register("cfm", ptrSize, ctr));
            this.addRegister(new Register("psr", ptrSize, link));
            this.addRegister(new Register("rsc", ptrSize, xer));
            this.addRegister(new Register("bsp", ptrSize, ccr));
            this.addRegister(new Register("bspstore", ptrSize, mq));
            this.addRegister(new Register("rnat", ptrSize, trap));
            this.addRegister(new Register("ccv", ptrSize, dar));
            this.addRegister(new Register("unat", ptrSize, dsisr));
            this.addRegister(new Register("fpsr", ptrSize, result));
            this.addRegister(new Register("pfs", ptrSize, q1));
            this.addRegister(new Register("lc", ptrSize, q2));
            this.addRegister(new Register("ec", ptrSize, q3));
            this.addRegister(new Register("fpvalid", ptrSize, q4));
            this.context = new NativeThreadContext(ptrSize, 0L, nip, link, gpr[1], gpr[15]);
        }

        void readRegistersS390() throws IOException {
            int i;
            int i2;
            long[] gpr = new long[16];
            long[] acr = new long[16];
            long mask = Elfdump.this.readPtr();
            long addr = Elfdump.this.readPtr();
            for (i2 = 0; i2 < 16; ++i2) {
                gpr[i2] = Elfdump.this.readPtr();
            }
            for (i2 = 0; i2 < 16; ++i2) {
                acr[i2] = Elfdump.this.readWord();
            }
            long origgpr2 = Elfdump.this.readPtr();
            long trap = Elfdump.this.readWord();
            int ptrSize = 64;
            long old_ilc = 0L;
            if (Elfdump.this.bIs32Bit) {
                ptrSize = 32;
                old_ilc = Elfdump.this.readWord();
            }
            for (i = 0; i < 16; ++i) {
                this.addRegister(new Register("gpr" + i, ptrSize, gpr[i]));
            }
            for (i = 0; i < 16; ++i) {
                this.addRegister(new Register("acr" + i, ptrSize, acr[i]));
            }
            this.addRegister(new Register("mask", ptrSize, mask));
            this.addRegister(new Register("addr", ptrSize, addr));
            this.addRegister(new Register("origgpr2", ptrSize, origgpr2));
            this.addRegister(new Register("trap", ptrSize, trap));
            if (Elfdump.this.bIs32Bit) {
                this.addRegister(new Register("old_ilc", ptrSize, old_ilc));
            }
            this.context = new NativeThreadContext(ptrSize, 0L, addr, 0L, gpr[15], 0L);
        }
    }
}

