/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.j9.dump.command.trace;

import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.j9.dump.command.DumpBaseCmds;
import com.ibm.jvm.j9.dump.command.J9JVMBaseCmds;
import com.ibm.jvm.j9.dump.command.trace.J9TraceFormatterListener;
import com.ibm.jvm.j9.dump.commandconsole.Console;
import com.ibm.jvm.j9.dump.commandconsole.J9JVMConsole;
import com.ibm.jvm.j9.dump.systemdump.Dump;
import com.ibm.jvm.j9.dump.systemdump.J9TraceBuffer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class J9JVMBaseTraceCommands {
    private static Dump theDump;
    private static J9JVMBaseCmds caller;
    private static String snapTraceFileName;
    private static String snapTraceOutputFileName;
    private static String snapTraceInfoFileName;
    private static String savedFileName;
    private static int waitFlag;
    private static boolean verbose;
    private static int traceOutStart;
    private static int traceOutPage;
    public static final String FAIL_STRING = "Failed";
    public static final String NO_TRACE_BUFFERS = "No Buffers";

    public J9JVMBaseTraceCommands(J9JVMBaseCmds callerIn) {
        theDump = DumpBaseCmds.getTheDump();
        caller = callerIn;
    }

    public String traceFormat(String parms) {
        String retString = FAIL_STRING;
        if (!this.isTraceEnabled()) {
            caller.notifyObservers("\nCannot format trace - There are no trace buffers in this dump.");
        } else {
            if (snapTraceFileName == null) {
                retString = this.traceExtract(null);
                caller.notifyObservers("\n\n");
            }
            if (!retString.equals(FAIL_STRING)) {
                retString = FAIL_STRING;
                if (Console.getProperty("TRACE_DATADIR") == null || Console.getProperty("TRACE_DATADIR").toUpperCase().equals("NULL")) {
                    String dumpName = theDump.getDumpName();
                    int lastSlashPosition = dumpName.lastIndexOf("\\");
                    if (-1 == lastSlashPosition) {
                        lastSlashPosition = dumpName.lastIndexOf("/");
                    }
                    if (-1 != lastSlashPosition) {
                        String dir = dumpName.substring(0, lastSlashPosition + 1);
                        String trace_file_name1 = dir.concat("J9TraceFormat.dat");
                        String trace_file_name2 = dir.concat("TraceFormat.dat");
                        File f = new File(trace_file_name1);
                        if (f.exists() && (f = new File(trace_file_name2)).exists()) {
                            this.traceDatadir(dir);
                        }
                    }
                }
                caller.notifyObservers("Running Trace Formatter\n=======================");
                if (snapTraceFileName != null) {
                    String[] args = this.buildFormatArgs();
                    caller.notifyObservers("input file:   \"" + args[0] + "\"");
                    caller.notifyObservers("output file:  \"" + args[1] + "\"");
                    for (int i = 2; i < args.length; ++i) {
                        caller.notifyObservers("option:       " + args[i]);
                    }
                    caller.notifyObservers("\n\n");
                    retString = this.doTraceFormat(args);
                } else {
                    caller.notifyObservers("\nERROR: Problem reading extracted trace file.\n");
                }
            }
        }
        return retString;
    }

    public String traceExtract(String parms) {
        String retString = FAIL_STRING;
        if (this.isTraceEnabled()) {
            caller.notifyObservers("\nRunning Dump Extractor\n======================");
            if (snapTraceFileName == null) {
                retString = this.doCreateTraceFile();
            } else {
                caller.notifyObservers("\nThe file already exists and will be used.\nThe trace filename is: \"" + snapTraceFileName + "\"");
                retString = snapTraceFileName;
            }
        } else {
            caller.notifyObservers("\nCannot Extract - There are no trace buffers in this dump.");
            retString = "NoBuffers";
        }
        return retString;
    }

    public String traceSummary(String parms) {
        String retString = null;
        caller.notifyObservers("Display Trace Summary\n=====================\n");
        if (snapTraceFileName != null) {
            String[] summaryArgs = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
            this.doTraceFormat(summaryArgs);
        } else {
            caller.notifyObservers("\nThe trace file must already exist before the TRACE SUMMARY command is run.\n(Use TRACE EXTRACT or TRACE FORMAT before running TRACE SUMMARY).");
        }
        return retString;
    }

    public String traceDisplay(String theRest) {
        String retString = null;
        if (snapTraceOutputFileName == null) {
            caller.notifyObservers("Unable to comply - trace must first be formatted.");
            return null;
        }
        if (theRest == null || theRest.equals("")) {
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else if (theRest.length() > 5 && theRest.toUpperCase().substring(0, 5).equals("PAGE ")) {
            String number = new String(theRest.substring(5));
            Integer x = new Integer(number);
            if (x >= 5 && x <= 10001) {
                caller.notifyObservers("\nPage size set to " + x);
                traceOutPage = x;
            } else {
                caller.notifyObservers("\nERROR: Page size must be between 5 and 10000.");
            }
        } else if (theRest.toUpperCase().equals("ALL")) {
            caller.notifyObservers("");
            this.displayFile(snapTraceOutputFileName, 1, 1000000);
        } else if (theRest.substring(0, 1).equals("+")) {
            caller.notifyObservers("");
            if (!this.displayFile(snapTraceOutputFileName, traceOutStart += traceOutPage, traceOutStart + traceOutPage - 1) && (traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
        } else if (theRest.substring(0, 1).equals("-")) {
            if ((traceOutStart -= traceOutPage) < 1) {
                traceOutStart = 1;
            }
            caller.notifyObservers("");
            this.displayFile(snapTraceOutputFileName, traceOutStart, traceOutStart + traceOutPage - 1);
        } else {
            caller.notifyObservers("Usage Error:\n   TRACE DISPLAY [ + | - | ALL ]");
        }
        return retString;
    }

    public String traceThreads(String parms) {
        String retString = null;
        Object ps = null;
        ArrayList<String> validThreads = new ArrayList<String>();
        boolean threadDisplay = true;
        caller.notifyObservers("Display Threads\n===============\n");
        if (snapTraceFileName == null) {
            caller.notifyObservers("The trace file does not exist so threads cannot be displayed.\n(Use TRACE FORMAT or EXTRACT before running TRACE THREADS).");
            threadDisplay = false;
        }
        if (threadDisplay && snapTraceInfoFileName == null) {
            this.cacheSummaryInfo();
        }
        boolean start = false;
        String line = null;
        BufferedReader br = null;
        if (threadDisplay) {
            try {
                br = new BufferedReader(new FileReader(snapTraceFileName + ".info"));
                while (br.ready()) {
                    line = br.readLine();
                    if (start) {
                        if (line.trim().toUpperCase().equals("")) {
                            start = false;
                        } else {
                            String threadLine = line.trim();
                            caller.notifyObservers("THREAD: 0x" + threadLine);
                            String arrayListElement = new String("0x" + threadLine.substring(0, threadLine.indexOf(" "))).toUpperCase();
                            validThreads.add(arrayListElement);
                        }
                    }
                    if (!line.trim().toUpperCase().equals("ACTIVE THREADS :")) continue;
                    start = true;
                }
                br.close();
            }
            catch (Exception e) {
                caller.notifyObservers("ERROR: Unexpected exception reading " + snapTraceFileName + ".info " + "(" + e + ", " + e.getMessage() + ")");
                e.printStackTrace();
            }
        }
        caller.notifyObservers(" ");
        if (parms == null) {
            this.checkThreadArgs("NONE", validThreads, threadDisplay);
        } else {
            this.checkThreadArgs(parms, validThreads, threadDisplay);
        }
        return retString;
    }

    public String traceEntries(String parms) {
        String retString = null;
        caller.notifyObservers("Query/Set Entries Option\n========================\n");
        if (parms == null) {
            String s = null;
            try {
                s = Console.getProperty("TRACE_ENTRIES");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null == s) {
                s = "ALL";
            }
            caller.notifyObservers("TRACE_ENTRIES = " + s);
        } else {
            boolean allTokensAreAllowed = true;
            if (!parms.toUpperCase().equals("ALL")) {
                StringTokenizer st = new StringTokenizer(parms, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().toLowerCase();
                    StringTokenizer st2 = J9JVMBaseTraceCommands.getValidTraceEntries();
                    boolean tokenIsAllowed = false;
                    while (st2.hasMoreTokens() && !tokenIsAllowed) {
                        String allowedToken = st2.nextToken().toLowerCase();
                        if (!token.equals(allowedToken)) continue;
                        tokenIsAllowed = true;
                    }
                    if (tokenIsAllowed) continue;
                    caller.notifyObservers("ERROR: invalid token - " + token + "\n");
                    allTokensAreAllowed = false;
                }
            }
            if (allTokensAreAllowed) {
                Console.setProperty("TRACE_ENTRIES", parms.toUpperCase());
                caller.notifyObservers("TRACE_ENTRIES = " + Console.getProperty("TRACE_ENTRIES"));
            } else {
                StringTokenizer st2 = J9JVMBaseTraceCommands.getValidTraceEntries();
                String s = "Allowed options are:";
                while (st2.hasMoreTokens()) {
                    s = s + "\n\t" + st2.nextToken();
                }
                caller.notifyObservers(s);
                caller.notifyObservers("\nTRACE_ENTRIES = " + Console.getProperty("TRACE_ENTRIES") + " (unchanged)");
            }
        }
        return retString;
    }

    public String traceIVS(String noun, String parms) {
        String retString = null;
        caller.notifyObservers("Query/Set Formatted Trace Options\n=================================\n");
        noun = noun.toUpperCase();
        if (noun.equals("SYMBOLIC") || noun.equals("VERBOSE") || noun.equals("INDENT")) {
            this.doTraceCMD("TRACE_" + noun, parms);
        } else {
            caller.notifyObservers("Usage error:\n   unrecognised TRACE option: " + noun);
        }
        return retString;
    }

    private void doTraceCMD(String cmd, String parms) {
        if (parms == null) {
            String s = null;
            s = Console.getProperty(cmd);
            if (null == s) {
                s = "false";
            }
            caller.notifyObservers(cmd + " = " + s);
        } else {
            StringTokenizer st = new StringTokenizer(parms, " ");
            if (st.countTokens() == 2) {
                st.nextToken();
                parms = st.nextToken();
            }
            try {
                if (parms.toUpperCase().equals("TRUE")) {
                    Console.setProperty(cmd, "true");
                    caller.notifyObservers(cmd + " = true");
                    if (cmd.toUpperCase().equals("VERBOSE")) {
                        verbose = true;
                    }
                } else if (parms.toUpperCase().equals("FALSE")) {
                    Console.setProperty(cmd, "false");
                    caller.notifyObservers(cmd + " = false");
                    if (cmd.toUpperCase().equals("VERBOSE")) {
                        verbose = false;
                    }
                } else {
                    caller.notifyObservers("Usage Error:\n   TRACE " + cmd.substring(6, cmd.length()) + " true|false");
                }
            }
            catch (Exception e) {
                caller.notifyObservers("ERROR: Exception setting TRACE_" + cmd + " (" + e.getMessage() + ")");
            }
        }
    }

    public String traceDatadir(String parms) {
        String retString = null;
        caller.notifyObservers("Query/Set Data directory\n========================\n");
        if (parms != null) {
            if (parms.equals("NULL")) {
                Console.setProperty("TRACE_DATADIR", "NULL");
                caller.notifyObservers("TRACE_DATADIR property cleared.\n");
            } else {
                if (parms != null && parms.indexOf(" ") != -1) {
                    parms = parms.substring(0, parms.indexOf(" "));
                }
                caller.notifyObservers("attempting to set TRACE_DATADIR to:\n   " + parms);
                File dir = new File(parms);
                String datFilename = new String(dir + System.getProperty("file.separator") + "TraceFormat.dat");
                if (dir.exists() && dir.isDirectory() && new File(datFilename).exists()) {
                    Console.setProperty("TRACE_DATADIR", parms);
                    caller.notifyObservers("TRACE_DATADIR set to:\n   " + parms + "\n");
                } else {
                    caller.notifyObservers("ERROR: TraceFormat.dat cannot be found in the specified directory.\n");
                }
            }
        }
        String s = null;
        if (Console.getProperty("TRACE_DATADIR").toUpperCase().equals("NULL")) {
            String default_dir = System.getProperty("java.home");
            default_dir = default_dir.concat(File.separator).concat("lib");
            s = System.getProperty("ibm.dg.trc.format", default_dir);
        } else {
            s = Console.getProperty("TRACE_DATADIR");
        }
        caller.notifyObservers("Trace formatter will use TraceFormat.dat from:\n   " + s);
        return retString;
    }

    public String traceSet(String parms) {
        String retString = null;
        caller.notifyObservers("OPTIONS FOR TRACE FORMATTER\n===========================\n");
        if (parms != null) {
            StringTokenizer st = new StringTokenizer(parms, "= ");
            while (st.hasMoreTokens()) {
                String option = null;
                String value = null;
                if (st.hasMoreTokens()) {
                    option = st.nextToken().toUpperCase();
                }
                if (st.hasMoreTokens()) {
                    value = st.nextToken();
                }
                if (option == null || value == null) {
                    caller.notifyObservers("Usage Error:\n   TRACE SET [<option>=<value>]");
                    continue;
                }
                if (option.equals("VERBOSE") || option.equals("SYMBOLIC") || option.equals("INDENT") || option.equals("ENTRIES") || option.equals("OUTFILENAME") || option.equals("THREADS") || option.equals("DATADIR")) {
                    if (option.equals("VERBOSE")) {
                        this.traceIVS("VERBOSE", parms);
                    }
                    if (option.equals("INDENT")) {
                        this.traceIVS("INDENT", parms);
                    }
                    if (option.equals("SYMBOLIC")) {
                        this.traceIVS("SYMBOLIC", parms);
                    }
                    if (option.equals("THREADS")) {
                        this.traceThreads(parms);
                    }
                    if (option.equals("ENTRIES")) {
                        this.traceEntries(parms);
                    }
                    if (option.equals("OUTFILENAME")) {
                        this.traceOutfilename(parms);
                    }
                    if (!option.equals("DATADIR")) continue;
                    this.traceDatadir(parms);
                    continue;
                }
                caller.notifyObservers("Usage Error:\n   TRACE SET [<OUTFILENAME|THREADS|SYMBOLIC|INDENT|ENTRIES|VERBOSE|<DATADIR>>=<value>]");
            }
        }
        String dump = J9JVMConsole.getProperty("dump");
        String workdir = Console.getProperty("WORKDIR");
        if (null != workdir) {
            String dumpFn = Console.getProperty("dump");
            File file = new File(dumpFn);
            dump = workdir + File.separator + file.getName();
        }
        caller.notifyObservers("\nTRACE_INFILENAME  = \"" + dump + ".trc\"  ");
        String s = Console.getProperty("TRACE_OUTFILENAME");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            s = "<not set - will default to \"" + dump + ".trc.fmt\">";
        }
        caller.notifyObservers("TRACE_OUTFILENAME = " + s);
        s = Console.getProperty("TRACE_THREADS");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            s = "<not set - will default to ALL>";
        }
        caller.notifyObservers("TRACE_THREADS     = " + s);
        s = Console.getProperty("TRACE_SYMBOLIC");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            s = "<not set - will default to false>";
        }
        caller.notifyObservers("TRACE_SYMBOLIC    = " + s);
        s = Console.getProperty("TRACE_INDENT");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            s = "<not set - will default to false>";
        }
        caller.notifyObservers("TRACE_INDENT      = " + s);
        s = Console.getProperty("TRACE_ENTRIES");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            s = "<not set - will default to ALL>";
        }
        caller.notifyObservers("TRACE_ENTRIES     = " + s);
        s = Console.getProperty("TRACE_VERBOSE");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            s = "<not set - will default to false>";
        }
        caller.notifyObservers("TRACE_VERBOSE     = " + s);
        s = Console.getProperty("TRACE_DATADIR");
        if (null == s) {
            s = "NULL";
        }
        if (s.toUpperCase().equals("NULL")) {
            String default_dir = System.getProperty("java.home");
            default_dir = default_dir.concat(File.separator).concat("lib");
            s = System.getProperty("ibm.dg.trc.format", default_dir);
            s = "<not set - will default to:\n                    " + s + ">";
        }
        caller.notifyObservers("TRACE_DATADIR     = " + s);
        return retString;
    }

    public String traceOutfilename(String parms) {
        String retString = null;
        caller.notifyObservers("Query/Set Formatted Trace File Name\n===================================\n");
        if (parms == null) {
            String s = null;
            try {
                s = Console.getProperty("TRACE_OUTFILENAME");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (s == null) {
                s = "extracted.trc.fmt";
            }
            caller.notifyObservers("trace out file name = \"" + s + "\"");
        } else {
            try {
                Console.setProperty("TRACE_OUTFILENAME", parms);
                caller.notifyObservers("TRACE_OUTFILENAME = " + parms);
            }
            catch (Exception e) {
                caller.notifyObservers("ERROR: Exception setting TRACE_OUTFILENAME (" + e.getMessage() + ")");
            }
        }
        caller.notifyObservers("\nNOTE - Embedding %T in an outfilename, e.g.: \"TRACE OUTFILENAME thread.%T.fmt\"\n       will cause the threadid to be inserted at that point when tracing a\n       single thread.");
        return retString;
    }

    private boolean isTraceEnabled() {
        return J9JVMConsole.getTraceBuffers().size() > 0;
    }

    private String doCreateTraceFile() {
        String retFileName = FAIL_STRING;
        caller.notifyObservers("Processing Trace File Header\n----------------------------");
        try {
            String verboseness = Console.getProperty("TRACE_VERBOSE");
            verbose = verboseness.toUpperCase().equals("TRUE");
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        String workdir = Console.getProperty("WORKDIR");
        if (null == workdir) {
            snapTraceFileName = J9JVMConsole.getProperty("dump") + ".trc";
        } else {
            String dumpFn = Console.getProperty("dump");
            File file = new File(dumpFn);
            snapTraceFileName = workdir + File.separator + file.getName() + ".trc";
        }
        try {
            File f = new File(snapTraceFileName);
            f.createNewFile();
        }
        catch (Exception e) {
            caller.notifyObservers(" Unable to create \"" + snapTraceFileName + "\"");
            return retFileName;
        }
        long tfhAddr = J9JVMConsole.getTraceFileHeaderAddress();
        int tfhLength = J9JVMConsole.getTraceFileHeaderLength();
        caller.notifyObservers("address of TraceFileHeader = 0x" + Long.toHexString(tfhAddr));
        caller.notifyObservers("TraceFileHeader length     = " + tfhLength + " (hex 0x" + Long.toHexString(tfhLength) + ")");
        caller.notifyObservers("\nwriting TraceFileHeader");
        J9JVMBaseTraceCommands.writeDataToFile(tfhAddr, tfhLength, "NEW");
        caller.notifyObservers("\nProcessing Trace Buffers\n------------------------");
        int count = 0;
        if (J9JVMConsole.getTraceBuffers().size() > 0) {
            for (J9TraceBuffer buffer : J9JVMConsole.getTraceBuffers()) {
                J9JVMBaseTraceCommands.writeDataToFile(buffer.getStart(), buffer.getLength(), "APPEND");
                ++count;
            }
            retFileName = snapTraceFileName;
        } else {
            caller.notifyObservers("There were no trace buffers identified in the xml.");
        }
        caller.notifyObservers(count + " trace buffers processed.");
        return retFileName;
    }

    private String[] buildFormatArgs() {
        Hashtable<String, String> hashedArgs = new Hashtable<String, String>();
        String s = null;
        s = snapTraceFileName;
        hashedArgs.put("infilename", s);
        s = Console.getProperty("TRACE_OUTFILENAME");
        if (null == s) {
            s = snapTraceFileName.concat(".fmt");
        } else if (s.indexOf("%T") != -1) {
            String firstBit = null;
            String middleBit = null;
            String thirdBit = null;
            String trace_Threads = Console.getProperty("TRACE_THREADS");
            int pos = s.indexOf("%T");
            firstBit = new String("");
            if (pos > 0) {
                firstBit = s.substring(0, pos);
            }
            if (null == trace_Threads || null != trace_Threads && trace_Threads.toUpperCase().equals("ALL")) {
                middleBit = "ALL";
            } else {
                middleBit = trace_Threads;
                if (middleBit.indexOf(",") != -1) {
                    middleBit = "MULTI";
                }
            }
            thirdBit = new String("");
            if (pos < s.length()) {
                thirdBit = s.substring(pos + 2, s.length());
            }
            s = firstBit.concat(middleBit).concat(thirdBit);
        }
        hashedArgs.put("outfilename", s);
        savedFileName = s;
        s = Console.getProperty("TRACE_THREADS");
        if (null != s && !s.equals("ALL") && !s.equals("NULL")) {
            hashedArgs.put("thread", "-thread:" + s);
        }
        if (null != (s = Console.getProperty("TRACE_INDENT")) && s.toUpperCase().equals("TRUE")) {
            hashedArgs.put("indent", "-indent");
        }
        if (null != (s = Console.getProperty("TRACE_SYMBOLIC")) && s.toUpperCase().equals("TRUE")) {
            hashedArgs.put("symbolic", "-symbolic");
        }
        if (null != (s = Console.getProperty("TRACE_ENTRIES")) && !s.equals("ALL") && !s.equals("NULL")) {
            hashedArgs.put("entries", "-entries:" + s);
        }
        String[] args = new String[hashedArgs.size()];
        int index = 0;
        if (hashedArgs.get("infilename") != null) {
            args[index++] = (String)hashedArgs.get("infilename");
        }
        if (hashedArgs.get("outfilename") != null) {
            args[index++] = (String)hashedArgs.get("outfilename");
        }
        if (hashedArgs.get("thread") != null) {
            args[index++] = (String)hashedArgs.get("thread");
        }
        if (hashedArgs.get("indent") != null) {
            args[index++] = (String)hashedArgs.get("indent");
        }
        if (hashedArgs.get("symbolic") != null) {
            args[index++] = (String)hashedArgs.get("symbolic");
        }
        if (hashedArgs.get("entries") != null) {
            args[index++] = (String)hashedArgs.get("entries");
        }
        return args;
    }

    private String doTraceFormat(String[] args) {
        String retString = FAIL_STRING;
        PipedInputStream pis = null;
        PrintStream ps = null;
        try {
            pis = new PipedInputStream();
            ps = new PrintStream(new PipedOutputStream(pis));
        }
        catch (IOException ioe) {
            caller.notifyObservers("ERROR: Unexpected exception creating output pipe.");
            return retString;
        }
        waitFlag = 0;
        J9TraceFormatterListener tfl = new J9TraceFormatterListener(pis, null, caller);
        tfl.start();
        while (waitFlag < 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                caller.notifyObservers("ERROR: Unexpected exception during sleep.");
                return retString;
            }
        }
        Properties savedSysProps = new Properties();
        savedSysProps.putAll((Map<?, ?>)System.getProperties());
        if (null != Console.getProperty("TRACE_DATADIR")) {
            System.setProperty("ibm.dg.trc.format", Console.getProperty("TRACE_DATADIR"));
        }
        String s = null;
        String default_dir = System.getProperty("java.home");
        default_dir = default_dir.concat(File.separator).concat("lib");
        s = System.getProperty("ibm.dg.trc.format", default_dir);
        s = s.concat(System.getProperty("file.separator")).concat("TraceFormat.dat");
        caller.notifyObservers("Looking for Trace Format data in file: \n   " + s + "\n");
        if (!new File(s).exists()) {
            caller.notifyObservers("ERROR: Unable to format Trace file - TraceFormat.dat does not exist.");
            return retString;
        }
        TraceFormat tf = new TraceFormat(ps, args);
        waitFlag = 2;
        while (waitFlag < 3) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                caller.notifyObservers("ERROR: Unexpected exception during sleep.");
                return retString;
            }
        }
        try {
            ps.close();
            pis.close();
        }
        catch (IOException ioe) {
            caller.notifyObservers("ERROR: unexpected exception closing print stream.");
            return retString;
        }
        System.setProperties(savedSysProps);
        if (snapTraceOutputFileName == null) {
            retString = null != Console.getProperty("TRACE_OUTFILENAME") ? (snapTraceOutputFileName = Console.getProperty("TRACE_OUTFILENAME")) : (snapTraceOutputFileName = new String(snapTraceFileName + ".fmt"));
        }
        return retString;
    }

    private static void writeDataToFile(long startAddr, int numBytes, String isNew) {
        FileOutputStream ostream;
        boolean okSoFar = true;
        byte[] buffer = null;
        boolean append = true;
        if (isNew.toUpperCase().trim().equals("NEW")) {
            append = false;
        }
        caller.notifyObservers("writing 0x" + Long.toHexString(numBytes) + " bytes from address 0x" + Long.toHexString(startAddr) + " to file \"" + snapTraceFileName + "\"");
        try {
            ostream = new FileOutputStream(snapTraceFileName, append);
        }
        catch (IOException ioe) {
            caller.notifyObservers("Exception opening FileOutputStream for " + snapTraceFileName);
            return;
        }
        try {
            buffer = new byte[numBytes];
            theDump.seekToMemoryAddress(startAddr);
            theDump.readFullyEx(buffer);
        }
        catch (Exception e) {
            caller.notifyObservers("Exception trying to put bytes into array");
            okSoFar = false;
        }
        if (okSoFar) {
            try {
                ostream.write(buffer);
            }
            catch (IOException ioe) {
                caller.notifyObservers("Exception writing bytes to " + snapTraceFileName);
            }
        }
        try {
            ostream.close();
        }
        catch (IOException ioe) {
            caller.notifyObservers("Exception closing FileOutputStream");
        }
    }

    public static void setWaitFlag(int waitFlag) {
        J9JVMBaseTraceCommands.waitFlag = waitFlag;
    }

    public static int getWaitFlag() {
        return waitFlag;
    }

    private boolean displayFile(String filename, int fromLine, int toLine) {
        BufferedReader br = null;
        File f = new File(filename);
        FileReader fr = null;
        boolean displayedAnythingYet = false;
        if (!f.exists()) {
            caller.notifyObservers("ERROR: the file " + f.getName() + " doesn't exist");
            return false;
        }
        if (!f.canRead()) {
            caller.notifyObservers("ERROR: Unable to read the file " + f.getName());
            return false;
        }
        int lineNumber = 1;
        String line = null;
        boolean done = false;
        try {
            fr = new FileReader(f);
            br = new BufferedReader(fr);
            while (br.ready() && !done) {
                line = br.readLine();
                if (lineNumber >= fromLine) {
                    if (lineNumber <= toLine) {
                        caller.notifyObservers("[" + lineNumber + "] " + line);
                        displayedAnythingYet = true;
                    } else {
                        done = true;
                    }
                }
                ++lineNumber;
            }
            fr.close();
            br.close();
        }
        catch (Exception e) {
            caller.notifyObservers("ERROR: Unexpected exception reading \"" + snapTraceOutputFileName + "\" (" + e + ", " + e.getMessage() + ")");
            e.printStackTrace();
        }
        return displayedAnythingYet;
    }

    private static StringTokenizer getValidTraceEntries() {
        return new StringTokenizer("dg,st,lk,xe,xm,ci,cl,dc,hpi,xhpi,java,awt,awt_dnd_datatransfer,Audio,jit,jdwp,mt,fontmanager,net,awt_java2d,awt_print", ",");
    }

    private void checkThreadArgs(String paramString, ArrayList validThreads, boolean threadDisplay) {
        boolean stringIn = false;
        if (paramString != null) {
            stringIn = true;
        }
        if (paramString.equals("NONE")) {
            try {
                paramString = Console.getProperty("TRACE_THREADS");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (paramString == null) {
            paramString = "ALL";
        }
        if ((paramString = paramString.toLowerCase()).toUpperCase().equals("ALL")) {
            Console.setProperty("TRACE_THREADS", "ALL");
            caller.notifyObservers("\nThe trace formatter will be run without the -thread option");
            return;
        }
        if (paramString == null) {
            caller.notifyObservers("No optional parameters supplied.");
            return;
        }
        boolean problem = false;
        StringTokenizer st = new StringTokenizer(paramString, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.substring(0, 2).equals("0x")) {
                caller.notifyObservers("ERROR: " + token + " does not must begin \"0x\" (hex)");
                problem = true;
            }
            if (!problem && token.length() == 2) {
                caller.notifyObservers("ERROR: 0x on it's own is not a valid hex number!!");
                problem = true;
            }
            if (!problem) {
                String tokenNum = token.substring(2, token.length());
                try {
                    Long.parseLong(tokenNum, 16);
                }
                catch (NumberFormatException nfe) {
                    caller.notifyObservers("ERROR: " + token + " is not a proper hex number.");
                    problem = true;
                }
            }
            if (!threadDisplay) continue;
            if (validThreads.contains(token.toUpperCase())) {
                caller.notifyObservers(token + " is a valid thread.");
                continue;
            }
            caller.notifyObservers("ERROR: " + token + " is not in list of active threads.");
            problem = true;
        }
        try {
            if (problem) {
                if (!stringIn) {
                    Console.setProperty("TRACE_THREADS", "ALL");
                }
            } else {
                Console.setProperty("TRACE_THREADS", paramString);
            }
        }
        catch (Exception e) {
            caller.notifyObservers("ERROR: Unexpected Exception received setting TRACE_THREADS");
            caller.notifyObservers("expception text:" + e.getMessage());
        }
        String threadOptions = null;
        threadOptions = Console.getProperty("TRACE_THREADS");
        if (threadOptions != null) {
            caller.notifyObservers("\nThe trace formatter will be run with the following option:");
            caller.notifyObservers("\"-thread:" + threadOptions.toLowerCase() + "\"");
        }
    }

    private void cacheSummaryInfo() {
        PrintStream ps = null;
        if (snapTraceFileName != null) {
            if (snapTraceInfoFileName == null) {
                String[] summaryArgs = new String[]{snapTraceFileName, snapTraceFileName + ".tmp", "-summary"};
                try {
                    ps = new PrintStream(new FileOutputStream(snapTraceFileName + ".info"));
                }
                catch (IOException ioe) {
                    caller.notifyObservers("ERROR: Unexpected exception creating printStream.");
                }
                TraceFormat tf = new TraceFormat(ps, summaryArgs);
                ps.close();
                snapTraceInfoFileName = new String(snapTraceFileName + ".info");
            }
        } else {
            caller.notifyObservers("\nThe trace file must already exist before the TRACE CACHE command is run.\n(Use TRACE EXTRACT before running TRACE CACHE).");
        }
    }

    static {
        snapTraceInfoFileName = null;
        traceOutStart = 1;
        traceOutPage = 25;
    }
}

