/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.poa;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.poa.IdAssignmentPolicyImpl;
import com.ibm.rmi.poa.IdUniquenessPolicyImpl;
import com.ibm.rmi.poa.ImplicitActivationPolicyImpl;
import com.ibm.rmi.poa.LifespanPolicyImpl;
import com.ibm.rmi.poa.POAPolicyChecker;
import com.ibm.rmi.poa.RequestProcessingPolicyImpl;
import com.ibm.rmi.poa.ServantRetentionPolicyImpl;
import com.ibm.rmi.poa.ThreadPolicyImpl;
import java.util.HashMap;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public final class Policies {
    private final int thread;
    private final int lifespan;
    private final int idUniqueness;
    private final int idAssignment;
    private final int servantRetention;
    private final int requestProcessing;
    private final int implicitActivation;
    private final HashMap policies = new HashMap();

    Policies(Policy[] policyArray, ORB oRB) throws InvalidPolicy {
        if (policyArray != null) {
            this.addPolicies(policyArray, oRB);
            POAPolicyChecker.validate(policyArray);
        }
        this.addDefaultPolicies();
        Policy policy = this.getPolicy(16);
        this.thread = ((ThreadPolicy)policy).value().value();
        policy = this.getPolicy(17);
        this.lifespan = ((LifespanPolicy)policy).value().value();
        policy = this.getPolicy(18);
        this.idUniqueness = ((IdUniquenessPolicy)policy).value().value();
        policy = this.getPolicy(19);
        this.idAssignment = ((IdAssignmentPolicy)policy).value().value();
        policy = this.getPolicy(21);
        this.servantRetention = ((ServantRetentionPolicy)policy).value().value();
        policy = this.getPolicy(22);
        this.requestProcessing = ((RequestProcessingPolicy)policy).value().value();
        policy = this.getPolicy(20);
        this.implicitActivation = ((ImplicitActivationPolicy)policy).value().value();
    }

    private void addPolicies(Policy[] policyArray, ORB oRB) throws InvalidPolicy {
        for (short s = 0; s < policyArray.length; s = (short)((short)(s + 1))) {
            Policy policy = policyArray[s];
            if (policy == null) continue;
            Integer n = new Integer(policy.policy_type());
            if (this.policies.containsKey(n)) {
                throw new InvalidPolicy("Duplicate policy at index ", s);
            }
            if (oRB.get_policy_factory(policy.policy_type()) != null) {
                this.policies.put(n, policy.copy());
                continue;
            }
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "addPolicies:121", "Ignoring Policy - PolicyFactory for PolicyType does not exist in ORB: " + policy.policy_type(), (Object)policy);
        }
    }

    private void addDefaultPolicies() {
        LocalObject localObject;
        Integer n = new Integer(16);
        if (!this.policies.containsKey(n)) {
            localObject = new ThreadPolicyImpl(ThreadPolicyValue.ORB_CTRL_MODEL);
            this.policies.put(n, localObject);
        }
        if (!this.policies.containsKey(n = new Integer(17))) {
            localObject = new LifespanPolicyImpl(LifespanPolicyValue.TRANSIENT);
            this.policies.put(n, localObject);
        }
        if (!this.policies.containsKey(n = new Integer(18))) {
            localObject = new IdUniquenessPolicyImpl(IdUniquenessPolicyValue.UNIQUE_ID);
            this.policies.put(n, localObject);
        }
        if (!this.policies.containsKey(n = new Integer(19))) {
            localObject = new IdAssignmentPolicyImpl(IdAssignmentPolicyValue.SYSTEM_ID);
            this.policies.put(n, localObject);
        }
        if (!this.policies.containsKey(n = new Integer(21))) {
            localObject = new ServantRetentionPolicyImpl(ServantRetentionPolicyValue.RETAIN);
            this.policies.put(n, localObject);
        }
        if (!this.policies.containsKey(n = new Integer(22))) {
            localObject = new RequestProcessingPolicyImpl(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY);
            this.policies.put(n, localObject);
        }
        if (!this.policies.containsKey(n = new Integer(20))) {
            localObject = new ImplicitActivationPolicyImpl(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION);
            this.policies.put(n, localObject);
        }
    }

    public Policy getPolicy(int n) {
        Integer n2 = new Integer(n);
        return (Policy)this.policies.get(n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Policies[");
        for (Policy policy : this.policies.values()) {
            stringBuffer.append(policy.toString());
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final boolean isOrbControlledThreads() {
        return this.thread == 0;
    }

    public final boolean isSingleThreaded() {
        return this.thread == 1;
    }

    public final boolean isTransient() {
        return this.lifespan == 0;
    }

    public final boolean isPersistent() {
        return this.lifespan == 1;
    }

    public final boolean isUniqueIds() {
        return this.idUniqueness == 0;
    }

    public final boolean isMultipleIds() {
        return this.idUniqueness == 1;
    }

    public final boolean isUserAssignedIds() {
        return this.idAssignment == 0;
    }

    public final boolean isSystemAssignedIds() {
        return this.idAssignment == 1;
    }

    public final boolean retainServants() {
        return this.servantRetention == 0;
    }

    public final boolean useActiveMapOnly() {
        return this.requestProcessing == 0;
    }

    public final boolean useDefaultServant() {
        return this.requestProcessing == 1;
    }

    public final boolean useServantManager() {
        return this.requestProcessing == 2;
    }

    public final boolean isImplicitlyActivated() {
        return this.implicitActivation == 0;
    }
}

