/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.InitialNamingClient;
import com.ibm.rmi.corba.ORB;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextHelper;

public class InitialReferenceClient
extends InitialNamingClient {
    private String defaultInitRef = null;
    private Hashtable initRefs = new Hashtable();
    private Hashtable localRefs = new Hashtable();
    private static final String initRefParm = "-ORBInitRef";
    private static final String defaultInitRefParm = "-ORBDefaultInitRef";
    private static final String initRefProperty = "com.ibm.CORBA.ORBInitRef.";
    private static final String defaultInitRefProperty = "com.ibm.CORBA.ORBDefaultInitRef";
    private String[] reservedNames = new String[]{"InterfaceRepository", "SecurityCurrent", "TransactionCurrent", "ORBPolicyManager", "PolicyCurrent", "ComponentHomeFinder", "TypeCodeFactory", "PSS"};

    InitialReferenceClient(ORB oRB) {
        super(oRB);
    }

    String[] list_initial_services() {
        HashSet hashSet;
        block3: {
            hashSet = new HashSet(this.initRefs.keySet());
            hashSet.addAll(this.localRefs.keySet());
            if (this.orb.isSINOClient()) {
                try {
                    hashSet.addAll(Arrays.asList(super.list_initial_services()));
                }
                catch (Exception exception) {
                    if (!ORBRas.isTrcLogging) break block3;
                    ORBRas.orbTrcLogger.trace(4112L, this, "list_initial_services:106", exception.toString());
                }
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    protected Object resolve_initial_references(String string) throws InvalidName {
        RuntimeException runtimeException = null;
        Object object = (Object)this.localRefs.get(string);
        if (object != null) {
            return object;
        }
        ObjectURL objectURL = (ObjectURL)this.initRefs.get(string);
        if (objectURL != null) {
            try {
                if (objectURL.isRir() && objectURL.getKeyString().equals(string)) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, this, "resolve_initial_references:152", "rir object " + string + " points to itself : throwing BAD_PARAM");
                    }
                    throw new BAD_PARAM("rir object " + string + " points to itself", 1330446346, CompletionStatus.COMPLETED_NO);
                }
                return this.orb.objectURLToObject(objectURL);
            }
            catch (RuntimeException runtimeException2) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "resolve_initial_references:167", runtimeException2.toString());
                }
                runtimeException = runtimeException2;
            }
        }
        if (this.defaultInitRef == null) {
            this.defaultInitRef = "corbaloc::" + this.orb.getORBInitialHost() + ":" + this.orb.getORBInitialPort();
        }
        try {
            return this.orb.string_to_object(this.defaultInitRef + '/' + string);
        }
        catch (RuntimeException runtimeException3) {
            block18: {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "resolve_initial_references:186", runtimeException3.toString());
                }
                if (runtimeException == null) {
                    runtimeException = runtimeException3;
                }
                if (this.orb.isSINOClient()) {
                    try {
                        return super.resolve_initial_references(string);
                    }
                    catch (RuntimeException runtimeException4) {
                        if (ORBRas.isTrcLogging) {
                            ORBRas.orbTrcLogger.trace(4112L, this, "resolve_initial_references:205", runtimeException4.toString());
                        }
                    }
                    catch (InvalidName invalidName) {
                        if (!ORBRas.isTrcLogging) break block18;
                        ORBRas.orbTrcLogger.trace(4112L, this, "resolve_initial_references:212", invalidName.toString());
                    }
                }
            }
            if (runtimeException == null) {
                throw new InvalidName(string);
            }
            InvalidName invalidName = new InvalidName(string + ":" + runtimeException.toString());
            invalidName.initCause((Throwable)runtimeException);
            throw invalidName;
        }
    }

    void setDefaultRefs(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n + 1 < stringArray.length) {
            boolean bl;
            boolean bl2 = initRefParm.equalsIgnoreCase(stringArray[n]);
            boolean bl3 = bl = bl2 ? false : defaultInitRefParm.equalsIgnoreCase(stringArray[n]);
            if (bl2 | bl) {
                String string = stringArray[n + 1].trim();
                if (string == null || string.length() == 0 || string.toUpperCase().startsWith("-ORB")) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, this, "setDefaultRefs:269", "ignoring bad parameter " + stringArray[n] + " " + stringArray[n + 1]);
                    }
                } else if (bl2) {
                    int n2 = string.indexOf(61);
                    if (n2 == -1 || n2 == 0 || n2 + 1 == string.length()) {
                        throw new BAD_PARAM(stringArray[n] + " " + string + " should be <ObjectID>=<ObjectURL>", 1229124131, CompletionStatus.COMPLETED_NO);
                    }
                    String string2 = string.substring(0, n2).trim();
                    String string3 = string.substring(n2 + 1).trim();
                    this.createInitRef(string2, string3, true);
                } else if (bl) {
                    this.setDefaultInitRef(string, true);
                }
            }
            ++n;
        }
    }

    void setDefaultRefsFromProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        String string = properties.getProperty(defaultInitRefProperty);
        if (string != null) {
            this.setDefaultInitRef(string, false);
        }
        Enumeration<java.lang.Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(initRefProperty) == -1) continue;
                String string3 = string2.substring(string2.indexOf(initRefProperty) + initRefProperty.length());
                String string4 = properties.getProperty(string2);
                this.createInitRef(string3, string4, false);
            }
            catch (ClassCastException classCastException) {
                if (!ORBRas.isTrcLogging) continue;
                ORBRas.orbTrcLogger.trace(8208L, this, "setDefaultRefsFromProperties:337", classCastException.toString());
            }
        }
    }

    private void setDefaultInitRef(String string, boolean bl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "setDefaultInitRef:355", (java.lang.Object)((bl ? "-ORBDefaultInitRef " : "com.ibm.CORBA.ORBDefaultInitRef=") + string));
        }
        if (string.indexOf(47) != -1) {
            throw new BAD_PARAM((bl ? "-ORBDefaultInitRef " : "com.ibm.CORBA.ORBDefaultInitRef=") + string + ": should not contain a /", 1229124133, CompletionStatus.COMPLETED_NO);
        }
        if (this.defaultInitRef != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "setDefaultInitRef:375", (java.lang.Object)("ignoring value " + string + " : already set to " + this.defaultInitRef));
            }
            return;
        }
        if (!string.toLowerCase().startsWith("corbaloc:") && !string.toLowerCase().startsWith("corbaname:")) {
            throw new BAD_PARAM((bl ? "-ORBDefaultInitRef " : "com.ibm.CORBA.ORBDefaultInitRef=") + string + "is invalid: must be " + "corbaloc:" + " or " + "corbaname:", 1229124134, CompletionStatus.COMPLETED_NO);
        }
        ORB.createObjectURL(string.trim());
        this.defaultInitRef = string;
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "setDefaultInitRef:402", (java.lang.Object)("defaultInitRef set to " + string));
        }
    }

    private void createInitRef(String string, String string2, boolean bl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "createInitRef:414", (java.lang.Object)((bl ? "-ORBInitRef " : "com.ibm.CORBA.ORBInitRef..") + string + "=" + string2));
        }
        if (this.initRefs.containsKey(string)) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.exit(4100L, this, "createInitRef:425", (java.lang.Object)("ignoring value " + string2 + ": initial value for " + string + " already set"));
            }
            return;
        }
        ObjectURL objectURL = ORB.createObjectURL(string2);
        if (objectURL == null) {
            throw new BAD_PARAM((bl ? "-ORBInitRef " : "com.ibm.CORBA.ORBInitRef..") + string + "=" + string2 + ": is invalid", 1229124132, CompletionStatus.COMPLETED_NO);
        }
        this.initRefs.put(new String(string), objectURL);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "createInitRef:445", (java.lang.Object)(string + "=" + objectURL + " :initial reference set"));
        }
    }

    private boolean isReservedName(String string) {
        for (int i = 0; i < this.reservedNames.length; ++i) {
            if (!string.equals(this.reservedNames[i])) continue;
            return true;
        }
        return false;
    }

    void register_initial_reference(String string, Object object) throws InvalidName {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, (java.lang.Object)this, "register_initial_reference:491", (java.lang.Object)string);
        }
        if (string == null || string.equals("")) {
            throw new InvalidName("Invalid initial reference id");
        }
        if (this.isReservedName(string) || this.localRefs.get(string) != null) {
            throw new InvalidName(string + ":initial reference id already registered");
        }
        if (ObjectKey.isMBI(string)) {
            throw new InvalidName(string + ":reference ids starting xMBI are reserved for IBM internal usage");
        }
        if (object == null) {
            throw new BAD_PARAM("null obj encountered registering initial reference", 1330446363, CompletionStatus.COMPLETED_NO);
        }
        if (string.equals("NameService") && !object._is_a(NamingContextHelper.id())) {
            throw new BAD_PARAM("The object " + object.getClass() + " is not an org.omg.CosNaming.NamingContext", 1229124143, CompletionStatus.COMPLETED_NO);
        }
        this.localRefs.put(string, object);
        if (!(object instanceof LocalObject)) {
            this.orb.publishINSService(string, object);
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "register_initial_reference:525");
        }
    }
}

