/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.nio;

import com.ibm.CORBA.ras.Trc;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.nio.ByteOrder;

public final class ByteBufferUtils {
    private static final String CLASS = ByteBufferUtils.class.getName();
    private static WsByteBufferPoolManager bBPoolManager = WsByteBufferPoolManagerImpl.getRef();
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static WsByteBuffer fastWrap(byte[] byArray, int n, int n2, boolean bl) {
        WsByteBuffer wsByteBuffer = bl ? bBPoolManager.allocateDirect(n2) : bBPoolManager.allocate(n2);
        wsByteBuffer.put(byArray, n, n2);
        wsByteBuffer.position(0);
        Trc.info("WsByteBuffer created: msgBytes[].length=", Trc.str(byArray.length), ", start=", Trc.str(n), ", length=", Trc.str(n2), ", Result: ", wsByteBuffer, CLASS, "fastWrap:68");
        return wsByteBuffer;
    }

    public static WsByteBuffer[] clone(WsByteBuffer[] wsByteBufferArray, boolean bl) {
        Trc.begin2(Trc.array(wsByteBufferArray), Trc.str(bl), CLASS, "clone:80");
        int n = WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        WsByteBuffer wsByteBuffer = bl ? bBPoolManager.allocateDirect(n) : bBPoolManager.allocate(n);
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBuffer.put(wsByteBufferArray[i]);
        }
        WsByteBufferUtils.flip((WsByteBuffer[])wsByteBufferArray);
        wsByteBuffer.flip();
        WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[]{wsByteBuffer};
        Trc.complete(Trc.array(wsByteBufferArray2), Trc.str(bl), CLASS, "clone:91");
        return wsByteBufferArray2;
    }

    public static String bytesToHexString(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray == null) {
            return null;
        }
        if (wsByteBufferArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(wsByteBufferArray.length * 2);
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            stringBuffer.append(hexChars[wsByteBufferArray[i].get() >> 4 & 0xF]);
            stringBuffer.append(hexChars[wsByteBufferArray[i].get() & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static byte get(WsByteBuffer[] wsByteBufferArray, int n) {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < wsByteBufferArray.length && (n2 = n4 + wsByteBufferArray[n3].remaining()) <= n; ++n3) {
            n4 = n2;
        }
        return wsByteBufferArray[n3].get(wsByteBufferArray[n3].position() + n - n4);
    }

    public static int remaining(WsByteBuffer[] wsByteBufferArray) {
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            n += wsByteBufferArray[i].remaining();
        }
        return n;
    }

    public static void setByteOrder(WsByteBuffer[] wsByteBufferArray, ByteOrder byteOrder) {
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i].order(byteOrder);
        }
    }
}

