/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.map;

import com.ibm.jtc.orb.map.Cache;
import com.ibm.jtc.orb.map.CacheFactory;
import com.ibm.jtc.orb.map.MapFactory;
import com.ibm.jtc.orb.map.ObjectFactory;
import com.ibm.jtc.orb.map.ObjectWrapper;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;

public class CacheFactories {
    public static final CacheFactory PLAIN = Plain.INSTANCE;
    public static final CacheFactory SOFT = Soft.INSTANCE;

    private CacheFactories() {
    }

    private static final class Soft
    implements CacheFactory {
        public static final Soft INSTANCE = new Soft();

        private Soft() {
        }

        public final Cache create(MapFactory mapFactory) {
            return new FutureCacheImpl(mapFactory);
        }

        public final Cache create(MapFactory mapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(mapFactory, objectFactory);
        }

        private static final class FutureCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            FutureCacheImpl(MapFactory mapFactory) {
                this.map = mapFactory.create();
                this.keyWrapper = mapFactory.getKeyWrapper();
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Reference reference = (Reference)this.map.get(object);
                    Object object2 = null == reference ? null : reference.get();
                    this.clearQueue();
                    if (null == object2) {
                        if (null != reference) {
                            this.map.remove(object);
                        }
                        Object object3 = this.keyWrapper.wrap(object);
                        object2 = new FutureImpl(object, object3, this.map, this.queue);
                        reference = new SimpleReference(object2);
                        this.map.put(object, reference);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    Iterator iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() instanceof FutureImpl) continue;
                        iterator.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class Value
            extends SoftReference
            implements Reference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Object keyRef;
                private final Map map;
                private final ReferenceQueue queue;
                private Object canonicalValue = null;

                FutureImpl(Object object, Object object2, Map map, ReferenceQueue referenceQueue) {
                    this.key = object;
                    this.keyRef = object2;
                    this.map = map;
                    this.queue = referenceQueue;
                }

                public synchronized Object get() {
                    return this.canonicalValue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object get(Object object) {
                    Object object2 = this;
                    synchronized (object2) {
                        if (null != this.canonicalValue) {
                            return this.canonicalValue;
                        }
                        this.canonicalValue = object;
                    }
                    object2 = new Value(object, this.keyRef, this.queue);
                    Map map = this.map;
                    synchronized (map) {
                        this.map.put(this.key, object2);
                    }
                    return object;
                }
            }

            private static final class SimpleReference
            implements Reference {
                private final Object object;

                SimpleReference(Object object) {
                    this.object = object;
                }

                public Object get() {
                    return this.object;
                }
            }

            private static interface Reference {
                public Object get();
            }
        }

        private static final class ObjectCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectFactory valueFactory;
            private final ObjectWrapper keyWrapper;
            private final ReferenceQueue queue;

            ObjectCacheImpl(MapFactory mapFactory, ObjectFactory objectFactory) {
                this.map = mapFactory.create();
                this.keyWrapper = mapFactory.getKeyWrapper();
                this.valueFactory = objectFactory;
                this.queue = new ReferenceQueue();
            }

            private void clearQueue() {
                Object object = null;
                Value value = (Value)this.queue.poll();
                while (null != value) {
                    object = this.keyWrapper.unwrap(value.keyRef);
                    if (null != object) {
                        this.map.remove(object);
                    }
                    value = (Value)this.queue.poll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Value value = (Value)this.map.get(object);
                    Object object2 = null == value ? null : (Object)value.get();
                    this.clearQueue();
                    if (null == object2) {
                        if (null != value) {
                            this.map.remove(object);
                        }
                        Object object3 = this.keyWrapper.wrap(object);
                        object2 = this.valueFactory.create();
                        value = new Value(object2, object3, this.queue);
                        this.map.put(object, value);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    this.map.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class Value
            extends SoftReference {
                final Object keyRef;

                Value(Object object, Object object2, ReferenceQueue referenceQueue) {
                    super(object, referenceQueue);
                    this.keyRef = object2;
                }
            }
        }
    }

    private static final class Plain
    implements CacheFactory {
        public static final Plain INSTANCE = new Plain();

        private Plain() {
        }

        public final Cache create(MapFactory mapFactory) {
            return new FutureCacheImpl(mapFactory);
        }

        public final Cache create(MapFactory mapFactory, ObjectFactory objectFactory) {
            return new ObjectCacheImpl(mapFactory, objectFactory);
        }

        private static final class FutureCacheImpl
        implements Cache {
            private final Map map;

            FutureCacheImpl(MapFactory mapFactory) {
                this.map = mapFactory.create();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Object object2 = this.map.get(object);
                    if (null == object2) {
                        object2 = new FutureImpl(object, this.map);
                        this.map.put(object, object2);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    Iterator iterator = this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (entry.getValue() instanceof FutureImpl) continue;
                        iterator.remove();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }

            private static final class FutureImpl
            implements Cache.FutureEntry {
                private final Object key;
                private final Map map;
                private Object canonicalValue = null;

                FutureImpl(Object object, Map map) {
                    this.key = object;
                    this.map = map;
                }

                public synchronized Object get() {
                    return this.canonicalValue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object get(Object object) {
                    Object object2 = this;
                    synchronized (object2) {
                        if (null != this.canonicalValue) {
                            return this.canonicalValue;
                        }
                        this.canonicalValue = object;
                    }
                    object2 = this.map;
                    synchronized (object2) {
                        this.map.put(this.key, object);
                    }
                    return object;
                }
            }
        }

        private static final class ObjectCacheImpl
        implements Cache {
            private final Map map;
            private final ObjectFactory valueFactory;

            ObjectCacheImpl(MapFactory mapFactory, ObjectFactory objectFactory) {
                this.map = mapFactory.create();
                this.valueFactory = objectFactory;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object get(Object object) {
                Map map = this.map;
                synchronized (map) {
                    Object object2 = this.map.get(object);
                    if (null == object2) {
                        object2 = this.valueFactory.create();
                        this.map.put(object, object2);
                    }
                    return object2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clear() {
                Map map = this.map;
                synchronized (map) {
                    this.map.clear();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean isEmpty() {
                Map map = this.map;
                synchronized (map) {
                    return this.map.isEmpty();
                }
            }
        }
    }
}

