/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.iiop;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.iiop.IIOPInputStream;
import com.ibm.CORBA.iiop.Message;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.iiop.MessageHandler;
import com.ibm.jtc.orb.nio.BufferHandlerHelper;
import com.ibm.jtc.orb.nio.CDRInputHandler;
import com.ibm.rmi.iiop.IIOPReader;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TIMEOUT;

public class IIOPInputHandler
extends CDRInputHandler
implements IIOPInputStream,
IIOPReader {
    private static final String CLASS = IIOPInputStream.class.getName();
    private Message msg;
    private boolean firstFragment = true;
    private final GIOPConnectionContext connCtx;

    public IIOPInputHandler(MessageHandler messageHandler) {
        super(messageHandler);
        this.msg = messageHandler.getMessage();
        this.connCtx = messageHandler.getConnection().getGiopConnCtx();
        this.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), true);
        this.setConnection(messageHandler.getConnection());
    }

    public Message getMessage() {
        return this.msg;
    }

    public boolean isFirstFragment() {
        return this.firstFragment;
    }

    public void logCommTrace() {
    }

    public void getNextBuffer() {
        if (this.getData() == null) {
            try {
                int n = this.msg.getRequestId();
                WsByteBuffer[] wsByteBufferArray = this.connCtx.getNextFragment(n);
                BufferHandlerHelper.slice(wsByteBufferArray);
                this.addNextBuffer(wsByteBufferArray);
                this.firstFragment = false;
            }
            catch (TIMEOUT tIMEOUT) {
                Trc.warn("Timed out waiting for next fragment", CLASS, "getNextBuffer:118");
                throw tIMEOUT;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "getNextBuffer:121");
                throw new MARSHAL(exception.toString(), 1229125060, CompletionStatus.COMPLETED_NO);
            }
        }
    }
}

