/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.BorderUIResource;
import sun.net.util.IPAddressUtil;
import sun.tools.jconsole.AboutDialog;
import sun.tools.jconsole.ConnectDialog;
import sun.tools.jconsole.CreateMBeanDialog;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.OutputViewer;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMInternalFrame;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JConsole
extends JFrame
implements ActionListener,
InternalFrameListener {
    static boolean IS_GTK;
    static boolean IS_WIN;
    private static final String title;
    public static final String ROOT_URL = "service:jmx:";
    private static int updateInterval;
    private static String pluginPath;
    private JMenuBar menuBar;
    private JMenuItem hotspotMI;
    private JMenuItem connectMI;
    private JMenuItem exitMI;
    private WindowMenu windowMenu;
    private JMenuItem tileMI;
    private JMenuItem cascadeMI;
    private JMenuItem minimizeAllMI;
    private JMenuItem restoreAllMI;
    private JMenuItem userGuideMI;
    private JMenuItem aboutMI;
    private JButton connectButton;
    private JDesktopPane desktop;
    private ConnectDialog connectDialog;
    private CreateMBeanDialog createDialog;
    private ArrayList<VMInternalFrame> windows = new ArrayList();
    private int frameLoc = 5;
    static boolean debug;
    private static final boolean localAttachmentSupported;
    private static ServiceLoader<JConsolePlugin> pluginService;

    static void updateLafValues() {
        String string = UIManager.getLookAndFeel().getClass().getName();
        IS_GTK = string.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        IS_WIN = string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    }

    public JConsole(boolean bl) {
        super(title);
        this.setRootPane(new FixedJRootPane());
        Utilities.setAccessibleDescription(this, Resources.getText("JConsole.accessibleDescription", new Object[0]));
        this.setDefaultCloseOperation(3);
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        Utilities.setAccessibleDescription(this.menuBar, Resources.getText("Menubar.accessibleDescription", new Object[0]));
        Utilities.setAccessibleName(this.menuBar, Resources.getText("Menubar", new Object[0]));
        JMenu jMenu = new JMenu(Resources.getText("Connection", new Object[0]));
        Utilities.setAccessibleDescription(jMenu, Resources.getText("Connection.description", new Object[0]));
        jMenu.setMnemonic(Resources.getMnemonicInt("Connection"));
        this.menuBar.add(jMenu);
        if (bl) {
            this.hotspotMI = new JMenuItem(Resources.getText("Hotspot MBeans...", new Object[0]));
            this.hotspotMI.setMnemonic(Resources.getMnemonicInt("Hotspot MBeans..."));
            this.hotspotMI.setAccelerator(KeyStroke.getKeyStroke(72, 2));
            this.hotspotMI.addActionListener(this);
            jMenu.add(this.hotspotMI);
            jMenu.addSeparator();
        }
        this.connectMI = new JMenuItem(Resources.getText("New Connection", new Object[0]), Resources.getMnemonicInt("New Connection..."));
        Utilities.setAccessibleDescription(this.connectMI, Resources.getText("New Connection.description", new Object[0]));
        this.connectMI.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.connectMI.addActionListener(this);
        jMenu.add(this.connectMI);
        jMenu.addSeparator();
        this.exitMI = new JMenuItem(Resources.getText("Exit", new Object[0]), Resources.getMnemonicInt("Exit"));
        Utilities.setAccessibleDescription(this.exitMI, Resources.getText("Exit.description", new Object[0]));
        this.exitMI.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.exitMI.addActionListener(this);
        jMenu.add(this.exitMI);
        JMenu jMenu2 = new JMenu(Resources.getText("HelpMenu.title", new Object[0]));
        jMenu2.setMnemonic(Resources.getMnemonicInt("HelpMenu.title"));
        Utilities.setAccessibleDescription(jMenu2, Resources.getText("HelpMenu.description", new Object[0]));
        this.menuBar.add(jMenu2);
        if (AboutDialog.isBrowseSupported()) {
            this.userGuideMI = new JMenuItem(Resources.getText("HelpMenu.UserGuide.title", new Object[0]), Resources.getMnemonicInt("HelpMenu.UserGuide.title"));
            this.userGuideMI.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            Utilities.setAccessibleDescription(this.userGuideMI, Resources.getText("HelpMenu.UserGuide.description", new Object[0]));
            this.userGuideMI.addActionListener(this);
            jMenu2.add(this.userGuideMI);
            jMenu2.addSeparator();
        }
        this.aboutMI = new JMenuItem(Resources.getText("HelpMenu.About.title", new Object[0]), Resources.getMnemonicInt("HelpMenu.About.title"));
        Utilities.setAccessibleDescription(this.aboutMI, Resources.getText("HelpMenu.About.description", new Object[0]));
        this.aboutMI.addActionListener(this);
        jMenu2.add(this.aboutMI);
    }

    public JDesktopPane getDesktopPane() {
        return this.desktop;
    }

    public List<VMInternalFrame> getInternalFrames() {
        return this.windows;
    }

    private void createMDI() {
        this.setTitle(title);
        Container container = this.getContentPane();
        Component component = ((BorderLayout)container.getLayout()).getLayoutComponent("Center");
        this.windowMenu = new WindowMenu(Resources.getText("Window", new Object[0]));
        this.windowMenu.setMnemonic(Resources.getMnemonicInt("Window"));
        this.menuBar.add((Component)this.windowMenu, this.menuBar.getComponentCount() - 1);
        this.desktop = new JDesktopPane();
        this.desktop.setBackground(new Color(235, 245, 255));
        container.add((Component)this.desktop, "Center");
        if (component instanceof VMPanel) {
            this.addFrame((VMPanel)component);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem;
        VMInternalFrame vMInternalFrame;
        Object object = actionEvent.getSource();
        if (object == this.hotspotMI) {
            this.showCreateMBeanDialog();
        }
        if (object == this.connectButton || object == this.connectMI) {
            VMPanel vMPanel = null;
            JInternalFrame jInternalFrame = this.desktop.getSelectedFrame();
            if (jInternalFrame instanceof VMInternalFrame) {
                vMPanel = ((VMInternalFrame)jInternalFrame).getVMPanel();
            }
            String string = "";
            String string2 = "";
            if (vMPanel != null) {
                string = vMPanel.getHostName();
                if (vMPanel.getUrl() != null) {
                    string2 = vMPanel.getUrl();
                }
            }
            this.showConnectDialog(string2, string, 0, null, null, null);
        } else if (object == this.tileMI) {
            this.tileWindows();
        } else if (object == this.cascadeMI) {
            this.cascadeWindows();
        } else if (object == this.minimizeAllMI) {
            for (VMInternalFrame vMInternalFrame2 : this.windows) {
                try {
                    vMInternalFrame2.setIcon(true);
                    this.desktop.requestFocus();
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else if (object == this.restoreAllMI) {
            for (VMInternalFrame vMInternalFrame3 : this.windows) {
                try {
                    vMInternalFrame3.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        } else if (object == this.exitMI) {
            System.exit(0);
        } else if (object == this.userGuideMI) {
            AboutDialog.browseUserGuide(this);
        } else if (object == this.aboutMI) {
            AboutDialog.showAboutDialog(this);
        } else if (object instanceof JMenuItem && (vMInternalFrame = (VMInternalFrame)(jMenuItem = (JMenuItem)object).getClientProperty("JConsole.vmIF")) != null) {
            try {
                vMInternalFrame.setIcon(false);
                vMInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            vMInternalFrame.moveToFront();
        }
    }

    public void tileWindows() {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        for (VMInternalFrame vMInternalFrame : this.windows) {
            if (vMInternalFrame.isIcon()) continue;
            ++n3;
            if (n != -1) continue;
            try {
                vMInternalFrame.setMaximum(true);
                n = vMInternalFrame.getWidth();
                n2 = vMInternalFrame.getHeight();
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if (n3 > 0 && n > 0 && n2 > 0) {
            int n4;
            int n5 = (int)Math.ceil(Math.sqrt(n3));
            if (n5 * (n4 = n3 / n5) < n3) {
                ++n4;
            }
            int n6 = 0;
            int n7 = 0;
            n /= n4;
            n2 /= n5;
            int n8 = 0;
            for (VMInternalFrame vMInternalFrame : this.windows) {
                if (vMInternalFrame.isIcon()) continue;
                try {
                    vMInternalFrame.setMaximum(n3 == 1);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                if (n3 > 1) {
                    vMInternalFrame.setBounds(n6, n7, n, n2);
                }
                if (n8 < n4 - 1) {
                    ++n8;
                    n6 += n;
                    continue;
                }
                n8 = 0;
                n6 = 0;
                n7 += n2;
            }
        }
    }

    public void cascadeWindows() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (VMInternalFrame vMInternalFrame : this.windows) {
            if (vMInternalFrame.isIcon()) continue;
            try {
                vMInternalFrame.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++n;
            vMInternalFrame.pack();
            if (n2 != -1) continue;
            try {
                n2 = vMInternalFrame.getWidth();
                n3 = vMInternalFrame.getHeight();
                vMInternalFrame.setMaximum(true);
                n2 = vMInternalFrame.getWidth() - n2;
                n3 = vMInternalFrame.getHeight() - n3;
                vMInternalFrame.pack();
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = n > 1 ? n2 / (n - 1) : 0;
        int n7 = n > 1 ? n3 / (n - 1) : 0;
        for (VMInternalFrame vMInternalFrame : this.windows) {
            if (vMInternalFrame.isIcon()) continue;
            vMInternalFrame.setLocation(n4, n5);
            vMInternalFrame.moveToFront();
            n4 += n6;
            n5 += n7;
        }
    }

    void addHost(String string, int n, String string2, String string3) {
        this.addHost(string, n, string2, string3, false);
    }

    void addVmid(LocalVirtualMachine localVirtualMachine) {
        this.addVmid(localVirtualMachine, false);
    }

    void addVmid(final LocalVirtualMachine localVirtualMachine, final boolean bl) {
        new Thread("JConsole.addVmid"){

            public void run() {
                try {
                    JConsole.this.addProxyClient(ProxyClient.getProxyClient(localVirtualMachine), bl);
                }
                catch (SecurityException securityException) {
                    JConsole.this.failed(securityException, null, null, null);
                }
                catch (IOException iOException) {
                    JConsole.this.failed(iOException, null, null, null);
                }
            }
        }.start();
    }

    void addUrl(final String string, final String string2, final String string3, final boolean bl) {
        new Thread("JConsole.addUrl"){

            public void run() {
                try {
                    JConsole.this.addProxyClient(ProxyClient.getProxyClient(string, string2, string3), bl);
                }
                catch (MalformedURLException malformedURLException) {
                    JConsole.this.failed(malformedURLException, string, string2, string3);
                }
                catch (SecurityException securityException) {
                    JConsole.this.failed(securityException, string, string2, string3);
                }
                catch (IOException iOException) {
                    JConsole.this.failed(iOException, string, string2, string3);
                }
            }
        }.start();
    }

    void addHost(final String string, final int n, final String string2, final String string3, final boolean bl) {
        new Thread("JConsole.addHost"){

            public void run() {
                try {
                    JConsole.this.addProxyClient(ProxyClient.getProxyClient(string, n, string2, string3), bl);
                }
                catch (IOException iOException) {
                    JConsole.dbgStackTrace(iOException);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JConsole.this.showConnectDialog(null, string, n, string2, string3, JConsole.this.errorMessage(iOException));
                        }
                    });
                }
            }
        }.start();
    }

    void addProxyClient(final ProxyClient proxyClient, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VMPanel vMPanel = new VMPanel(proxyClient, updateInterval);
                JConsole.this.addFrame(vMPanel);
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JConsole.this.tileWindows();
                        }
                    });
                }
                vMPanel.connect();
            }
        });
    }

    private void failed(final Exception exception, final String string, final String string2, final String string3) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JConsole.dbgStackTrace(exception);
                JConsole.this.showConnectDialog(string, null, -1, string2, string3, JConsole.this.errorMessage(exception));
            }
        });
    }

    private VMInternalFrame addFrame(VMPanel vMPanel) {
        VMInternalFrame vMInternalFrame = new VMInternalFrame(vMPanel);
        for (VMInternalFrame vMInternalFrame2 : this.windows) {
            try {
                vMInternalFrame2.setMaximum(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        this.desktop.add(vMInternalFrame);
        vMInternalFrame.setLocation(this.frameLoc, this.frameLoc);
        this.frameLoc += 30;
        vMInternalFrame.setVisible(true);
        this.windows.add(vMInternalFrame);
        if (this.windows.size() == 1) {
            try {
                vMInternalFrame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        vMInternalFrame.addInternalFrameListener(this);
        this.windowMenu.add(vMInternalFrame);
        return vMInternalFrame;
    }

    private void showConnectDialog(String string, String string2, int n, String string3, String string4, String string5) {
        if (this.connectDialog == null) {
            this.connectDialog = new ConnectDialog(this);
        }
        this.connectDialog.setConnectionParameters(string, string2, n, string3, string4, string5);
        this.connectDialog.refresh();
        this.connectDialog.setVisible(true);
        try {
            this.connectDialog.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void showCreateMBeanDialog() {
        if (this.createDialog == null) {
            this.createDialog = new CreateMBeanDialog(this);
        }
        this.createDialog.setVisible(true);
        try {
            this.createDialog.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void removeVMInternalFrame(VMInternalFrame vMInternalFrame) {
        this.windowMenu.remove(vMInternalFrame);
        this.desktop.remove(vMInternalFrame);
        this.desktop.repaint();
        vMInternalFrame.getVMPanel().cleanUp();
        vMInternalFrame.dispose();
    }

    private boolean isProxyClientUsed(ProxyClient proxyClient) {
        for (VMInternalFrame vMInternalFrame : this.windows) {
            ProxyClient proxyClient2 = vMInternalFrame.getVMPanel().getProxyClient(false);
            if (proxyClient != proxyClient2) continue;
            return true;
        }
        return false;
    }

    static boolean isValidRemoteString(String string) {
        boolean bl = false;
        if (string != null) {
            if ((string = string.trim()).startsWith(ROOT_URL)) {
                if (string.length() > ROOT_URL.length()) {
                    bl = true;
                }
            } else if (string.startsWith("[")) {
                String string2;
                int n = string.indexOf("]:");
                if (n != -1 && IPAddressUtil.isIPv6LiteralAddress(string2 = string.substring(1, n))) {
                    try {
                        String string3 = string.substring(n + 2);
                        int n2 = Integer.parseInt(string3);
                        if (n2 >= 0 && n2 <= 65535) {
                            bl = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
            } else {
                String[] stringArray = string.split(":");
                if (stringArray.length == 2) {
                    try {
                        int n = Integer.parseInt(stringArray[1]);
                        if (n >= 0 && n <= 65535) {
                            bl = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                }
            }
        }
        return bl;
    }

    private String errorMessage(Exception exception) {
        String string = Resources.getText("Connection failed", new Object[0]);
        if (exception instanceof IOException || exception instanceof SecurityException) {
            Throwable throwable = null;
            for (Throwable throwable2 = exception.getCause(); throwable2 != null; throwable2 = throwable2.getCause()) {
                throwable = throwable2;
            }
            if (throwable instanceof ConnectException) {
                return string + ": " + throwable.getMessage();
            }
            if (throwable instanceof UnknownHostException) {
                return Resources.getText("Unknown Host", throwable.getMessage());
            }
            if (throwable instanceof NoRouteToHostException) {
                return string + ": " + throwable.getMessage();
            }
            if (throwable instanceof FailedLoginException) {
                return string + ": " + throwable.getMessage();
            }
            if (throwable instanceof SSLHandshakeException) {
                return string + ": " + throwable.getMessage();
            }
        } else if (exception instanceof MalformedURLException) {
            return Resources.getText("Invalid URL", exception.getMessage());
        }
        return string + ": " + exception.getMessage();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        VMInternalFrame vMInternalFrame = (VMInternalFrame)internalFrameEvent.getInternalFrame();
        this.removeVMInternalFrame(vMInternalFrame);
        this.windows.remove(vMInternalFrame);
        ProxyClient proxyClient = vMInternalFrame.getVMPanel().getProxyClient(false);
        if (!this.isProxyClientUsed(proxyClient)) {
            proxyClient.markAsDead();
        }
        if (this.windows.size() == 0) {
            this.showConnectDialog("", "", 0, null, null, null);
        }
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }

    private static void usage() {
        System.err.println(Resources.getText("zz usage text", "jconsole"));
    }

    private static void mainInit(final List<String> list, final List<String> list2, final List<Integer> list3, final List<LocalVirtualMachine> list4, ProxyClient proxyClient, final boolean bl, final boolean bl2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n;
                JConsole jConsole = new JConsole(bl2);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                GraphicsConfiguration graphicsConfiguration = jConsole.getGraphicsConfiguration();
                Dimension dimension = toolkit.getScreenSize();
                Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
                Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
                int n2 = Math.min(900, rectangle.width);
                int n3 = Math.min(750, rectangle.height);
                jConsole.setBounds(rectangle.x + (rectangle.width - n2) / 2, rectangle.y + (rectangle.height - n3) / 2, n2, n3);
                jConsole.setVisible(true);
                jConsole.createMDI();
                for (n = 0; n < list2.size(); ++n) {
                    jConsole.addHost((String)list2.get(n), (Integer)list3.get(n), null, null, n == list2.size() - 1 ? !bl : false);
                }
                for (n = 0; n < list.size(); ++n) {
                    jConsole.addUrl((String)list.get(n), null, null, n == list.size() - 1 ? !bl : false);
                }
                for (n = 0; n < list4.size(); ++n) {
                    jConsole.addVmid((LocalVirtualMachine)list4.get(n), n == list4.size() - 1 ? !bl : false);
                }
                if (list4.size() == 0 && list2.size() == 0 && list.size() == 0) {
                    jConsole.showConnectDialog(null, null, 0, null, null, null);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        ProxyClient proxyClient = null;
        if (System.getProperty("jconsole.showOutputViewer") != null) {
            OutputViewer.init();
        }
        while (stringArray.length - n > 0 && stringArray[n].startsWith("-")) {
            if (((String)(object = stringArray[n++])).equals("-h") || ((String)object).equals("-help") || ((String)object).equals("-?")) {
                JConsole.usage();
                return;
            }
            if (((String)object).startsWith("-interval=")) {
                try {
                    updateInterval = Integer.parseInt(((String)object).substring(10)) * 1000;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JConsole.usage();
                    return;
                }
            }
            if (((String)object).equals("-pluginpath")) {
                if (n < stringArray.length && !stringArray[n].startsWith("-")) {
                    pluginPath = stringArray[n++];
                    continue;
                }
                JConsole.usage();
                return;
            }
            if (((String)object).equals("-notile")) {
                bl = true;
                continue;
            }
            if (((String)object).equals("-version")) {
                Version.print(System.err);
                return;
            }
            if (((String)object).equals("-debug")) {
                debug = true;
                continue;
            }
            if (((String)object).equals("-fullversion")) {
                Version.printFullVersion(System.err);
                return;
            }
            JConsole.usage();
            return;
        }
        if (System.getProperty("jconsole.showUnsupported") != null) {
            bl2 = true;
        }
        object = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<LocalVirtualMachine> arrayList3 = new ArrayList<LocalVirtualMachine>();
        for (int i = n; i < stringArray.length; ++i) {
            int n2;
            String string = stringArray[i];
            if (JConsole.isValidRemoteString(string)) {
                if (string.startsWith(ROOT_URL)) {
                    object.add(string);
                    continue;
                }
                if (!string.matches(".*:[0-9]*")) continue;
                n2 = string.lastIndexOf(58);
                arrayList.add(string.substring(0, n2));
                try {
                    arrayList2.add(Integer.parseInt(string.substring(n2 + 1)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    JConsole.usage();
                    return;
                }
            }
            if (!JConsole.isLocalAttachAvailable()) {
                System.err.println("Local process monitoring is not supported");
                return;
            }
            try {
                n2 = Integer.parseInt(string);
                LocalVirtualMachine localVirtualMachine = LocalVirtualMachine.getLocalVirtualMachine(n2);
                if (localVirtualMachine == null) {
                    System.err.println("Invalid process id:" + n2);
                    return;
                }
                arrayList3.add(localVirtualMachine);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                JConsole.usage();
                return;
            }
        }
        JConsole.mainInit((List<String>)object, arrayList, arrayList2, arrayList3, proxyClient, bl, bl2);
    }

    public static boolean isDebug() {
        return debug;
    }

    private static void dbgStackTrace(Exception exception) {
        if (debug) {
            exception.printStackTrace();
        }
    }

    public static boolean isLocalAttachAvailable() {
        return localAttachmentSupported;
    }

    static synchronized List<JConsolePlugin> getPlugins() {
        if (pluginService == null) {
            JConsole.initPluginService(pluginPath);
        } else {
            pluginService.reload();
        }
        ArrayList<JConsolePlugin> arrayList = new ArrayList<JConsolePlugin>();
        for (JConsolePlugin jConsolePlugin : pluginService) {
            arrayList.add(jConsolePlugin);
        }
        return arrayList;
    }

    private static void initPluginService(String string) {
        if (string.length() > 0) {
            try {
                URLClassLoader uRLClassLoader = new URLClassLoader(JConsole.pathToURLs(string));
                ServiceLoader<JConsolePlugin> serviceLoader = ServiceLoader.load(JConsolePlugin.class, uRLClassLoader);
                for (JConsolePlugin jConsolePlugin : serviceLoader) {
                    if (!JConsole.isDebug()) continue;
                    System.out.println("Plugin " + jConsolePlugin.getClass() + " loaded.");
                }
                pluginService = serviceLoader;
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                System.out.println(Resources.getText("Fail to load plugin", serviceConfigurationError.getMessage()));
            }
            catch (MalformedURLException malformedURLException) {
                if (JConsole.isDebug()) {
                    malformedURLException.printStackTrace();
                }
                System.out.println(Resources.getText("Invalid plugin path", malformedURLException.getMessage()));
            }
        }
        if (pluginService == null) {
            JConsole.initEmptyPlugin();
        }
    }

    private static void initEmptyPlugin() {
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[0]);
        pluginService = ServiceLoader.load(JConsolePlugin.class, uRLClassLoader);
    }

    private static URL[] pathToURLs(String string) throws MalformedURLException {
        String[] stringArray = string.split(File.pathSeparator);
        URL[] uRLArray = new URL[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            URL uRL = JConsole.fileToURL(new File(string2));
            uRLArray[n++] = uRL;
        }
        return uRLArray;
    }

    private static URL fileToURL(File file) throws MalformedURLException {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    static {
        boolean bl;
        String string;
        if (System.getProperty("swing.defaultlaf") == null && ((string = UIManager.getSystemLookAndFeelClassName()).equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") || string.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel"))) {
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {
                System.err.println(Resources.getText("JConsole: ", exception.getMessage()));
            }
        }
        JConsole.updateLafValues();
        title = Resources.getText("Java Monitoring & Management Console", new Object[0]);
        updateInterval = 4000;
        pluginPath = "";
        try {
            Class.forName("com.sun.tools.attach.VirtualMachine");
            Class.forName("sun.management.ConnectorAddressLink");
            bl = false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        localAttachmentSupported = bl;
        pluginService = null;
    }

    private static class FixedJRootPane
    extends JRootPane {
        private FixedJRootPane() {
        }

        public void updateUI() {
            JConsole.updateLafValues();
            super.updateUI();
        }

        public void revalidate() {
            UIManager.put("TitledBorder.border", null);
            Border border = UIManager.getBorder("TitledBorder.border");
            if (border instanceof BorderUIResource.EtchedBorderUIResource) {
                Color color = UIManager.getColor("ToolBar.highlight");
                Color color2 = UIManager.getColor("ToolBar.shadow");
                border = new BorderUIResource.EtchedBorderUIResource(color, color2);
                UIManager.put("TitledBorder.border", border);
            }
            if (IS_GTK) {
                UIManager.put("TitledBorder.titleColor", UIManager.getColor("Label.foreground"));
                UIManager.put("TitledBorder.font", UIManager.getFont("Label.font"));
            }
            super.revalidate();
        }
    }

    private class WindowMenu
    extends JMenu {
        VMInternalFrame[] windowMenuWindows;
        int separatorPosition;
        Rectangle viewR;
        Rectangle textR;
        Rectangle iconR;

        WindowMenu(String string) {
            super(string);
            this.windowMenuWindows = new VMInternalFrame[0];
            this.viewR = new Rectangle(0, 0, 400, 20);
            this.textR = new Rectangle(0, 0, 0, 0);
            this.iconR = new Rectangle(0, 0, 0, 0);
            Utilities.setAccessibleDescription(this, Resources.getText("Window.description", new Object[0]));
            JConsole.this.cascadeMI = new JMenuItem(Resources.getText("Cascade", new Object[0]), Resources.getMnemonicInt("Cascade"));
            Utilities.setAccessibleDescription(JConsole.this.cascadeMI, Resources.getText("Cascade.description", new Object[0]));
            JConsole.this.cascadeMI.addActionListener(JConsole.this);
            this.add(JConsole.this.cascadeMI);
            JConsole.this.tileMI = new JMenuItem(Resources.getText("Tile", new Object[0]), Resources.getMnemonicInt("Tile"));
            Utilities.setAccessibleDescription(JConsole.this.tileMI, Resources.getText("Tile.description", new Object[0]));
            JConsole.this.tileMI.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            JConsole.this.tileMI.addActionListener(JConsole.this);
            this.add(JConsole.this.tileMI);
            JConsole.this.minimizeAllMI = new JMenuItem(Resources.getText("Minimize All", new Object[0]), Resources.getMnemonicInt("Minimize All"));
            Utilities.setAccessibleDescription(JConsole.this.minimizeAllMI, Resources.getText("MinimizeAll.description", new Object[0]));
            JConsole.this.minimizeAllMI.addActionListener(JConsole.this);
            this.add(JConsole.this.minimizeAllMI);
            JConsole.this.restoreAllMI = new JMenuItem(Resources.getText("Restore All", new Object[0]), Resources.getMnemonicInt("Restore All"));
            Utilities.setAccessibleDescription(JConsole.this.restoreAllMI, Resources.getText("RestoreAll.description", new Object[0]));
            JConsole.this.restoreAllMI.addActionListener(JConsole.this);
            this.add(JConsole.this.restoreAllMI);
            this.separatorPosition = this.getMenuComponentCount();
        }

        private void add(VMInternalFrame vMInternalFrame) {
            if (this.separatorPosition == this.getMenuComponentCount()) {
                this.addSeparator();
            }
            int n = -1;
            int n2 = this.separatorPosition + 1;
            int n3 = this.windowMenuWindows.length;
            for (int i = 0; i < n3; ++i) {
                if (this.windowMenuWindows[i] != null) {
                    ++n2;
                    continue;
                }
                n = i;
                break;
            }
            if (n == -1) {
                VMInternalFrame[] vMInternalFrameArray = new VMInternalFrame[n3 + 1];
                System.arraycopy(this.windowMenuWindows, 0, vMInternalFrameArray, 0, n3);
                this.windowMenuWindows = vMInternalFrameArray;
                n = n3;
            }
            this.windowMenuWindows[n] = vMInternalFrame;
            String string = "" + (n + 1);
            int n4 = string.length();
            String string2 = vMInternalFrame.getVMPanel().getDisplayName();
            String string3 = SwingUtilities.layoutCompoundLabel(this, this.getGraphics().getFontMetrics(this.getFont()), string + " " + string2, null, 0, 0, 0, 0, this.viewR, this.iconR, this.textR, 0);
            JMenuItem jMenuItem = new JMenuItem(string + " " + vMInternalFrame.getVMPanel().getDisplayName(), string.charAt(n4 - 1));
            Utilities.setAccessibleDescription(jMenuItem, Resources.getText("WindowFrame.description", vMInternalFrame.getVMPanel().getDisplayName()));
            if (string3.endsWith("...")) {
                jMenuItem.setToolTipText(string2);
            }
            jMenuItem.setDisplayedMnemonicIndex(n4 - 1);
            jMenuItem.putClientProperty("JConsole.vmIF", vMInternalFrame);
            jMenuItem.addActionListener(JConsole.this);
            vMInternalFrame.putClientProperty("JConsole.menuItem", jMenuItem);
            this.add((Component)jMenuItem, n2);
        }

        private void remove(VMInternalFrame vMInternalFrame) {
            for (int i = 0; i < this.windowMenuWindows.length; ++i) {
                if (this.windowMenuWindows[i] != vMInternalFrame) continue;
                this.windowMenuWindows[i] = null;
            }
            JMenuItem jMenuItem = (JMenuItem)vMInternalFrame.getClientProperty("JConsole.menuItem");
            this.remove(jMenuItem);
            jMenuItem.putClientProperty("JConsole.vmIF", null);
            vMInternalFrame.putClientProperty("JConsole.menuItem", null);
            if (this.separatorPosition == this.getMenuComponentCount() - 1) {
                this.remove(this.getMenuComponent(this.getMenuComponentCount() - 1));
            }
        }
    }
}

