/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import sun.org.mozilla.javascript.internal.BaseFunction;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.FunctionObject;
import sun.org.mozilla.javascript.internal.Kit;
import sun.org.mozilla.javascript.internal.MemberBox;
import sun.org.mozilla.javascript.internal.ObjToIntMap;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.Wrapper;
import sun.org.mozilla.javascript.internal.debug.DebuggableObject;

public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject {
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private static final Object HAS_STATIC_ACCESSORS = Void.TYPE;
    private static final Slot REMOVED = new Slot();
    private transient Slot[] slots;
    private int count;
    private transient Slot lastAccess = REMOVED;
    private volatile transient Hashtable associatedValues;

    static void checkValidAttributes(int n) {
        if ((n & 0xFFFFFFF8) != 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scriptable, Scriptable scriptable2) {
        if (scriptable == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scriptable;
        this.prototypeObject = scriptable2;
    }

    public abstract String getClassName();

    public boolean has(String string, Scriptable scriptable) {
        return null != this.getNamedSlot(string);
    }

    public boolean has(int n, Scriptable scriptable) {
        return null != this.getSlot(null, n);
    }

    public Object get(String string, Scriptable scriptable) {
        Slot slot = this.getNamedSlot(string);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot getterSlot = (GetterSlot)slot;
            if (getterSlot.getter != null) {
                return this.getByGetter(getterSlot, scriptable);
            }
        }
        return slot.value;
    }

    public Object get(int n, Scriptable scriptable) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.value;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        int n;
        Slot slot = this.lastAccess;
        if ((string != slot.stringKey || slot.wasDeleted != 0) && (slot = this.getSlot(string, n = string.hashCode())) == null) {
            if (scriptable != this) {
                scriptable.put(string, scriptable, object);
                return;
            }
            slot = this.addSlot(string, n, null);
        }
        if (scriptable == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", string);
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot getterSlot = (GetterSlot)slot;
            if (getterSlot.setter != null) {
                this.setBySetter(getterSlot, scriptable, object);
            }
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(string, scriptable, object);
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            if (scriptable != this) {
                scriptable.put(n, scriptable, object);
                return;
            }
            slot = this.addSlot(null, n, null);
        }
        if (scriptable == this && this.isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", Integer.toString(n));
        }
        if ((slot.attributes & 1) != 0) {
            return;
        }
        if (this == scriptable) {
            slot.value = object;
        } else {
            scriptable.put(n, scriptable, object);
        }
    }

    public void delete(String string) {
        this.removeSlot(string, string.hashCode());
    }

    public void delete(int n) {
        this.removeSlot(null, n);
    }

    public final int getAttributes(String string, Scriptable scriptable) {
        return this.getAttributes(string);
    }

    public final int getAttributes(int n, Scriptable scriptable) {
        return this.getAttributes(n);
    }

    public final void setAttributes(String string, Scriptable scriptable, int n) {
        this.setAttributes(string, n);
    }

    public void setAttributes(int n, Scriptable scriptable, int n2) {
        this.setAttributes(n, n2);
    }

    public int getAttributes(String string) {
        Slot slot = this.getNamedSlot(string);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", string);
        }
        return slot.attributes;
    }

    public int getAttributes(int n) {
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(n));
        }
        return slot.attributes;
    }

    public void setAttributes(String string, int n) {
        ScriptableObject.checkValidAttributes(n);
        Slot slot = this.getNamedSlot(string);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", string);
        }
        slot.attributes = (short)n;
    }

    public void setAttributes(int n, int n2) {
        ScriptableObject.checkValidAttributes(n2);
        Slot slot = this.getSlot(null, n);
        if (slot == null) {
            throw Context.reportRuntimeError1("msg.prop.not.found", String.valueOf(n));
        }
        slot.attributes = (short)n2;
    }

    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    public void setPrototype(Scriptable scriptable) {
        this.prototypeObject = scriptable;
    }

    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    public void setParentScope(Scriptable scriptable) {
        this.parentScopeObject = scriptable;
    }

    public Object[] getIds() {
        return this.getIds(false);
    }

    public Object[] getAllIds() {
        return this.getIds(true);
    }

    public Object getDefaultValue(Class clazz) {
        Context context = null;
        for (int i = 0; i < 2; ++i) {
            Object object;
            Object object2;
            Object[] objectArray;
            String string;
            boolean bl;
            if (clazz == ScriptRuntime.StringClass) {
                bl = i == 0;
            } else {
                boolean bl2 = bl = i == 1;
            }
            if (bl) {
                string = "toString";
                objectArray = ScriptRuntime.emptyArgs;
            } else {
                string = "valueOf";
                objectArray = new Object[1];
                if (clazz == null) {
                    object2 = "undefined";
                } else if (clazz == ScriptRuntime.StringClass) {
                    object2 = "string";
                } else if (clazz == ScriptRuntime.ScriptableClass) {
                    object2 = "object";
                } else if (clazz == ScriptRuntime.FunctionClass) {
                    object2 = "function";
                } else if (clazz == ScriptRuntime.BooleanClass || clazz == Boolean.TYPE) {
                    object2 = "boolean";
                } else if (clazz == ScriptRuntime.NumberClass || clazz == ScriptRuntime.ByteClass || clazz == Byte.TYPE || clazz == ScriptRuntime.ShortClass || clazz == Short.TYPE || clazz == ScriptRuntime.IntegerClass || clazz == Integer.TYPE || clazz == ScriptRuntime.FloatClass || clazz == Float.TYPE || clazz == ScriptRuntime.DoubleClass || clazz == Double.TYPE) {
                    object2 = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", clazz.toString());
                }
                objectArray[0] = object2;
            }
            object2 = ScriptableObject.getProperty((Scriptable)this, string);
            if (!(object2 instanceof Function)) continue;
            Function function = (Function)object2;
            if (context == null) {
                context = Context.getContext();
            }
            if ((object2 = function.call(context, function.getParentScope(), this, objectArray)) == null) continue;
            if (!(object2 instanceof Scriptable)) {
                return object2;
            }
            if (clazz == ScriptRuntime.ScriptableClass || clazz == ScriptRuntime.FunctionClass) {
                return object2;
            }
            if (!bl || !(object2 instanceof Wrapper) || !((object = ((Wrapper)object2).unwrap()) instanceof String)) continue;
            return object;
        }
        String string = clazz == null ? "undefined" : clazz.getName();
        throw ScriptRuntime.typeError1("msg.default.value", string);
    }

    public boolean hasInstance(Scriptable scriptable) {
        return ScriptRuntime.jsDelegatesTo(scriptable, this);
    }

    protected Object equivalentValues(Object object) {
        return this == object ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static void defineClass(Scriptable scriptable, Class clazz) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, false, false);
    }

    public static void defineClass(Scriptable scriptable, Class clazz, boolean bl) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scriptable, clazz, bl, false);
    }

    public static String defineClass(Scriptable scriptable, Class clazz, boolean bl, boolean bl2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject functionObject;
        String string;
        Class clazz2;
        Executable executable;
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            executable = methodArray[i];
            if (!((Method)executable).getName().equals("init")) continue;
            Class<?>[] classArray = ((Method)executable).getParameterTypes();
            if (classArray.length == 3 && classArray[0] == ScriptRuntime.ContextClass && classArray[1] == ScriptRuntime.ScriptableClass && classArray[2] == Boolean.TYPE && Modifier.isStatic(((Method)executable).getModifiers())) {
                Object[] objectArray = new Object[]{Context.getContext(), scriptable, bl ? Boolean.TRUE : Boolean.FALSE};
                ((Method)executable).invoke(null, objectArray);
                return null;
            }
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(((Method)executable).getModifiers())) continue;
            Object[] objectArray = new Object[]{scriptable};
            ((Method)executable).invoke(null, objectArray);
            return null;
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        executable = null;
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length != 0) continue;
            executable = constructorArray[i];
            break;
        }
        if (executable == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz.getName());
        }
        Scriptable scriptable2 = (Scriptable)((Constructor)executable).newInstance(ScriptRuntime.emptyArgs);
        String string2 = scriptable2.getClassName();
        Scriptable scriptable3 = null;
        if (bl2 && ScriptRuntime.ScriptableClass.isAssignableFrom(clazz2 = clazz.getSuperclass()) && (string = ScriptableObject.defineClass(scriptable, clazz2, bl, bl2)) != null) {
            scriptable3 = ScriptableObject.getClassPrototype(scriptable, string);
        }
        if (scriptable3 == null) {
            scriptable3 = ScriptableObject.getObjectPrototype(scriptable);
        }
        scriptable2.setPrototype(scriptable3);
        Executable executable2 = FunctionObject.findSingleMethod(methodArray, "jsConstructor");
        if (executable2 == null) {
            if (constructorArray.length == 1) {
                executable2 = constructorArray[0];
            } else if (constructorArray.length == 2) {
                if (constructorArray[0].getParameterTypes().length == 0) {
                    executable2 = constructorArray[1];
                } else if (constructorArray[1].getParameterTypes().length == 0) {
                    executable2 = constructorArray[0];
                }
            }
            if (executable2 == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz.getName());
            }
        }
        if ((functionObject = new FunctionObject(string2, executable2, scriptable)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", executable2.getName());
        }
        functionObject.addAsConstructor(scriptable, scriptable2);
        Method method = null;
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Object object2;
            if (methodArray[i] == executable2) continue;
            String string3 = methodArray[i].getName();
            if (string3.equals("finishInit") && ((Class<?>[])(object2 = methodArray[i].getParameterTypes())).length == 3 && object2[0] == ScriptRuntime.ScriptableClass && object2[1] == FunctionObject.class && object2[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(methodArray[i].getModifiers())) {
                method = methodArray[i];
                continue;
            }
            if (string3.indexOf(36) != -1 || string3.equals("jsConstructor")) continue;
            object2 = null;
            if (string3.startsWith("jsFunction_")) {
                object2 = "jsFunction_";
            } else if (string3.startsWith("jsStaticFunction_")) {
                object2 = "jsStaticFunction_";
                if (!Modifier.isStatic(methodArray[i].getModifiers())) {
                    throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
                }
            } else if (string3.startsWith("jsGet_")) {
                object2 = "jsGet_";
            } else {
                if (!string3.startsWith("jsSet_")) continue;
                object2 = "jsSet_";
            }
            string3 = string3.substring(((String)object2).length());
            if (object2 == "jsSet_") continue;
            if (object2 == "jsGet_") {
                if (!(scriptable2 instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", scriptable2.getClass().toString(), string3);
                }
                object = FunctionObject.findSingleMethod(methodArray, "jsSet_" + string3);
                int n = 6 | (object != null ? 0 : 1);
                ((ScriptableObject)scriptable2).defineProperty(string3, null, methodArray[i], (Method)object, n);
                continue;
            }
            object = new FunctionObject(string3, methodArray[i], scriptable2);
            if (((FunctionObject)object).isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", executable2.getName());
            }
            Scriptable scriptable4 = object2 == "jsStaticFunction_" ? functionObject : scriptable2;
            ScriptableObject.defineProperty(scriptable4, string3, object, 2);
            if (!bl) continue;
            ((ScriptableObject)object).sealObject();
        }
        if (method != null) {
            Object[] objectArray = new Object[]{scriptable, functionObject, scriptable2};
            method.invoke(null, objectArray);
        }
        if (bl) {
            functionObject.sealObject();
            if (scriptable2 instanceof ScriptableObject) {
                ((ScriptableObject)scriptable2).sealObject();
            }
        }
        return string2;
    }

    public void defineProperty(String string, Object object, int n) {
        this.put(string, (Scriptable)this, object);
        this.setAttributes(string, n);
    }

    public static void defineProperty(Scriptable scriptable, String string, Object object, int n) {
        if (!(scriptable instanceof ScriptableObject)) {
            scriptable.put(string, scriptable, object);
            return;
        }
        ScriptableObject scriptableObject = (ScriptableObject)scriptable;
        scriptableObject.defineProperty(string, object, n);
    }

    public void defineProperty(String string, Class clazz, int n) {
        int n2 = string.length();
        if (n2 == 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[3 + n2];
        string.getChars(0, n2, cArray, 3);
        cArray[3] = Character.toUpperCase(cArray[3]);
        cArray[0] = 103;
        cArray[1] = 101;
        cArray[2] = 116;
        String string2 = new String(cArray);
        cArray[0] = 115;
        String string3 = new String(cArray);
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        Method method = FunctionObject.findSingleMethod(methodArray, string2);
        Method method2 = FunctionObject.findSingleMethod(methodArray, string3);
        if (method2 == null) {
            n |= 1;
        }
        this.defineProperty(string, null, method, method2 == null ? null : method2, n);
    }

    public void defineProperty(String string, Object object, Method method, Method method2, int n) {
        Serializable serializable;
        Class<?>[] classArray;
        if (object == null && Modifier.isStatic(method.getModifiers())) {
            object = HAS_STATIC_ACCESSORS;
        }
        if ((classArray = method.getParameterTypes()).length != 0) {
            if (classArray.length != 1 || classArray[0] != ScriptRuntime.ScriptableObjectClass) {
                throw Context.reportRuntimeError1("msg.bad.getter.parms", method.toString());
            }
        } else if (object != null) {
            throw Context.reportRuntimeError1("msg.obj.getter.parms", method.toString());
        }
        if (method2 != null) {
            int n2;
            if (object == HAS_STATIC_ACCESSORS != Modifier.isStatic(method2.getModifiers())) {
                throw Context.reportRuntimeError0("msg.getter.static");
            }
            classArray = method2.getParameterTypes();
            if (classArray.length == 2) {
                if (classArray[0] != ScriptRuntime.ScriptableObjectClass) {
                    throw Context.reportRuntimeError0("msg.setter2.parms");
                }
                if (object == null) {
                    throw Context.reportRuntimeError1("msg.setter1.parms", method2.toString());
                }
            } else if (classArray.length == 1) {
                if (object != null) {
                    throw Context.reportRuntimeError1("msg.setter2.expected", method2.toString());
                }
            } else {
                throw Context.reportRuntimeError0("msg.setter.parms");
            }
            if ((n2 = FunctionObject.getTypeTag((Class)(serializable = classArray[classArray.length - 1]))) == 0) {
                throw Context.reportRuntimeError2("msg.setter2.expected", ((Class)serializable).getName(), method2.toString());
            }
        }
        serializable = new GetterSlot();
        ((GetterSlot)serializable).delegateTo = object;
        ((GetterSlot)serializable).getter = new MemberBox(method);
        if (method2 != null) {
            ((GetterSlot)serializable).setter = new MemberBox(method2);
        }
        ((GetterSlot)serializable).attributes = (short)n;
        Slot slot = this.addSlot(string, string.hashCode(), (Slot)serializable);
        if (slot != serializable) {
            throw new RuntimeException("Property already exists");
        }
    }

    public void defineFunctionProperties(String[] stringArray, Class clazz, int n) {
        Method[] methodArray = FunctionObject.getMethodList(clazz);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Method method = FunctionObject.findSingleMethod(methodArray, string);
            if (method == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", string, clazz.getName());
            }
            FunctionObject functionObject = new FunctionObject(string, method, this);
            this.defineProperty(string, functionObject, n);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Object");
    }

    public static Scriptable getFunctionPrototype(Scriptable scriptable) {
        return ScriptableObject.getClassPrototype(scriptable, "Function");
    }

    public static Scriptable getClassPrototype(Scriptable scriptable, String string) {
        Object object;
        Object object2 = ScriptableObject.getProperty(scriptable = ScriptableObject.getTopLevelScope(scriptable), string);
        if (object2 instanceof BaseFunction) {
            object = ((BaseFunction)object2).getPrototypeProperty();
        } else if (object2 instanceof Scriptable) {
            Scriptable scriptable2 = (Scriptable)object2;
            object = scriptable2.get("prototype", scriptable2);
        } else {
            return null;
        }
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable scriptable) {
        Scriptable scriptable2;
        while ((scriptable2 = scriptable.getParentScope()) != null) {
            scriptable = scriptable2;
        }
        return scriptable;
    }

    public synchronized void sealObject() {
        if (this.count >= 0) {
            this.count = -1 - this.count;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    public static Object getProperty(Scriptable scriptable, String string) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(string, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static Object getProperty(Scriptable scriptable, int n) {
        Object object;
        Scriptable scriptable2 = scriptable;
        while ((object = scriptable.get(n, scriptable2)) == Scriptable.NOT_FOUND && (scriptable = scriptable.getPrototype()) != null) {
        }
        return object;
    }

    public static boolean hasProperty(Scriptable scriptable, String string) {
        return null != ScriptableObject.getBase(scriptable, string);
    }

    public static boolean hasProperty(Scriptable scriptable, int n) {
        return null != ScriptableObject.getBase(scriptable, n);
    }

    public static void putProperty(Scriptable scriptable, String string, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(string, scriptable, object);
    }

    public static void putProperty(Scriptable scriptable, int n, Object object) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            scriptable2 = scriptable;
        }
        scriptable2.put(n, scriptable, object);
    }

    public static boolean deleteProperty(Scriptable scriptable, String string) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, string);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(string);
        return !scriptable2.has(string, scriptable);
    }

    public static boolean deleteProperty(Scriptable scriptable, int n) {
        Scriptable scriptable2 = ScriptableObject.getBase(scriptable, n);
        if (scriptable2 == null) {
            return true;
        }
        scriptable2.delete(n);
        return !scriptable2.has(n, scriptable);
    }

    public static Object[] getPropertyIds(Scriptable scriptable) {
        if (scriptable == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] objectArray = scriptable.getIds();
        ObjToIntMap objToIntMap = null;
        while ((scriptable = scriptable.getPrototype()) != null) {
            int n;
            Object[] objectArray2 = scriptable.getIds();
            if (objectArray2.length == 0) continue;
            if (objToIntMap == null) {
                if (objectArray.length == 0) {
                    objectArray = objectArray2;
                    continue;
                }
                objToIntMap = new ObjToIntMap(objectArray.length + objectArray2.length);
                for (n = 0; n != objectArray.length; ++n) {
                    objToIntMap.intern(objectArray[n]);
                }
                objectArray = null;
            }
            for (n = 0; n != objectArray2.length; ++n) {
                objToIntMap.intern(objectArray2[n]);
            }
        }
        if (objToIntMap != null) {
            objectArray = objToIntMap.getKeys();
        }
        return objectArray;
    }

    public static Object callMethod(Scriptable scriptable, String string, Object[] objectArray) {
        return ScriptableObject.callMethod(null, scriptable, string, objectArray);
    }

    public static Object callMethod(Context context, Scriptable scriptable, String string, Object[] objectArray) {
        Object object = ScriptableObject.getProperty(scriptable, string);
        if (!(object instanceof Function)) {
            throw ScriptRuntime.notFunctionError(scriptable, string);
        }
        Function function = (Function)object;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        if (context != null) {
            return function.call(context, scriptable2, scriptable, objectArray);
        }
        return Context.call(null, function, scriptable2, scriptable, objectArray);
    }

    private static Scriptable getBase(Scriptable scriptable, String string) {
        while (!scriptable.has(string, scriptable) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    private static Scriptable getBase(Scriptable scriptable, int n) {
        while (!scriptable.has(n, scriptable) && (scriptable = scriptable.getPrototype()) != null) {
        }
        return scriptable;
    }

    public final Object getAssociatedValue(Object object) {
        Hashtable hashtable = this.associatedValues;
        if (hashtable == null) {
            return null;
        }
        return hashtable.get(object);
    }

    public static Object getTopScopeValue(Scriptable scriptable, Object object) {
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        do {
            ScriptableObject scriptableObject;
            Object object2;
            if (!(scriptable instanceof ScriptableObject) || (object2 = (scriptableObject = (ScriptableObject)scriptable).getAssociatedValue(object)) == null) continue;
            return object2;
        } while ((scriptable = scriptable.getPrototype()) != null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object associateValue(Object object, Object object2) {
        if (object2 == null) {
            throw new IllegalArgumentException();
        }
        Hashtable hashtable = this.associatedValues;
        if (hashtable == null) {
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                hashtable = this.associatedValues;
                if (hashtable == null) {
                    this.associatedValues = hashtable = new Hashtable();
                }
            }
        }
        return Kit.initHash(hashtable, object, object2);
    }

    private Object getByGetter(GetterSlot getterSlot, Scriptable scriptable) {
        Object[] objectArray;
        Object object;
        if (getterSlot.delegateTo == null) {
            if (scriptable != this) {
                Class clazz = getterSlot.getter.getDeclaringClass();
                while (!clazz.isInstance(scriptable) && (scriptable = scriptable.getPrototype()) != this) {
                    if (scriptable != null) continue;
                    scriptable = this;
                    break;
                }
            }
            object = scriptable;
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            object = getterSlot.delegateTo;
            objectArray = new Object[]{this};
        }
        return getterSlot.getter.invoke(object, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBySetter(GetterSlot getterSlot, Scriptable scriptable, Object object) {
        Object[] objectArray;
        Object object2;
        if (!(scriptable == this || getterSlot.delegateTo == null && getterSlot.setter.getDeclaringClass().isInstance(scriptable))) {
            scriptable.put(getterSlot.stringKey, scriptable, object);
            return;
        }
        Context context = Context.getContext();
        Class[] classArray = getterSlot.setter.argTypes;
        Class clazz = classArray[classArray.length - 1];
        int n = FunctionObject.getTypeTag(clazz);
        Object object3 = FunctionObject.convertArg(context, scriptable, object, n);
        if (getterSlot.delegateTo == null) {
            object2 = scriptable;
            objectArray = new Object[]{object3};
        } else {
            if (scriptable != this) {
                Kit.codeBug();
            }
            object2 = getterSlot.delegateTo;
            objectArray = new Object[]{this, object3};
        }
        if (((ScriptableObject)scriptable).isSealed()) {
            throw Context.reportRuntimeError1("msg.modify.sealed", getterSlot.stringKey);
        }
        Object object4 = getterSlot.setter.invoke(object2, objectArray);
        if (getterSlot.setter.method().getReturnType() != Void.TYPE) {
            Slot slot = new Slot();
            slot.intKey = getterSlot.intKey;
            slot.stringKey = getterSlot.stringKey;
            slot.attributes = getterSlot.attributes;
            slot.value = object4;
            ScriptableObject scriptableObject = this;
            synchronized (scriptableObject) {
                int n2 = ScriptableObject.getSlotPosition(this.slots, getterSlot.stringKey, getterSlot.intKey);
                if (n2 >= 0 && this.slots[n2] == getterSlot) {
                    this.slots[n2] = slot;
                    this.lastAccess = slot;
                }
            }
        }
    }

    private Slot getNamedSlot(String string) {
        Slot slot = this.lastAccess;
        if (string == slot.stringKey && slot.wasDeleted == 0) {
            return slot;
        }
        Slot[] slotArray = this.slots;
        int n = string.hashCode();
        int n2 = ScriptableObject.getSlotPosition(slotArray, string, n);
        if (n2 < 0) {
            return null;
        }
        slot = slotArray[n2];
        slot.stringKey = string;
        this.lastAccess = slot;
        return slot;
    }

    private Slot getSlot(String string, int n) {
        Slot[] slotArray = this.slots;
        int n2 = ScriptableObject.getSlotPosition(slotArray, string, n);
        return n2 < 0 ? null : slotArray[n2];
    }

    private static int getSlotPosition(Slot[] slotArray, String string, int n) {
        if (slotArray != null) {
            Slot slot;
            int n2;
            int n3 = n2 = (n & Integer.MAX_VALUE) % slotArray.length;
            while ((slot = slotArray[n3]) != null) {
                if (slot != REMOVED && slot.intKey == n && (slot.stringKey == string || string != null && string.equals(slot.stringKey))) {
                    return n3;
                }
                if (++n3 == slotArray.length) {
                    n3 = 0;
                }
                if (n3 != n2) continue;
            }
        }
        return -1;
    }

    private synchronized Slot addSlot(String string, int n, Slot slot) {
        if (this.isSealed()) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeError1("msg.add.sealed", string2);
        }
        if (this.slots == null) {
            this.slots = new Slot[5];
        }
        return this.addSlotImpl(string, n, slot);
    }

    private Slot addSlotImpl(String string, int n, Slot slot) {
        int n2;
        int n3 = n2 = (n & Integer.MAX_VALUE) % this.slots.length;
        do {
            Slot slot2;
            if ((slot2 = this.slots[n3]) == null || slot2 == REMOVED) {
                if (4 * (this.count + 1) > 3 * this.slots.length) {
                    this.grow();
                    return this.addSlotImpl(string, n, slot);
                }
                slot2 = slot == null ? new Slot() : slot;
                slot2.stringKey = string;
                slot2.intKey = n;
                this.slots[n3] = slot2;
                ++this.count;
                return slot2;
            }
            if (slot2.intKey == n && (slot2.stringKey == string || string != null && string.equals(slot2.stringKey))) {
                return slot2;
            }
            if (++n3 != this.slots.length) continue;
            n3 = 0;
        } while (n3 != n2);
        throw new IllegalStateException();
    }

    private synchronized void removeSlot(String string, int n) {
        if (this.isSealed()) {
            String string2 = string != null ? string : Integer.toString(n);
            throw Context.reportRuntimeError1("msg.remove.sealed", string2);
        }
        int n2 = ScriptableObject.getSlotPosition(this.slots, string, n);
        if (n2 >= 0) {
            Slot slot = this.slots[n2];
            if ((slot.attributes & 4) == 0) {
                slot.wasDeleted = 1;
                if (slot == this.lastAccess) {
                    this.lastAccess = REMOVED;
                }
                --this.count;
                this.slots[n2] = this.count != 0 ? REMOVED : null;
            }
        }
    }

    private void grow() {
        Slot[] slotArray = new Slot[this.slots.length * 2 + 1];
        for (int i = this.slots.length - 1; i >= 0; --i) {
            Slot slot = this.slots[i];
            if (slot == null || slot == REMOVED) continue;
            int n = (slot.intKey & Integer.MAX_VALUE) % slotArray.length;
            while (slotArray[n] != null) {
                if (++n != slotArray.length) continue;
                n = 0;
            }
            slotArray[n] = slot;
        }
        this.slots = slotArray;
    }

    Object[] getIds(boolean bl) {
        Slot[] slotArray = this.slots;
        Object[] objectArray = ScriptRuntime.emptyArgs;
        if (slotArray == null) {
            return objectArray;
        }
        int n = 0;
        for (int i = 0; i < slotArray.length; ++i) {
            Slot slot = slotArray[i];
            if (slot == null || slot == REMOVED || !bl && (slot.attributes & 2) != 0) continue;
            if (n == 0) {
                objectArray = new Object[slotArray.length - i];
            }
            objectArray[n++] = slot.stringKey != null ? slot.stringKey : new Integer(slot.intKey);
        }
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Slot[] slotArray;
        objectOutputStream.defaultWriteObject();
        int n = this.count;
        if (n < 0) {
            n = -1 - this.count;
        }
        if ((slotArray = this.slots) == null) {
            if (n != 0) {
                Kit.codeBug();
            }
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(slotArray.length);
            int n2 = 0;
            while (n != 0) {
                Slot slot = slotArray[n2];
                if (slot != null && slot != REMOVED) {
                    --n;
                    objectOutputStream.writeObject(slot);
                }
                ++n2;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lastAccess = REMOVED;
        int n = objectInputStream.readInt();
        if (n != 0) {
            this.slots = new Slot[n];
            int n2 = this.count;
            boolean bl = false;
            if (n2 < 0) {
                n2 = -1 - n2;
                bl = true;
            }
            this.count = 0;
            for (int i = 0; i != n2; ++i) {
                Slot slot = (Slot)objectInputStream.readObject();
                this.addSlotImpl(slot.stringKey, slot.intKey, slot);
            }
            if (bl) {
                this.count = -1 - this.count;
            }
        }
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object delegateTo;
        MemberBox getter;
        MemberBox setter;

        private GetterSlot() {
        }
    }

    private static class Slot
    implements Serializable {
        static final long serialVersionUID = -3539051633409902634L;
        int intKey;
        String stringKey;
        Object value;
        short attributes;
        transient byte wasDeleted;

        private Slot() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.stringKey != null) {
                this.intKey = this.stringKey.hashCode();
            }
        }
    }
}

