/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9;

import com.ibm.dtfj.javacore.parser.framework.parser.ILookAheadBuffer;
import com.ibm.dtfj.javacore.parser.framework.parser.ISectionParser;
import com.ibm.dtfj.javacore.parser.framework.parser.ParserException;
import com.ibm.dtfj.javacore.parser.framework.scanner.IParserToken;
import com.ibm.dtfj.javacore.parser.framework.tag.ILineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.ITagParser;
import com.ibm.dtfj.javacore.parser.j9.IAttributeValueMap;
import com.ibm.dtfj.javacore.parser.j9.J9TagManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;

public abstract class SectionParserGrammar
implements ISectionParser {
    protected static final int FORCE_THROW = 1;
    protected ILookAheadBuffer fLookAheadBuffer;
    protected String fSectionName;
    protected J9TagManager fTagManager;
    protected ITagParser fTagParser;
    protected static final int DEFAULT_DEPTH = 3;
    private final Vector fErrors;

    public SectionParserGrammar(String sectionName) {
        this.fSectionName = sectionName;
        this.fErrors = new Vector();
    }

    protected void setLookAheadBuffer(ILookAheadBuffer lookAheadBuffer, int depth) throws ParserException {
        this.fLookAheadBuffer = lookAheadBuffer;
        try {
            this.fLookAheadBuffer.setLookAheadDepth(depth);
        }
        catch (IOException e) {
            this.handleError(e, 1);
        }
    }

    protected void setLookAheadBuffer(ILookAheadBuffer lookAheadBuffer) throws ParserException {
        this.setLookAheadBuffer(lookAheadBuffer, 3);
    }

    protected ILookAheadBuffer getLookAheadBuffer() {
        return this.fLookAheadBuffer;
    }

    protected void setTagManager(J9TagManager tagManager) {
        this.fTagManager = tagManager;
        this.fTagParser = this.fTagManager.getTagParser(this.fSectionName);
    }

    protected void handleRequiredMismatch(String expectedType, String actualType, String actualValue) throws ParserException {
        this.handleErrorAtLineNumber(this.getCurrentFileLineNumber(), "Expected Type: " + expectedType + " / Actual Type: " + actualType + ": " + actualValue, null);
    }

    protected void handleUnknownMismatch(String actualType, String actualValue) throws ParserException {
        this.handleErrorAtLineNumber(this.getCurrentFileLineNumber(), "Unknown data -> " + actualType + ": " + actualValue, null);
    }

    protected IParserToken lookAhead(int depth) throws ParserException {
        IParserToken token = null;
        try {
            token = this.fLookAheadBuffer.lookAhead(depth);
        }
        catch (IOException e) {
            this.handleError(e, 1);
        }
        return token;
    }

    public String getSectionName() {
        return this.fSectionName;
    }

    protected void consume() throws ParserException {
        try {
            this.fLookAheadBuffer.consume();
        }
        catch (IOException e) {
            this.handleError(e, 1);
        }
    }

    protected boolean match(String type, boolean required) throws ParserException {
        boolean matched = false;
        boolean searchMore = true;
        IParserToken token = null;
        String tokenType = null;
        String tokenValue = null;
        while (searchMore && !this.fLookAheadBuffer.allConsumed() && !(matched = this.fLookAheadBuffer.match(type))) {
            token = this.lookAhead(1);
            if (token != null) {
                tokenType = token.getType();
                tokenValue = token.getValue();
            }
            if (this.isValidJavaCoreTag(token)) {
                searchMore = false;
                if (!required) continue;
                this.handleRequiredMismatch(type, tokenType, tokenValue);
                continue;
            }
            this.consume();
        }
        return matched;
    }

    protected IAttributeValueMap getLineRuleResults(IParserToken token) throws ParserException {
        IAttributeValueMap results = null;
        if (token != null) {
            ILineRule lineRule = this.fTagParser.getLineRule(token.getType());
            token = this.lookAhead(1);
            if (token != null && token.getType().equals("UNPARSED")) {
                this.consume();
                if (lineRule != null) {
                    results = lineRule.parseLine(token.getValue(), token.getLineNumber(), token.getOffset());
                }
            }
        } else {
            this.handleError("Cannot get line rule for a null token.");
        }
        return results;
    }

    protected boolean matchRequired(String type) throws ParserException {
        return this.match(type, true);
    }

    protected boolean matchOptional(String type) throws ParserException {
        return this.match(type, false);
    }

    protected IAttributeValueMap processTagLineRequired(String tagName) throws ParserException {
        return this.processTagLine(tagName, true);
    }

    protected IAttributeValueMap processTagLineOptional(String tagName) throws ParserException {
        return this.processTagLine(tagName, false);
    }

    private IAttributeValueMap processTagLine(String tagName, boolean required) throws ParserException {
        IAttributeValueMap list = null;
        if (required ? this.matchRequired(tagName) : this.matchOptional(tagName)) {
            IParserToken token = this.lookAhead(1);
            this.consume();
            list = this.getLineRuleResults(token);
        }
        return list;
    }

    protected boolean isValidSectionTag(String tag) {
        return this.fTagManager.isTagInSection(tag, this.fSectionName);
    }

    protected boolean isValidJavaCoreTag(IParserToken token) {
        return token != null ? this.fTagManager.isTagInSection(token.getType(), "check_all") : false;
    }

    public int getCurrentFileLineNumber() throws ParserException {
        int fileLineNumber = -1;
        IParserToken token = this.lookAhead(1);
        if (token != null) {
            fileLineNumber = token.getLineNumber();
        }
        return fileLineNumber;
    }

    public Iterator getErrors() {
        return this.fErrors.iterator();
    }

    protected void handleError(String message, Exception e) throws ParserException {
        this.handleError(message + e.getMessage());
    }

    protected void handleError(String message) throws ParserException {
        if (message != null) {
            System.err.println(message);
            this.fErrors.add(message);
        }
    }

    protected void handleErrorAtLineNumber(int fileLineNumber, String message, Exception e) throws ParserException {
        String msg = "In Section " + this.getSectionName() + " at line " + fileLineNumber + " :: ";
        if (message != null) {
            msg = msg + message;
        }
        if (e != null) {
            this.handleError(msg, e);
        } else {
            this.handleError(msg);
        }
    }

    protected void handleError(String message, int offset, int length) throws ParserException {
        this.handleError(message);
    }

    protected void handleError(Exception e) throws ParserException {
        this.handleError(e.getMessage());
    }

    protected void handleError(Exception e, int behaviour) throws ParserException {
        if (behaviour == 1) {
            throw new ParserException(e);
        }
    }
}

