/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageProcess;
import com.ibm.dtfj.image.javacore.JCImageThread;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.java.javacore.JCJavaClass;
import com.ibm.dtfj.java.javacore.JCJavaClassLoader;
import com.ibm.dtfj.java.javacore.JCJavaLocation;
import com.ibm.dtfj.java.javacore.JCJavaMethod;
import com.ibm.dtfj.java.javacore.JCJavaMonitor;
import com.ibm.dtfj.java.javacore.JCJavaObject;
import com.ibm.dtfj.java.javacore.JCJavaRuntime;
import com.ibm.dtfj.java.javacore.JCJavaStackFrame;
import com.ibm.dtfj.java.javacore.JCJavaThread;
import com.ibm.dtfj.java.javacore.JCJavaVMInitArgs;
import com.ibm.dtfj.java.javacore.JCJavaVMOption;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IJavaRuntimeBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;

public class JavaRuntimeBuilder
extends AbstractBuilderComponent
implements IJavaRuntimeBuilder {
    private JCImageProcess fImageProcess = null;
    private JCJavaRuntime fJavaRuntime = null;
    private JCImageAddressSpace fAddressSpace = null;
    private JCJavaVMInitArgs fJavaVMInitArgs = null;

    public JavaRuntimeBuilder(JCImageProcess imageProcess, String id) throws JCInvalidArgumentsException {
        super(id);
        if (imageProcess == null) {
            throw new JCInvalidArgumentsException("Must pass non-null image process");
        }
        this.fImageProcess = imageProcess;
        this.fJavaRuntime = new JCJavaRuntime(this.fImageProcess, id);
        this.fAddressSpace = this.fJavaRuntime.getImageProcess().getImageAddressSpace();
    }

    public JavaClassLoader addClassLoader(String classLoaderName, long clID, long objectID) throws BuilderFailureException {
        try {
            JCJavaObject javaObject;
            JCJavaClassLoader classLoader = this.fJavaRuntime.findJavaClassLoader(clID);
            if (classLoader == null) {
                classLoader = new JCJavaClassLoader(this.fJavaRuntime, clID);
            }
            if ((javaObject = classLoader.getInternalObject()) == null) {
                JCJavaClass javaClass = this.fJavaRuntime.findJavaClass(classLoaderName);
                if (javaClass == null) {
                    javaClass = new JCJavaClass(this.fJavaRuntime, classLoaderName);
                }
                ImagePointer objectPointer = this.fAddressSpace.getPointer(objectID);
                javaObject = new JCJavaObject(objectPointer, javaClass);
                classLoader.setObject(javaObject);
            }
            return classLoader;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public JavaClass addClass(JavaClassLoader jClassLoader, String name, long classID, long superClassID, String fileName) throws BuilderFailureException {
        try {
            JCJavaClassLoader classLoader = (JCJavaClassLoader)jClassLoader;
            JCJavaClass jClass = this.generateJavaClass(this.fJavaRuntime, name, classID);
            jClass.setJavaSuperClass(superClassID);
            if (classLoader.internalGetClass(name) == null) {
                classLoader.addClass(name);
            }
            return jClass;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    private JCJavaClass generateJavaClass(JCJavaRuntime runtime, String name, long classID) throws JCInvalidArgumentsException {
        if (name != null) {
            JCJavaClass jClass = runtime.findJavaClass(name);
            if (jClass == null) {
                jClass = new JCJavaClass(runtime, name);
            }
            if (this.fAddressSpace.isValidAddressID(classID)) {
                jClass.setID(classID);
            }
            return jClass;
        }
        throw new JCInvalidArgumentsException("Failed to add class.  Null class name");
    }

    public ImageProcess getImageProcess() {
        return this.fImageProcess;
    }

    public JavaThread addJavaThread(ImageThread imageThread, String name, long tid, long j9thread_t, String state, int priority) throws BuilderFailureException {
        try {
            JCJavaThread javaThread = this.fJavaRuntime.findJavaThread(tid);
            if (javaThread == null) {
                ImagePointer pointer = this.fAddressSpace.getPointer(tid);
                javaThread = new JCJavaThread(this.fJavaRuntime, pointer);
            }
            javaThread.setName(name);
            javaThread.setPriority(priority);
            javaThread.setImageThread((JCImageThread)imageThread);
            return javaThread;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public JavaStackFrame addJavaStackFrame(JavaThread javaThread, String className, String classFileName, String methodName, String methodType, String compilationLevel, int lineNumber) throws BuilderFailureException {
        try {
            JCJavaThread jThread = (JCJavaThread)javaThread;
            JCJavaClass jclass = this.fJavaRuntime.findJavaClass(className);
            if (jclass == null) {
                jclass = new JCJavaClass(this.fJavaRuntime, className);
            }
            JCJavaMethod method = new JCJavaMethod(methodName, jclass);
            JCJavaLocation location = new JCJavaLocation(method);
            location.setFilename(classFileName);
            location.setCompilation(compilationLevel);
            location.setLineNumber(lineNumber);
            JCJavaStackFrame stackFrame = new JCJavaStackFrame(jThread, location);
            return stackFrame;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public JavaMonitor addJavaMonitor(String monitorName, long monitorID, long objectID, String className, long owningThread) throws BuilderFailureException {
        try {
            JCJavaClass jClass;
            JCJavaMonitor monitor = this.fJavaRuntime.findMonitor(monitorID);
            if (monitor == null) {
                ImagePointer pointerMonitorID = this.fAddressSpace.getPointer(monitorID);
                monitor = new JCJavaMonitor(this.fJavaRuntime, pointerMonitorID, monitorName);
            }
            monitor.setOwner(owningThread);
            if (className != null && (jClass = this.generateJavaClass(this.fJavaRuntime, className, -1L)) != null && this.fAddressSpace.isValidAddressID(objectID)) {
                ImagePointer pointerObjectID = this.fAddressSpace.getPointer(objectID);
                JCJavaObject jobject = new JCJavaObject(pointerObjectID, jClass);
                monitor.setObject(jobject);
            }
            return monitor;
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void addBlockedThread(JavaMonitor monitor, long threadID) throws BuilderFailureException {
        JCJavaMonitor jmonitor = (JCJavaMonitor)monitor;
        ImagePointer pointer = this.fAddressSpace.getPointer(threadID);
        jmonitor.addEnterWaiter(pointer);
    }

    public void addWaitOnNotifyThread(JavaMonitor monitor, long threadID) throws BuilderFailureException {
        JCJavaMonitor jmonitor = (JCJavaMonitor)monitor;
        ImagePointer pointer = this.fAddressSpace.getPointer(threadID);
        jmonitor.addNotifyWaiter(pointer);
    }

    public void addVMInitArgs() throws BuilderFailureException {
        if (this.fJavaVMInitArgs != null) {
            throw new BuilderFailureException("JCJavaVMInitArgs already created for this JavaRuntime");
        }
        try {
            this.fJavaVMInitArgs = new JCJavaVMInitArgs(this.fJavaRuntime, 0, true);
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void addVMOption(String option) throws BuilderFailureException {
        if (this.fJavaVMInitArgs == null) {
            throw new BuilderFailureException("JCJavaVMInitArgs must be created before options added");
        }
        try {
            this.fJavaVMInitArgs.addOption(new JCJavaVMOption(option, null));
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }

    public void addVMOption(String option, long extraInfo) throws BuilderFailureException {
        if (this.fJavaVMInitArgs == null) {
            throw new BuilderFailureException("JCJavaVMInitArgs must be created before options added");
        }
        try {
            ImagePointer pointer = this.fAddressSpace.getPointer(extraInfo);
            this.fJavaVMInitArgs.addOption(new JCJavaVMOption(option, pointer));
        }
        catch (JCInvalidArgumentsException e) {
            throw new BuilderFailureException(e);
        }
    }
}

