/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaStackFrame
implements com.ibm.dtfj.java.JavaStackFrame {
    private JavaRuntime _javaVM;
    private ImagePointer _basePointer;
    private JavaMethod _method;
    private ImagePointer _pc;
    private int _lineNumber;
    private Vector _stackRoots = new Vector();

    public JavaStackFrame(JavaRuntime javaVM, ImagePointer basePointer, JavaMethod method, ImagePointer pc, int lineNumber) {
        if (null == basePointer) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null base pointer");
        }
        if (null == method) {
            throw new IllegalArgumentException("A Java stack frame must refer to a non-null method");
        }
        if (null == pc) {
            throw new IllegalArgumentException("A Java stack frame must have a non-null program counter");
        }
        this._javaVM = javaVM;
        this._basePointer = basePointer;
        this._method = method;
        this._pc = pc;
        this._lineNumber = lineNumber;
    }

    public ImagePointer getBasePointer() throws CorruptDataException {
        return this._basePointer;
    }

    public JavaLocation getLocation() throws CorruptDataException {
        return new com.ibm.dtfj.java.j9.JavaLocation(this._method, this._pc, this._lineNumber);
    }

    public void createObjectRef(long id) {
        JavaReference jRef = new JavaReference(this._javaVM, (Object)this, id, "StackFrame Root", 0, 4, 1);
        this._stackRoots.add(jRef);
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaStackFrame) {
            JavaStackFrame local = (JavaStackFrame)obj;
            isEqual = this._method.equals(local._method) && this._pc.equals(local._pc);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._method.hashCode() ^ this._pc.hashCode();
    }

    public Iterator getHeapRoots() {
        return this._stackRoots.iterator();
    }
}

