/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Iterator;
import java.util.Vector;

public class JavaClassLoader
implements com.ibm.dtfj.java.JavaClassLoader {
    private JavaRuntime _javaVM;
    private ImagePointer _id;
    private ImagePointer _objectID;
    private Vector _classIDs = new Vector();
    private com.ibm.dtfj.java.JavaObject _object = null;

    public JavaClassLoader(JavaRuntime runtime, ImagePointer id, ImagePointer obj) {
        if (null == runtime) {
            throw new IllegalArgumentException("Java VM for class loader must not be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("Class loader id must not be null");
        }
        this._javaVM = runtime;
        this._id = id;
        this._objectID = obj;
    }

    public Iterator getDefinedClasses() {
        Iterator cached = this._javaVM.getClasses();
        long thisID = this._id.getAddress();
        Vector<JavaClass> defined = new Vector<JavaClass>();
        while (cached.hasNext()) {
            Object next = cached.next();
            if (next instanceof CorruptData) continue;
            JavaClass currentClass = (JavaClass)next;
            try {
                JavaClassLoader currentClassLoader = (JavaClassLoader)currentClass.getClassLoader();
                if (currentClassLoader == null || currentClassLoader._id.getAddress() != thisID) continue;
                defined.add(currentClass);
            }
            catch (CorruptDataException e) {}
        }
        return defined.iterator();
    }

    public Iterator getCachedClasses() {
        Iterator ids = this._classIDs.iterator();
        Vector<CorruptData> classes = new Vector<CorruptData>();
        while (ids.hasNext()) {
            long oneID = (Long)ids.next();
            JavaClass oneClass = this._javaVM.getClassForID(oneID);
            if (null == oneClass) {
                classes.add(new CorruptData("Cache reference to unknown class " + oneID, null));
                continue;
            }
            classes.add((CorruptData)oneClass);
        }
        return classes.iterator();
    }

    public JavaClass findClass(String name) throws CorruptDataException {
        Iterator classes = this.getDefinedClasses();
        JavaClass found = null;
        while (classes.hasNext() && null == found) {
            JavaClass one = (JavaClass)classes.next();
            if (!one.getName().equals(name)) continue;
            found = one;
        }
        return found;
    }

    public com.ibm.dtfj.java.JavaObject getObject() throws CorruptDataException {
        if (null == this._object) {
            this._object = this._javaVM.getObjectAtAddress(this._objectID);
            if (null != this._object && this._object instanceof JavaObject) {
                ((JavaObject)this._object).setAssociatedObject(this);
            }
        }
        return this._object;
    }

    public long getID() {
        return this._id.getAddress();
    }

    public void addClassID(long id) {
        this._classIDs.add(new Long(id));
    }

    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaClassLoader) {
            JavaClassLoader local = (JavaClassLoader)obj;
            isEqual = this._javaVM.equals(local._javaVM) && this._id.equals(local._id);
        }
        return isEqual;
    }

    public int hashCode() {
        return this._javaVM.hashCode() ^ this._id.hashCode();
    }
}

