/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class JavaArrayClass
extends JavaAbstractClass {
    private int _sizeOffset;
    private int _bytesForSize;
    private int _firstElementOffset;
    private long _leafClassID;
    private int _dimension;
    private JavaClass javaLangObjectClass = null;

    public JavaArrayClass(JavaRuntime runtime, ImagePointer pointer, int modifiers, int flagOffset, int sizeOffset, int bytesForSize, int firstElementOffset, long leafClassID, int dimension, long loaderID, ImagePointer objectID) {
        super(runtime, pointer, modifiers, loaderID, objectID, flagOffset);
        this._sizeOffset = sizeOffset;
        this._bytesForSize = bytesForSize;
        this._firstElementOffset = firstElementOffset;
        this._leafClassID = leafClassID;
        this._dimension = dimension;
    }

    public String getName() throws CorruptDataException {
        String name = "";
        for (int x = 0; x < this._dimension; ++x) {
            name = name + "[";
        }
        String elementClassName = this.getLeafClass().getName();
        if (elementClassName.equals("boolean")) {
            name = name + "Z";
        } else if (elementClassName.equals("byte")) {
            name = name + "B";
        } else if (elementClassName.equals("char")) {
            name = name + "C";
        } else if (elementClassName.equals("short")) {
            name = name + "S";
        } else if (elementClassName.equals("int")) {
            name = name + "I";
        } else if (elementClassName.equals("long")) {
            name = name + "J";
        } else if (elementClassName.equals("float")) {
            name = name + "F";
        } else if (elementClassName.equals("double")) {
            name = name + "D";
        } else {
            name = name + "L";
            name = name + elementClassName;
            name = name + ';';
        }
        return name;
    }

    public JavaClass getSuperclass() throws CorruptDataException {
        long id;
        if (null == this.javaLangObjectClass && (id = this._javaVM.getClassIDForClassName("java/lang/Object", null)) != 0L) {
            this.javaLangObjectClass = this._javaVM.getClassForID(id);
        }
        return this.javaLangObjectClass;
    }

    public boolean isArray() throws CorruptDataException {
        return true;
    }

    public JavaClass getLeafClass() {
        return this._javaVM.getClassForID(this._leafClassID);
    }

    public JavaClass getComponentType() throws CorruptDataException {
        JavaClass componentType = null;
        String name = this.getName();
        if (1 == this._dimension) {
            componentType = this.getLeafClass();
        } else {
            long componentTypeAddress = this._javaVM.getClassIDForClassName(name.substring(1), this.getClassLoader());
            componentType = this._javaVM.getClassForID(componentTypeAddress);
        }
        if (componentType == null) {
            throw new CorruptDataException((com.ibm.dtfj.image.CorruptData)new CorruptData("Unable to retrieve component type for array: " + this.getName(), null));
        }
        return componentType;
    }

    public Iterator getDeclaredFields() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getDeclaredMethods() {
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getConstantPoolReferences() {
        return Collections.EMPTY_LIST.iterator();
    }

    public int getInstanceSize(com.ibm.dtfj.java.JavaObject instance) {
        try {
            int numberOfElements = instance.getArraySize();
            int instanceOverhead = this.getFirstElementOffset();
            int bytesPerElement = this.getBytesPerElement(((JavaObject)instance).getFObjectSize());
            return instanceOverhead + numberOfElements * bytesPerElement;
        }
        catch (CorruptDataException e) {
            return -1;
        }
    }

    public int getBytesPerElement(int refFieldSize) throws CorruptDataException {
        String elementClassName = this.getName().substring(1);
        int size = 0;
        size = elementClassName.equals("B") || elementClassName.equals("Z") ? 1 : (elementClassName.equals("C") || elementClassName.equals("S") ? 2 : (elementClassName.equals("F") || elementClassName.equals("I") ? 4 : (elementClassName.equals("D") || elementClassName.equals("J") ? 8 : refFieldSize)));
        return size;
    }

    public int getFirstElementOffset() {
        return this._firstElementOffset;
    }

    public int getSizeOffset() {
        return this._sizeOffset;
    }

    public int getNumberOfSizeBytes() {
        return this._bytesForSize;
    }

    public Iterator getReferences() {
        Vector references = new Vector();
        this.addSuperclassReference(references);
        this.addClassLoaderReference(references);
        return references.iterator();
    }
}

