/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageThread
implements ImageThread {
    private final String fImageThreadID;
    private final ImagePointer fNativeThreadID;
    private Properties fProperties;
    private Vector fRegisters;
    private Vector fStackSections;
    private Vector fStackFrames;
    private ImagePointer fSystemThreadID;

    public JCImageThread(ImagePointer nativeThreadID) throws JCInvalidArgumentsException {
        if (nativeThreadID == null) {
            throw new JCInvalidArgumentsException("Must pass a valid threadID pointer");
        }
        this.fImageThreadID = "0x" + Long.toHexString(nativeThreadID.getAddress());
        this.fNativeThreadID = nativeThreadID;
        this.fRegisters = new Vector();
        this.fStackSections = new Vector();
        this.fStackFrames = new Vector();
        this.fProperties = new Properties();
    }

    public String getID() throws CorruptDataException {
        if (this.fImageThreadID == null) {
            throw new CorruptDataException((CorruptData)new JCCorruptData(null));
        }
        return this.fImageThreadID;
    }

    public Properties getProperties() {
        return this.fProperties;
    }

    public void addProperty(Object key, Object value) {
        this.fProperties.put(key, value);
    }

    public Iterator getRegisters() {
        return this.fRegisters.iterator();
    }

    public Iterator getStackSections() {
        return this.fStackSections.iterator();
    }

    public Iterator getStackFrames() throws DataUnavailable {
        if (this.fStackFrames.isEmpty()) {
            throw new DataUnavailable("Native stack frame data not available");
        }
        return this.fStackFrames.iterator();
    }

    public void addImageStackFrame(ImageStackFrame stackFrame) {
        if (stackFrame != null) {
            this.fStackFrames.add(stackFrame);
        }
    }

    public ImagePointer getInternalID() {
        return this.fNativeThreadID;
    }

    public void setSystemThreadID(ImagePointer systemThreadID) {
        this.fSystemThreadID = systemThreadID;
    }

    public ImagePointer getSystemThreadID() {
        return this.fSystemThreadID;
    }
}

