/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Image
implements com.ibm.dtfj.image.Image {
    private String _osType;
    private String _osSubType;
    private String _cpuType;
    private String _cpuSubType;
    private int _cpuCount;
    private long _bytesMem;
    private long _creationTime;
    private Vector _addressSpaces = new Vector();
    private String _hostname;
    private List _ipAddresses = new Vector();

    public Image(String osType, String osSubType, String cpuType, String cpuSubType, int cpuCount, long bytesMem, long creationTime) {
        this._osType = osType;
        this._osSubType = osSubType;
        this._cpuType = cpuType;
        this._cpuSubType = cpuSubType;
        this._cpuCount = cpuCount;
        this._bytesMem = bytesMem;
        this._creationTime = creationTime;
    }

    public Iterator getAddressSpaces() {
        return this._addressSpaces.iterator();
    }

    public String getProcessorType() throws DataUnavailable, CorruptDataException {
        return this._cpuType;
    }

    public String getProcessorSubType() throws DataUnavailable, CorruptDataException {
        if (null == this._cpuSubType) {
            throw new DataUnavailable();
        }
        return this._cpuSubType;
    }

    public int getProcessorCount() throws DataUnavailable {
        if (0 == this._cpuCount) {
            throw new DataUnavailable("Processor count could not be found");
        }
        return this._cpuCount;
    }

    public String getSystemType() throws DataUnavailable, CorruptDataException {
        return this._osType;
    }

    public String getSystemSubType() throws DataUnavailable, CorruptDataException {
        if (null == this._osSubType) {
            throw new DataUnavailable("Operating System did not identify its sub-type");
        }
        return this._osSubType;
    }

    public long getInstalledMemory() throws DataUnavailable {
        if (0L == this._bytesMem) {
            throw new DataUnavailable("Installed memory size not found");
        }
        return this._bytesMem;
    }

    public long getCreationTime() throws DataUnavailable {
        if (0L == this._creationTime) {
            throw new DataUnavailable("Creation time not specified in platform core file");
        }
        return this._creationTime;
    }

    public void addAddressSpace(ImageAddressSpace addressSpace) {
        this._addressSpaces.add(addressSpace);
    }

    public String getHostName() throws DataUnavailable {
        if (null != this._hostname) {
            return this._hostname;
        }
        throw new DataUnavailable();
    }

    public Iterator getIPAddresses() throws DataUnavailable {
        if (this._ipAddresses.size() > 0) {
            return this._ipAddresses.iterator();
        }
        throw new DataUnavailable();
    }

    public void setHostName(String hostname) {
        if (null == this._hostname) {
            if (hostname.length() <= 0) {
                throw new UnsupportedOperationException("hostname cannot be an empty string");
            }
        } else {
            throw new UnsupportedOperationException("hostname cannot be set more than once");
        }
        this._hostname = hostname;
    }

    public void addIPAddress(Object newAddress) {
        this._ipAddresses.add(newAddress);
    }
}

