/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.dom;

import com.ibm.xml.enc.dom.DOMUtils;
import com.ibm.xml.enc.dom.Debug;
import com.ibm.xml.enc.dom.NodeSetDataImpl;
import com.ibm.xml.enc.dom.PrefixResolverImpl;
import com.ibm.xml.enc.dom.TransformContext;
import com.ibm.xml.enc.dom.TransformUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathException;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XPathDOMTransform
extends TransformService {
    private Node node;
    private AlgorithmParameterSpec spec;
    private DocumentBuilder db;
    private XMLCryptoContext xcontext;
    private static Debug debug = Debug.getInstance("xmlenc");
    static /* synthetic */ Class class$com$ibm$xml$enc$dom$TransformContext;

    public void init(TransformParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec == null || !(spec instanceof XPathFilterParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Need an XPathFilterParameterSpec instance");
        }
        this.spec = spec;
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext xcontext) throws MarshalException {
    }

    public void init(XMLStructure parent, XMLCryptoContext xcontext) throws InvalidAlgorithmParameterException {
        XPathFilterParameterSpec spec;
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        if (!(parent instanceof DOMStructure)) {
            throw new InvalidAlgorithmParameterException("This implementation only supports DOMStructure");
        }
        this.node = ((DOMStructure)parent).getNode();
        Element xpathElement = null;
        try {
            Element child = DOMUtils.getFirstChildElement(this.node);
            while (child != null) {
                if (child.getNodeType() != 1) {
                    throw new InvalidAlgorithmParameterException("XPath Filter does not support specified node: " + child.getNodeName());
                }
                if (!"http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI()) || !"XPath".equals(child.getLocalName())) {
                    throw new InvalidAlgorithmParameterException("XPath Filter does not support specified parameter element: " + child.getNodeName());
                }
                if (xpathElement != null) {
                    throw new InvalidAlgorithmParameterException("<ds:XPath> element is already processed.");
                }
                xpathElement = child;
                child = DOMUtils.getNextSiblingElement(child);
            }
            spec = new XPathFilterParameterSpec(TransformUtil.getStringValue(xpathElement), TransformUtil.makePrefixMap(xpathElement));
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
        this.init(spec);
    }

    public Data transform(Data in, XMLCryptoContext xcontext, OutputStream os) throws TransformException {
        return TransformUtil.transform(this, in, xcontext, os);
    }

    public boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException("feature must not be null.");
        }
        return false;
    }

    public Data transform(Data in, XMLCryptoContext xccontext) throws TransformException {
        XPath xpath;
        NodeSetData nodeSet;
        if (debug != null) {
            debug.entry("XPathDOMTransform", "transform");
        }
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            if (in instanceof NodeSetData && debug != null) {
                debug.trace("XPathDOMTransform", "transform", "is node set data");
            }
            nodeSet = this.toNodeSet(in, xccontext);
        }
        catch (Exception ex) {
            throw new TransformException(ex);
        }
        Iterator iter = nodeSet.iterator();
        if (!iter.hasNext()) {
            return new NodeSetDataImpl(iter);
        }
        Node input = (Node)iter.next();
        if (debug != null) {
            debug.trace("XPathDOMTransform", "transform", "input.getLocalname=" + input.getLocalName());
        }
        Document doc = input instanceof Document ? (Document)input : input.getOwnerDocument();
        XPathContext xpathSupport = new XPathContext();
        PrefixResolverImpl prefixResolver = new PrefixResolverImpl(doc.getNodeType() == 9 ? doc.getDocumentElement() : doc);
        XPathFilterParameterSpec xspec = (XPathFilterParameterSpec)this.spec;
        Map<String, String> nsmap = xspec.getNamespaceMap();
        if (nsmap.size() > 0) {
            prefixResolver.setNamespaceMap(nsmap);
        }
        String str = xspec.getXPath();
        LinkedList<Node> output = new LinkedList<Node>();
        try {
            int ctxtNode;
            XObject xobj;
            int len;
            if (debug != null) {
                debug.trace("XPathDOMTransform", "transform", "XPathDOMTransform, expression " + str);
            }
            if ((len = (xobj = (xpath = new XPath(str, null, (PrefixResolver)prefixResolver, 0, null)).execute(xpathSupport, ctxtNode = xpathSupport.getDTMHandleFromNode((Node)doc), (PrefixResolver)prefixResolver)).nodelist().getLength()) > 0) {
                if (debug != null) {
                    debug.trace("XPathDOMTransform", "transform", "get a node " + xobj.nodelist().item(0).getLocalName());
                }
                for (int i = 0; i < len; ++i) {
                    output.add(xobj.nodelist().item(i));
                }
            }
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.trace("XPathDOMTransform", "transform", ex);
            }
            throw new TransformException(ex);
        }
        Element hereNode = DOMUtils.getFirstChildElement(this.node);
        if (debug != null) {
            debug.trace("XPathDOMTransform", "transform", "this.node=" + this.node.getLocalName());
        }
        if (output.isEmpty()) {
            while (iter.hasNext()) {
                Node child = (Node)iter.next();
                if (debug != null) {
                    debug.trace("XPathDOMTransform", "transform", "child " + child);
                }
                int ctxtNode = xpathSupport.getDTMHandleFromNode(child);
                try {
                    XObject xobj = xpath.execute(xpathSupport, ctxtNode, (PrefixResolver)prefixResolver);
                    int len = xobj.nodelist().getLength();
                    if (len <= 0) continue;
                    if (debug != null) {
                        debug.trace("XPathDOMTransform", "transform", "get a node at second time " + xobj.nodelist().item(0).getLocalName());
                    }
                    for (int i = 0; i < len; ++i) {
                        output.add(xobj.nodelist().item(i));
                    }
                }
                catch (XPathException ex2) {
                    if (debug != null) {
                        debug.trace("XPathDOMTransform", "transform", ex2);
                    }
                    throw new TransformException(ex2);
                }
                catch (Exception ex3) {
                    if (debug != null) {
                        debug.trace("XPathDOMTransform", "transform", ex3);
                    }
                    throw new TransformException(ex3);
                }
            }
        }
        return new NodeSetDataImpl(new TransformUtil.ListIterator(output));
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    protected NodeSetData toNodeSet(Data in, XMLCryptoContext xcontext) throws ParserConfigurationException, SAXException, IOException, URIReferenceException {
        Document doc;
        TransformContext tcontext = null;
        if (in instanceof NodeSetData) {
            return (NodeSetData)in;
        }
        if (!(in instanceof OctetStreamData)) {
            throw new RuntimeException("Internal Error: Unknown Data: " + in.getClass().getName());
        }
        OctetStreamData osd = (OctetStreamData)in;
        if (xcontext != null) {
            tcontext = (TransformContext)xcontext.get(class$com$ibm$xml$enc$dom$TransformContext == null ? (class$com$ibm$xml$enc$dom$TransformContext = XPathDOMTransform.class$("com.ibm.xml.enc.dom.TransformContext")) : class$com$ibm$xml$enc$dom$TransformContext);
        }
        if (tcontext != null) {
            doc = this.parse(osd.getOctetStream());
            tcontext.mightFixTree(doc);
        } else {
            doc = this.parse(osd.getOctetStream());
            TransformUtil.fixTree(doc);
        }
        return TransformUtil.toNodeSet(doc, true);
    }

    private Document parse(InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = this.getDocumentBuilder();
        Document doc = builder.parse(stream);
        return doc;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.db == null) {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            fac.setExpandEntityReferences(true);
            this.db = fac.newDocumentBuilder();
        }
        return this.db;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

