/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idl;

import com.ibm.idl.AttributeEntry;
import com.ibm.idl.ConstEntry;
import com.ibm.idl.EnumEntry;
import com.ibm.idl.ExceptionEntry;
import com.ibm.idl.InterfaceEntry;
import com.ibm.idl.MethodEntry;
import com.ibm.idl.ModuleEntry;
import com.ibm.idl.ParameterEntry;
import com.ibm.idl.PrimitiveEntry;
import com.ibm.idl.RepositoryID;
import com.ibm.idl.SequenceEntry;
import com.ibm.idl.StringEntry;
import com.ibm.idl.StructEntry;
import com.ibm.idl.SymtabEntry;
import com.ibm.idl.TypedefEntry;
import com.ibm.idl.UnionEntry;
import com.ibm.som.cff.FileLocator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Util {
    private static boolean verbose = false;
    private static final String IDL_PROPERTIES_FILE = "com/ibm/idl/idl.properties";
    private static int numErrors = 0;
    private static Properties messages = null;
    private static String defaultKey = "default";
    private static Vector msgFiles = new Vector();
    static RepositoryID emptyID;

    public static void setVerbose(boolean bl) {
        verbose = bl;
    }

    public static int errorExitCode() {
        return 2;
    }

    public static boolean errorsOccurred() {
        return numErrors > 0;
    }

    private static void checkError(String string) {
        if (string.equals("Version.product")) {
            return;
        }
        if (string.equals("Version.number")) {
            return;
        }
        if (string.equals("Compile.parsing")) {
            return;
        }
        if (string.equals("Compile.parseDone")) {
            return;
        }
        if (string.equals("Compile.generating")) {
            return;
        }
        if (string.equals("Compile.genDone")) {
            return;
        }
        if (string.equals("usage")) {
            return;
        }
        if (string.startsWith("ParseException.info")) {
            return;
        }
        if (string.equals("Deprecated.keyword")) {
            return;
        }
        if (string.equals("Migration.futureKeyword")) {
            return;
        }
        if (string.equals("Migration.keywordCollision")) {
            return;
        }
        if (string.equals("ParseException.warning")) {
            return;
        }
        if (string.equals("Preprocessor.unknown")) {
            return;
        }
        if (string.equals("Preprocessor.unknownPragma")) {
            return;
        }
        if (string.equals("Preprocessor.undefinedName")) {
            return;
        }
        if (string.startsWith("Token.")) {
            return;
        }
        if (string.equals("toJavaProlog1")) {
            return;
        }
        if (string.equals("toJavaProlog2")) {
            return;
        }
        ++numErrors;
    }

    public static String getVersion() {
        return Util.getVersion(IDL_PROPERTIES_FILE);
    }

    public static String getVersion(String string) {
        String string2 = "";
        if (messages == null) {
            Vector vector = msgFiles;
            if (string == null || string.equals("")) {
                string = IDL_PROPERTIES_FILE;
            }
            string = string.replace('/', File.separatorChar);
            Util.registerMessageFile(string);
            string2 = Util.getMessage("Version.product", Util.getMessage("Version.number"));
            msgFiles = vector;
            messages = null;
        } else {
            string2 = Util.getMessage("Version.product", Util.getMessage("Version.number"));
        }
        return string2;
    }

    public static boolean isAttribute(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof AttributeEntry;
    }

    public static boolean isConst(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof ConstEntry;
    }

    public static boolean isEnum(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof EnumEntry;
    }

    public static boolean isException(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof ExceptionEntry;
    }

    public static boolean isInterface(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof InterfaceEntry;
    }

    public static boolean isMethod(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof MethodEntry;
    }

    public static boolean isModule(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof ModuleEntry;
    }

    public static boolean isParameter(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof ParameterEntry;
    }

    public static boolean isPrimitive(String string, Hashtable hashtable) {
        int n;
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        if (symtabEntry == null && (n = string.indexOf(40)) >= 0) {
            symtabEntry = (SymtabEntry)hashtable.get(string.substring(0, n));
        }
        return symtabEntry == null ? false : symtabEntry instanceof PrimitiveEntry;
    }

    public static boolean isSequence(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof SequenceEntry;
    }

    public static boolean isStruct(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof StructEntry;
    }

    public static boolean isString(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof StringEntry;
    }

    public static boolean isTypedef(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof TypedefEntry;
    }

    public static boolean isUnion(String string, Hashtable hashtable) {
        SymtabEntry symtabEntry = (SymtabEntry)hashtable.get(string);
        return symtabEntry == null ? false : symtabEntry instanceof UnionEntry;
    }

    public static String getMessage(String string) {
        String string2;
        Util.checkError(string);
        if (messages == null) {
            Util.readMessages();
        }
        if ((string2 = messages.getProperty(string)) == null) {
            string2 = Util.getDefaultMessage(string);
        }
        return string2;
    }

    public static String getMessage(String string, String string2) {
        String string3;
        Util.checkError(string);
        if (messages == null) {
            Util.readMessages();
        }
        if ((string3 = messages.getProperty(string)) == null) {
            string3 = Util.getDefaultMessage(string);
        } else {
            int n = string3.indexOf("%0");
            if (n >= 0) {
                string3 = string3.substring(0, n) + string2 + string3.substring(n + 2);
            }
        }
        return string3;
    }

    public static String getMessage(String string, String[] stringArray) {
        String string2;
        Util.checkError(string);
        if (messages == null) {
            Util.readMessages();
        }
        if ((string2 = messages.getProperty(string)) == null) {
            string2 = Util.getDefaultMessage(string);
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = string2.indexOf("%" + i);
                if (n < 0) continue;
                string2 = string2.substring(0, n) + stringArray[i] + string2.substring(n + 2);
            }
        }
        return string2;
    }

    private static String getDefaultMessage(String string) {
        String string2 = messages.getProperty(defaultKey);
        ++numErrors;
        if (string2 == null) {
            return "ERROR: Unable to get default message from property object.";
        }
        int n = string2.indexOf("%0");
        if (n > 0) {
            string2 = string2.substring(0, n) + string;
        }
        return string2;
    }

    private static void readMessages() {
        messages = new Properties();
        Enumeration enumeration = msgFiles.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                InputStream inputStream = FileLocator.getLocaleSpecificFileFromClassLoader(string, verbose);
                if (inputStream == null) continue;
                messages.load(inputStream);
            }
            catch (IOException iOException) {}
        }
        if (messages.size() == 0) {
            messages.put(defaultKey, "Error reading Messages File.");
        }
    }

    public static void registerMessageFile(String string) {
        if (string != null) {
            if (messages == null) {
                msgFiles.addElement(string);
            } else {
                try {
                    InputStream inputStream = FileLocator.getLocaleSpecificFileFromClassLoader(string, verbose);
                    if (inputStream != null) {
                        messages.load(inputStream);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static String capitalize(String string) {
        String string2 = new String(string.substring(0, 1));
        string2 = string2.toUpperCase();
        return string2 + string.substring(1);
    }

    public static String getAbsolutePath(String string, Vector vector) throws FileNotFoundException {
        String string2 = null;
        File file = new File(string);
        if (file.canRead()) {
            string2 = file.getAbsolutePath();
        } else {
            String string3 = null;
            Enumeration enumeration = vector.elements();
            while (!file.canRead() && enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement() + File.separatorChar + string;
                file = new File(string3);
            }
            if (file.canRead()) {
                string2 = file.getPath();
            } else {
                throw new FileNotFoundException(string);
            }
        }
        return string2;
    }

    public static float absDelta(float f, float f2) {
        double d = f - f2;
        return (float)(d < 0.0 ? d * -1.0 : d);
    }

    static {
        msgFiles.addElement(IDL_PROPERTIES_FILE);
        emptyID = new RepositoryID();
    }
}

