/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

public class SBCS_Encoder
extends CharsetEncoder {
    private final short[] index;
    private final char[] charToByteTable_charr;
    private final byte[] byteMap;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private static boolean UseBuffer = false;
    protected static boolean swapAllowed = false;
    protected static int offset;
    private static String swapValue;
    private int charOff;
    private int byteOff;
    private static final int NOOUTPUT = 256;
    protected ByteBuffer trtoXlateTable = null;
    private final int kMinStringSize = 25;
    static final byte kSentinalValue = 0;
    protected boolean subMode = true;
    protected byte[] subBytes;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private final int[] mask1All = new int[]{65535, 65534, 65532, 65528, 65520, 65504, 65472, 65408, 65280};
    private final int[] mask2All = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    protected SBCS_Encoder(Charset charset, short[] sArray, String string, byte[] byArray, int n, byte[] byArray2) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.charToByteTable_charr = this.handleIBMSwapLF(string).toCharArray();
        this.byteMap = byArray;
        this.mask1 = this.mask1All[n];
        this.mask2 = this.mask2All[n];
        this.shift = n;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
        this.subBytes = byArray2;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public static byte[] expandByteMap(short[] sArray, String string, int n, int n2) {
        if (n < 5 || n > 8) {
            return null;
        }
        int n3 = 1 << n;
        int n4 = 65536 / n3;
        byte[] byArray = new byte[65536];
        for (int i = 0; i < n4; ++i) {
            int n5 = i * n3;
            if (sArray[i] == n2) continue;
            for (int j = 0; j < n3; ++j) {
                byArray[n5++] = (byte)string.charAt(sArray[i] + j);
            }
        }
        return byArray;
    }

    private String handleIBMSwapLF(String string) {
        if (swapAllowed && Boolean.parseBoolean(swapValue = System.getSecurityManager() == null ? new GetPropertyAction("ibm.swapLF").run() : AccessController.doPrivileged(new GetPropertyAction("ibm.swapLF")))) {
            char[] cArray = string.toCharArray();
            cArray[SBCS_Encoder.offset] = 37;
            return new String(cArray);
        }
        return string;
    }

    protected SBCS_Encoder(Charset charset, short[] sArray, String string, int n, int n2, int n3) {
        this(charset, sArray, string, null, n3, null);
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private int JITintrinsicConvert(ByteBuffer byteBuffer, char[] cArray, int n, byte[] byArray) {
        int n2;
        int n3 = this.byteOff;
        int n4 = this.charOff;
        for (n2 = 0; n2 < n - n4; ++n2) {
            byte by = byteBuffer.get(cArray[n2 + n4]);
            if (by == 0) {
                return 0;
            }
            byArray[n2 + n3] = by;
        }
        this.byteOff += n2;
        this.charOff += n2;
        return n2;
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    public boolean canEncode(char c) {
        if (this.byteMap != null) {
            byte by = this.byteMap[c];
            return by != 0 || c == '\u0000';
        }
        char c2 = this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
        return c2 != '\u0000' || c == '\u0000';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        int n5 = 256;
        this.charOff = n;
        this.byteOff = n3;
        CoderResult coderResult = CoderResult.UNDERFLOW;
        try {
            Object object;
            int n6;
            boolean bl;
            int n7;
            int n8;
            block31: {
                char c;
                byte by;
                int n9;
                block33: {
                    byte by2;
                    block32: {
                        block30: {
                            n8 = n;
                            n7 = n3;
                            int n10 = n2 - n8;
                            int n11 = n4 - n7;
                            boolean bl2 = true;
                            bl = false;
                            if (n11 < n10) {
                                n10 = n11;
                                bl = true;
                            }
                            n6 = n7 + n10;
                            if (this.byteMap == null) break block30;
                            if (null != this.trtoXlateTable && n10 > 25) {
                                object = this.trtoXlateTable;
                                if (0 != this.JITintrinsicConvert((ByteBuffer)object, cArray, n8 + n10, byArray)) {
                                    bl2 = false;
                                    n8 += this.byteOff - n7;
                                    n7 = this.byteOff;
                                } else if (n7 != this.byteOff) {
                                    bl2 = false;
                                    this.byteOff = n7;
                                    this.charOff = n8;
                                }
                            }
                            if (!bl2) break block31;
                            break block32;
                        }
                        n9 = this.mask2;
                        break block33;
                    }
                    while (n7 < n6 && (by2 = this.byteMap[cArray[n8]]) != 0) {
                        ++n8;
                        byArray[n7++] = by2;
                    }
                    this.byteOff = n7;
                    this.charOff = n8;
                    break block31;
                }
                while (n7 < n6 && (by = (byte)this.charToByteTable_charr[this.index[(c = cArray[n8]) >> this.shift] + (c & n9)]) != 0) {
                    ++n8;
                    byArray[n7++] = by;
                }
            }
            this.byteOff = n7;
            this.charOff = n8;
            if (n7 == n6 && bl) {
                object = CoderResult.OVERFLOW;
                return object;
            }
            while (this.charOff < n2) {
                int n12;
                block29: {
                    char c = cArray[this.charOff];
                    n12 = 1;
                    if ((c & 0xF800) == 55296) {
                        if (c <= '\udfff') {
                            if (this.charOff + 1 >= n2) break;
                            c = cArray[this.charOff + 1];
                            if (c >= '\udc00' && c <= '\udfff') {
                                if (!this.subMode) {
                                    object = CoderResult.unmappableForLength(1);
                                    return object;
                                }
                                n5 = this.subBytes.length > 0 ? this.subBytes[0] : 256;
                                n12 = 2;
                                break block29;
                            } else {
                                object = this.sgp.unmappableResult();
                                return object;
                            }
                        }
                        if (c <= '\udfff') {
                            object = this.sgp.unmappableResult();
                            return object;
                        }
                    } else {
                        n5 = (byte)(this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)]);
                        byte by = (byte)n5;
                        if (n5 == 0 && cArray[this.charOff] != '\u0000') {
                            if (!this.subMode) {
                                object = CoderResult.unmappableForLength(1);
                                return object;
                            }
                            int n13 = n5 = this.subBytes.length > 0 ? this.subBytes[0] : 256;
                        }
                    }
                }
                if (this.byteOff >= n4) {
                    object = CoderResult.OVERFLOW;
                    return object;
                }
                if (n5 != 256) {
                    byArray[this.byteOff++] = (byte)n5;
                }
                this.charOff += n12;
            }
            object = CoderResult.UNDERFLOW;
            return object;
        }
        finally {
            charBuffer.position(this.charOff - charBuffer.arrayOffset());
            byteBuffer.position(this.byteOff - byteBuffer.arrayOffset());
        }
    }

    public void implReset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                byte by;
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                byte by2 = by = this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
                if (by == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                byteBuffer.put(by);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.toString())) {
            int n;
            int n2;
            int n3;
            int n4 = charBuffer.remaining();
            if (n4 > byteBuffer.remaining()) {
                n4 = byteBuffer.remaining();
            }
            if (charBuffer.hasArray() && !UseBuffer) {
                char[] cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + charBuffer.position();
                n2 = n3 + n4;
                char c = cArray[n3];
                byte by = this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
                boolean bl = by == 0 && c != '\u0000';
                for (n = n3 + 1; n < n2; ++n) {
                    c = cArray[n];
                    by = this.byteMap != null ? this.byteMap[c] : (byte)this.charToByteTable_charr[this.index[c >> this.shift] + (c & this.mask2)];
                    if ((by == 0 && c != '\u0000') != bl) break;
                }
                n4 = n - n3;
            } else {
                int n5 = charBuffer.position();
                n2 = n4;
                n = charBuffer.get();
                byte by = this.byteMap != null ? this.byteMap[n] : (byte)this.charToByteTable_charr[this.index[n >> this.shift] + (n & this.mask2)];
                boolean bl = by == 0 && n != 0;
                for (n3 = 1; n3 < n2; ++n3) {
                    n = charBuffer.get();
                    by = this.byteMap != null ? this.byteMap[n] : (byte)this.charToByteTable_charr[this.index[n >> this.shift] + (n & this.mask2)];
                    if ((by == 0 && n != 0) != bl) break;
                }
                charBuffer.position(n5);
                n4 = n3;
            }
            int n6 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n4);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.toString());
            charBuffer.limit(n6);
            n2 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n2 = charBuffer.position() + charBuffer2.position() - n2;
            charBuffer.position(n2);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }

    static {
        try {
            String string = System.getProperty("java.nio.usebuffer");
            if (string != null && string.length() > 0 && string.charAt(0) == '1') {
                UseBuffer = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

