/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.DoubleByteDecoder;
import sun.nio.cs.ext.DoubleByteEncoder;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class ISO2022_JP
extends Charset
implements HistoricallyNamedCharset {
    private static final int ASCII = 0;
    private static final int JISX0201_1976 = 1;
    private static final int JISX0208_1978 = 2;
    private static final int JISX0208_1983 = 3;
    private static final int JISX0212_1990 = 4;
    private static final int JISX0201_1976_KANA = 5;
    private static final int SHIFTOUT = 6;
    private static final int ESC = 27;
    private static final int SO = 14;
    private static final int SI = 15;

    public ISO2022_JP() {
        super("ISO-2022-JP", ExtendedCharsets.aliasesFor("ISO-2022-JP"));
    }

    protected ISO2022_JP(String string, String[] stringArray) {
        super(string, stringArray);
    }

    public String historicalName() {
        return "ISO2022JP";
    }

    public boolean contains(Charset charset) {
        return charset instanceof JIS_X_0201 || charset instanceof US_ASCII || charset instanceof JIS_X_0208 || charset instanceof ISO2022_JP;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.getDecIndex1(), this.getDecIndex2(), this.get0212Decoder());
    }

    public CharsetEncoder newEncoder() {
        return new Encoder((Charset)this, this.getEncIndex1(), this.getEncIndex2(), this.get0212Encoder(), this.doSBKANA());
    }

    protected short[] getDecIndex1() {
        return JIS_X_0208_Decoder.getIndex1();
    }

    protected String[] getDecIndex2() {
        return JIS_X_0208_Decoder.getIndex2();
    }

    protected DoubleByteDecoder get0212Decoder() {
        return null;
    }

    protected short[] getEncIndex1() {
        return JIS_X_0208_Encoder.getIndex1();
    }

    protected String[] getEncIndex2() {
        return JIS_X_0208_Encoder.getIndex2();
    }

    protected DoubleByteEncoder get0212Encoder() {
        return null;
    }

    protected boolean doSBKANA() {
        return true;
    }

    private static class Encoder
    extends DoubleByteEncoder {
        private static byte[] repl = new byte[]{33, 41};
        private int currentMode = 0;
        private int replaceMode = 3;
        private DoubleByteEncoder encoder0212 = null;
        private boolean doSBKANA;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset, short[] sArray, String[] stringArray, DoubleByteEncoder doubleByteEncoder, boolean bl) {
            super(charset, sArray, stringArray, repl, 4.0f, doubleByteEncoder != null ? 9.0f : 8.0f);
            this.encoder0212 = doubleByteEncoder;
            this.doSBKANA = bl;
        }

        protected int encodeSingle(char c) {
            return -1;
        }

        protected void implReset() {
            this.currentMode = 0;
        }

        protected void implReplaceWith(byte[] byArray) {
            if (byArray.length == 1) {
                this.replaceMode = 0;
            } else if (byArray.length == 2) {
                this.replaceMode = 3;
            }
        }

        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.currentMode != 0) {
                if (byteBuffer.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)27);
                byteBuffer.put((byte)40);
                byteBuffer.put((byte)66);
                this.currentMode = 0;
            }
            return CoderResult.UNDERFLOW;
        }

        public boolean canEncode(char c) {
            return c <= '\u007f' || c >= '\uff61' && c <= '\uff9f' || c == '\u00a5' || c == '\u203e' || super.canEncode(c) || this.encoder0212 != null && this.encoder0212.canEncode(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            boolean bl = false;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    int n5 = this.currentMode;
                    char c = cArray[n];
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 66;
                            byArray[n3++] = (byte)c;
                            n5 = 0;
                        } else {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)c;
                        }
                    } else if (c >= '\uff61' && c <= '\uff9f' && this.doSBKANA) {
                        if (this.currentMode != 5) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 73;
                            byArray[n3++] = (byte)(c - 65344);
                            n5 = 5;
                        } else {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = (byte)(c - 65344);
                        }
                    } else if (c == '\u00a5') {
                        if (this.currentMode != 1) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 74;
                            byArray[n3++] = 92;
                            n5 = 1;
                        } else {
                            byArray[n3++] = 92;
                        }
                    } else if (c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 74;
                            byArray[n3++] = 126;
                            n5 = 1;
                        } else {
                            if (n4 - n3 < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 126;
                        }
                    } else {
                        int n6 = this.encodeDouble(c);
                        if (n6 != 0) {
                            if (this.currentMode != 3) {
                                if (n4 - n3 < 5) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byArray[n3++] = 27;
                                byArray[n3++] = 36;
                                byArray[n3++] = 66;
                                byArray[n3++] = (byte)(n6 >> 8);
                                byArray[n3++] = (byte)(n6 & 0xFF);
                                n5 = 3;
                            } else {
                                if (n4 - n3 < 2) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byArray[n3++] = (byte)(n6 >> 8);
                                byArray[n3++] = (byte)(n6 & 0xFF);
                            }
                        } else if (this.encoder0212 != null && (n6 = this.encoder0212.encodeDouble(c)) != 0) {
                            if (this.currentMode != 4) {
                                if (n4 - n3 < 6) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byArray[n3++] = 27;
                                byArray[n3++] = 36;
                                byArray[n3++] = 40;
                                byArray[n3++] = 68;
                                byArray[n3++] = (byte)(n6 >> 8);
                                byArray[n3++] = (byte)(n6 & 0xFF);
                                n5 = 4;
                            } else {
                                if (n4 - n3 < 2) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byArray[n3++] = (byte)(n6 >> 8);
                                byArray[n3++] = (byte)(n6 & 0xFF);
                            }
                        } else {
                            if (Surrogate.is(c) && this.sgp.parse(c, cArray, n, n2) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (this.unmappableCharacterAction() == CodingErrorAction.REPLACE && this.currentMode != this.replaceMode) {
                                if (n4 - n3 < 3) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                if (this.replaceMode == 0) {
                                    byArray[n3++] = 27;
                                    byArray[n3++] = 40;
                                    byArray[n3++] = 66;
                                } else {
                                    byArray[n3++] = 27;
                                    byArray[n3++] = 36;
                                    byArray[n3++] = 66;
                                }
                                this.currentMode = this.replaceMode;
                            }
                            if (Surrogate.is(c)) {
                                CoderResult coderResult = this.sgp.unmappableResult();
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    this.currentMode = n5;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2 = this.currentMode;
                    char c = charBuffer.get();
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)66);
                            byteBuffer.put((byte)c);
                            n2 = 0;
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)c);
                        }
                    } else if (c >= '\uff61' && c <= '\uff9f' && this.doSBKANA) {
                        if (this.currentMode != 5) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)73);
                            byteBuffer.put((byte)(c - 65344));
                            n2 = 5;
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(c - 65344));
                        }
                    } else if (c == '\u00a5') {
                        if (this.currentMode != 1) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)74);
                            byteBuffer.put((byte)92);
                            n2 = 1;
                        } else {
                            byteBuffer.put((byte)92);
                        }
                    } else if (c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)74);
                            byteBuffer.put((byte)126);
                            n2 = 1;
                        } else {
                            if (byteBuffer.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)126);
                        }
                    } else {
                        int n3 = this.encodeDouble(c);
                        if (n3 != 0) {
                            if (this.currentMode != 3) {
                                if (byteBuffer.remaining() < 5) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byteBuffer.put((byte)27);
                                byteBuffer.put((byte)36);
                                byteBuffer.put((byte)66);
                                byteBuffer.put((byte)(n3 >> 8));
                                byteBuffer.put((byte)(n3 & 0xFF));
                                n2 = 3;
                            } else {
                                if (byteBuffer.remaining() < 2) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byteBuffer.put((byte)(n3 >> 8));
                                byteBuffer.put((byte)(n3 & 0xFF));
                            }
                        } else if (this.encoder0212 != null && (n3 = this.encoder0212.encodeDouble(c)) != 0) {
                            if (this.currentMode != 4) {
                                if (byteBuffer.remaining() < 6) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byteBuffer.put((byte)27);
                                byteBuffer.put((byte)36);
                                byteBuffer.put((byte)40);
                                byteBuffer.put((byte)68);
                                byteBuffer.put((byte)(n3 >> 8));
                                byteBuffer.put((byte)(n3 & 0xFF));
                                n2 = 4;
                            } else {
                                if (byteBuffer.remaining() < 2) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byteBuffer.put((byte)(n3 >> 8));
                                byteBuffer.put((byte)(n3 & 0xFF));
                            }
                        } else {
                            if (Surrogate.is(c) && this.sgp.parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (this.unmappableCharacterAction() == CodingErrorAction.REPLACE && this.currentMode != this.replaceMode) {
                                if (byteBuffer.remaining() < 3) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                if (this.replaceMode == 0) {
                                    byteBuffer.put((byte)27);
                                    byteBuffer.put((byte)40);
                                    byteBuffer.put((byte)66);
                                } else {
                                    byteBuffer.put((byte)27);
                                    byteBuffer.put((byte)36);
                                    byteBuffer.put((byte)66);
                                }
                                this.currentMode = this.replaceMode;
                            }
                            if (Surrogate.is(c)) {
                                CoderResult coderResult = this.sgp.unmappableResult();
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++n;
                    this.currentMode = n2;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    private static class Decoder
    extends DoubleByteDecoder
    implements DelegatableDecoder {
        private int currentState;
        private int previousState;
        private DoubleByteDecoder decoder0212;

        protected Decoder(Charset charset, short[] sArray, String[] stringArray, DoubleByteDecoder doubleByteDecoder) {
            super(charset, sArray, stringArray, 33, 126);
            this.decoder0212 = doubleByteDecoder;
            this.currentState = 0;
            this.previousState = 0;
        }

        protected char convSingleByte(int n) {
            return '\ufffd';
        }

        public void implReset() {
            this.currentState = 0;
            this.previousState = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            byte[] byArray = byteBuffer.array();
            int n6 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n7 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n6 <= n7);
            n6 = n6 <= n7 ? n6 : n7;
            char[] cArray = charBuffer.array();
            int n8 = charBuffer.arrayOffset() + charBuffer.position();
            int n9 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n8 <= n9);
            n8 = n8 <= n9 ? n8 : n9;
            try {
                while (n6 < n7) {
                    block50: {
                        block49: {
                            block51: {
                                block53: {
                                    block52: {
                                        n2 = byArray[n6] & 0xFF;
                                        n = 1;
                                        if ((n2 & 0x80) != 0) {
                                            CoderResult coderResult = CoderResult.malformedForLength(n);
                                            return coderResult;
                                        }
                                        if (n2 != 27 && n2 != 14 && n2 != 15) break block50;
                                        if (n2 != 27) break block51;
                                        if (n6 + n + 2 > n7) {
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        if ((n3 = byArray[n6 + n++] & 0xFF) != 40) break block52;
                                        if ((n4 = byArray[n6 + n++] & 0xFF) == 66) {
                                            this.currentState = 0;
                                            break block49;
                                        } else if (n4 == 74) {
                                            this.currentState = 1;
                                            break block49;
                                        } else {
                                            if (n4 != 73) {
                                                CoderResult coderResult = CoderResult.malformedForLength(n);
                                                return coderResult;
                                            }
                                            this.currentState = 5;
                                        }
                                        break block49;
                                    }
                                    if (n3 != 36) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n);
                                        return coderResult;
                                    }
                                    if ((n4 = byArray[n6 + n++] & 0xFF) != 64) break block53;
                                    this.currentState = 2;
                                    break block49;
                                }
                                if (n4 == 66) {
                                    this.currentState = 3;
                                    break block49;
                                } else if (n4 == 40 && this.decoder0212 != null) {
                                    if (n6 + n + 1 > n7) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    if ((n5 = byArray[n6 + n++] & 0xFF) != 68) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n);
                                        return coderResult;
                                    }
                                    this.currentState = 4;
                                    break block49;
                                } else {
                                    CoderResult coderResult = CoderResult.malformedForLength(n);
                                    return coderResult;
                                }
                            }
                            if (n2 == 14) {
                                this.previousState = this.currentState;
                                this.currentState = 6;
                            } else if (n2 == 15) {
                                this.currentState = this.previousState;
                            }
                        }
                        n6 += n;
                        continue;
                    }
                    if (n8 + 1 > n9) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    block12 : switch (this.currentState) {
                        case 0: {
                            cArray[n8++] = (char)(n2 & 0xFF);
                            break;
                        }
                        case 1: {
                            switch (n2) {
                                case 92: {
                                    cArray[n8++] = 165;
                                    break block12;
                                }
                                case 126: {
                                    cArray[n8++] = 8254;
                                    break block12;
                                }
                            }
                            cArray[n8++] = (char)n2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (n6 + n + 1 > n7) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n3 = byArray[n6 + n++] & 0xFF;
                            cArray[n8++] = this.decodeDouble(n2, n3);
                            break;
                        }
                        case 4: {
                            if (n6 + n + 1 > n7) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n3 = byArray[n6 + n++] & 0xFF;
                            cArray[n8++] = this.decoder0212.decodeDouble(n2, n3);
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (n2 > 96) {
                                CoderResult coderResult = CoderResult.malformedForLength(n);
                                return coderResult;
                            }
                            cArray[n8++] = (char)(n2 + 65344);
                            break;
                        }
                    }
                    n6 += n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n6 - byteBuffer.arrayOffset());
                charBuffer.position(n8 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            try {
                while (byteBuffer.hasRemaining()) {
                    block48: {
                        block47: {
                            block49: {
                                block51: {
                                    block50: {
                                        n2 = byteBuffer.get() & 0xFF;
                                        n6 = 1;
                                        if ((n2 & 0x80) != 0) {
                                            CoderResult coderResult = CoderResult.malformedForLength(n6);
                                            return coderResult;
                                        }
                                        if (n2 != 27 && n2 != 14 && n2 != 15) break block48;
                                        if (n2 != 27) break block49;
                                        if (byteBuffer.remaining() < 2) {
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        n3 = byteBuffer.get() & 0xFF;
                                        ++n6;
                                        if (n3 != 40) break block50;
                                        n4 = byteBuffer.get() & 0xFF;
                                        ++n6;
                                        if (n4 == 66) {
                                            this.currentState = 0;
                                            break block47;
                                        } else if (n4 == 74) {
                                            this.currentState = 1;
                                            break block47;
                                        } else {
                                            if (n4 != 73) {
                                                CoderResult coderResult = CoderResult.malformedForLength(n6);
                                                return coderResult;
                                            }
                                            this.currentState = 5;
                                        }
                                        break block47;
                                    }
                                    if (n3 != 36) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n6);
                                        return coderResult;
                                    }
                                    n4 = byteBuffer.get() & 0xFF;
                                    ++n6;
                                    if (n4 != 64) break block51;
                                    this.currentState = 2;
                                    break block47;
                                }
                                if (n4 == 66) {
                                    this.currentState = 3;
                                    break block47;
                                } else if (n4 == 40 && this.decoder0212 != null) {
                                    if (!byteBuffer.hasRemaining()) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n5 = byteBuffer.get() & 0xFF;
                                    ++n6;
                                    if (n5 != 68) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n6);
                                        return coderResult;
                                    }
                                    this.currentState = 4;
                                    break block47;
                                } else {
                                    CoderResult coderResult = CoderResult.malformedForLength(n6);
                                    return coderResult;
                                }
                            }
                            if (n2 == 14) {
                                this.previousState = this.currentState;
                                this.currentState = 6;
                            } else if (n2 == 15) {
                                this.currentState = this.previousState;
                            }
                        }
                        n += n6;
                        continue;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    block12 : switch (this.currentState) {
                        case 0: {
                            charBuffer.put((char)(n2 & 0xFF));
                            break;
                        }
                        case 1: {
                            switch (n2) {
                                case 92: {
                                    charBuffer.put('\u00a5');
                                    break block12;
                                }
                                case 126: {
                                    charBuffer.put('\u203e');
                                    break block12;
                                }
                            }
                            charBuffer.put((char)n2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (!byteBuffer.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n3 = byteBuffer.get() & 0xFF;
                            ++n6;
                            charBuffer.put(this.decodeDouble(n2, n3));
                            break;
                        }
                        case 4: {
                            if (!byteBuffer.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n3 = byteBuffer.get() & 0xFF;
                            ++n6;
                            charBuffer.put(this.decoder0212.decodeDouble(n2, n3));
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (n2 > 96) {
                                CoderResult coderResult = CoderResult.malformedForLength(n6);
                                return coderResult;
                            }
                            charBuffer.put((char)(n2 + 65344));
                            break;
                        }
                    }
                    n += n6;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }
    }
}

