/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.HostAddresses;
import com.ibm.security.krb5.KDCOptions;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.KerberosTime;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCReqBody {
    private KDCOptions b;
    private PrincipalName c;
    private Realm d;
    private PrincipalName e;
    private KerberosTime f;
    private KerberosTime g;
    private KerberosTime h;
    private int i;
    private int[] j;
    private HostAddresses k;
    private EncryptedData l;
    private Ticket[] m;

    public KDCReqBody(KDCOptions kDCOptions, PrincipalName principalName, Realm realm, PrincipalName principalName2, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, int n2, int[] nArray, HostAddresses hostAddresses, EncryptedData encryptedData, Ticket[] ticketArray) throws IOException {
        this.b = kDCOptions;
        this.c = principalName;
        this.d = realm;
        this.e = principalName2;
        this.f = kerberosTime;
        this.g = kerberosTime2;
        this.h = kerberosTime3;
        this.i = n2;
        if (nArray != null) {
            this.j = (int[])nArray.clone();
        }
        this.k = hostAddresses;
        this.l = encryptedData;
        this.m = ticketArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public KDCReqBody(DerValue derValue, int n2) throws Asn1Exception, RealmException, KrbException, IOException {
        this.k = null;
        this.l = null;
        this.m = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.b = KDCOptions.parse(derValue.getData(), (byte)0, false);
        this.c = PrincipalName.parse(derValue.getData(), (byte)1, true);
        if (n2 != 10 && this.c != null) {
            throw new Asn1Exception(906);
        }
        this.d = Realm.parse(derValue.getData(), (byte)2, false);
        this.e = PrincipalName.parse(derValue.getData(), (byte)3, true);
        this.f = KerberosTime.parse(derValue.getData(), (byte)4, true);
        this.g = KerberosTime.parse(derValue.getData(), (byte)5, false);
        this.h = KerberosTime.parse(derValue.getData(), (byte)6, true);
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 7) {
            throw new Asn1Exception(906);
        }
        this.i = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        Vector<Integer> vector = new Vector<Integer>();
        if ((derValue2.getTag() & 0x1F) != 8) throw new Asn1Exception(906);
        DerValue derValue3 = derValue2.getData().getDerValue();
        if (derValue3.getTag() != 48) throw new Asn1Exception(906);
        while (derValue3.getData().available() > 0) {
            vector.addElement(new Integer(derValue3.getData().getBigInteger().intValue()));
        }
        this.j = new int[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            this.j[i2] = (Integer)vector.elementAt(i2);
        }
        if (derValue.getData().available() > 0) {
            this.k = HostAddresses.parse(derValue.getData(), (byte)9, true);
        }
        if (derValue.getData().available() > 0) {
            this.l = EncryptedData.parse(derValue.getData(), (byte)10, true);
        }
        if (derValue.getData().available() > 0) {
            Vector<Ticket> vector2 = new Vector<Ticket>();
            derValue2 = derValue.getData().getDerValue();
            if ((derValue2.getTag() & 0x1F) != 11) throw new Asn1Exception(906);
            derValue3 = derValue2.getData().getDerValue();
            if (derValue3.getTag() != 48) throw new Asn1Exception(906);
            while (derValue3.getData().available() > 0) {
                vector2.addElement(new Ticket(derValue3.getData().getDerValue()));
            }
            if (vector2.size() > 0) {
                this.m = new Ticket[vector2.size()];
                vector2.copyInto(this.m);
            }
        }
        if (derValue.getData().available() <= 0) return;
        throw new Asn1Exception(906);
    }

    public byte[] asn1Encode(int n2) throws Asn1Exception, IOException {
        DerOutputStream derOutputStream;
        Vector<DerValue> vector = new Vector<DerValue>();
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), this.b.asn1Encode()));
        if (n2 == 10 && this.c != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), this.c.asn1Encode()));
        }
        if (this.d != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)2), this.d.asn1Encode()));
        }
        if (this.e != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.e.asn1Encode()));
        }
        if (this.f != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.f.asn1Encode()));
        }
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.g.asn1Encode()));
        if (this.h != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.h.asn1Encode()));
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.i);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)7), derOutputStream2.toByteArray()));
        derOutputStream2 = new DerOutputStream();
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.j[i2]));
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)8), derOutputStream3.toByteArray()));
        if (this.k != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)9), this.k.asn1Encode()));
        }
        if (this.l != null) {
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)10), this.l.asn1Encode()));
        }
        if (this.m != null && this.m.length > 0) {
            derOutputStream2 = new DerOutputStream();
            for (int i3 = 0; i3 < this.m.length; ++i3) {
                derOutputStream2.write(this.m[i3].asn1Encode());
            }
            derOutputStream = new DerOutputStream();
            derOutputStream.write((byte)48, derOutputStream2);
            vector.addElement(new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)11), derOutputStream.toByteArray()));
        }
        derOutputStream = new DerValue[vector.size()];
        vector.copyInto((Object[])derOutputStream);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putSequence((DerValue[])derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public Ticket[] getAdditionalTickets() {
        return this.m;
    }

    public EncryptedData getEncryptedAuthzData() {
        return this.l;
    }

    public PrincipalName getClient() {
        return this.c;
    }

    public PrincipalName getServer() {
        return this.e;
    }

    public Realm getRealm() {
        return this.d;
    }

    public int getNonce() {
        return this.i;
    }

    public KDCOptions getOptions() {
        return this.b;
    }

    public KerberosTime getStartTime() {
        return this.f;
    }

    public KerberosTime getEndTime() {
        return this.g;
    }

    public KerberosTime getRenewableTillTime() {
        return this.h;
    }

    public int[] getEtypes() {
        return this.j;
    }

    public HostAddresses getAddresses() {
        return this.k;
    }
}

