/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.internal.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetInternal;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.BaseRowSet;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetMetaDataImpl;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import org.apache.harmony.luni.util.NotImplementedException;
import org.apache.harmony.sql.internal.nls.Messages;
import org.apache.harmony.sql.internal.rowset.CachedRow;
import org.apache.harmony.sql.internal.rowset.CachedRowSetReader;
import org.apache.harmony.sql.internal.rowset.CachedRowSetWriter;

public class CachedRowSetImpl
extends BaseRowSet
implements CachedRowSet,
RowSetInternal {
    private static final long serialVersionUID = 1L;
    private ArrayList<CachedRow> rows;
    private RowSetMetaData meta;
    private CachedRow currentRow;
    private int currentRowIndex;
    private int pageSize;
    private int pageNumber = 1;
    private String tableName;
    private int rememberedCursorPosition;
    private CachedRow insertRow;
    private int[] keyCols;
    private int columnCount;
    private SyncProvider syncProvider;
    private CachedRowSetImpl originalResultSet;
    private Object currentColumn;
    private SQLWarning sqlwarn;

    public CachedRowSetImpl(String string) throws SyncFactoryException {
        this.syncProvider = SyncFactory.getInstance(string);
        this.initialProperties();
    }

    private void initialProperties() {
        try {
            this.setEscapeProcessing(true);
            this.setTransactionIsolation(2);
            this.setConcurrency(1008);
            this.setType(1004);
            this.setMaxRows(0);
            this.setQueryTimeout(0);
            this.setShowDeleted(false);
            this.setUsername(null);
            this.setPassword(null);
            this.setMaxFieldSize(0);
            this.setTypeMap(null);
            this.setFetchSize(0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public CachedRowSetImpl() throws SyncFactoryException {
        this("Apache Harmony HYOptimisticProvider");
    }

    public void setRows(ArrayList<CachedRow> arrayList, int n) {
        this.rows = arrayList;
        this.columnCount = n;
    }

    @Override
    public void acceptChanges() throws SyncProviderException {
        if (this.currentRow == this.insertRow && this.currentRow != null) {
            throw new SyncProviderException();
        }
        try {
            this.acceptChanges(this.getConnection());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        if (this.currentRow == this.insertRow && this.currentRow != null) {
            throw new SyncProviderException();
        }
        try {
            CachedRowSetWriter cachedRowSetWriter = (CachedRowSetWriter)this.syncProvider.getRowSetWriter();
            cachedRowSetWriter.setConnection(connection);
            int n = this.currentRowIndex;
            cachedRowSetWriter.writeData(this);
            this.absolute(n);
            this.notifyRowSetChanged();
        }
        catch (SyncProviderException syncProviderException) {
            throw syncProviderException;
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException(sQLException.getMessage());
        }
    }

    @Override
    public boolean columnUpdated(int n) throws SQLException {
        if (this.currentRow == null || n > this.meta.getColumnCount()) {
            throw new SQLException(Messages.getString("rowset.0"));
        }
        return this.currentRow.getUpdateMask(n - 1);
    }

    @Override
    public boolean columnUpdated(String string) throws SQLException {
        return this.columnUpdated(this.getIndexByName(string));
    }

    private int getIndexByName(String string) throws SQLException {
        for (int i = 1; i <= this.meta.getColumnCount(); ++i) {
            if (!string.equalsIgnoreCase(this.meta.getColumnName(i))) continue;
            return i;
        }
        throw new SQLException(Messages.getString("rowset.1"));
    }

    @Override
    public void commit() throws SQLException {
        this.getConnection().commit();
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        try {
            Object object;
            Object[] objectArray = (Object[])super.getParams().clone();
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                hashtable.put(i, objectArray[i]);
            }
            Vector vector = new Vector();
            CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)super.clone();
            Field field = cachedRowSetImpl.getClass().getSuperclass().getDeclaredField("params");
            field.setAccessible(true);
            field.set(cachedRowSetImpl, hashtable);
            Field field2 = cachedRowSetImpl.getClass().getSuperclass().getDeclaredField("listeners");
            field2.setAccessible(true);
            field2.set(cachedRowSetImpl, vector);
            if (super.getTypeMap() != null) {
                object = super.getTypeMap();
                HashMap hashMap = new HashMap();
                hashMap.putAll((Map<String, Class<?>>)object);
                cachedRowSetImpl.setTypeMap(hashMap);
            }
            object = new ArrayList();
            for (int i = 0; i < this.rows.size(); ++i) {
                ((ArrayList)object).add(this.rows.get(i).createClone());
            }
            cachedRowSetImpl.setRows((ArrayList<CachedRow>)object, this.columnCount);
            cachedRowSetImpl.setMetaData(this.copyMetaData(this.getMetaData()));
            if (this.currentRowIndex > 0 && this.currentRowIndex <= this.rows.size()) {
                cachedRowSetImpl.absolute(this.currentRowIndex);
            }
            if (this.getKeyColumns() != null) {
                cachedRowSetImpl.setKeyColumns((int[])this.getKeyColumns().clone());
            }
            CachedRowSetImpl cachedRowSetImpl2 = new CachedRowSetImpl();
            cachedRowSetImpl2.populate(this.getOriginal());
            cachedRowSetImpl.originalResultSet = cachedRowSetImpl2;
            cachedRowSetImpl.setSyncProvider(this.getSyncProvider().getProviderID());
            if (this.insertRow != null) {
                cachedRowSetImpl.insertRow = this.insertRow.createClone();
            }
            return cachedRowSetImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new SQLException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException();
        }
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopy();
        cachedRowSetImpl.initialProperties();
        return cachedRowSetImpl;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopy();
        cachedRowSetImpl.currentColumn = null;
        cachedRowSetImpl.currentRow = null;
        cachedRowSetImpl.currentRowIndex = 0;
        cachedRowSetImpl.insertRow = null;
        cachedRowSetImpl.pageNumber = 1;
        cachedRowSetImpl.rememberedCursorPosition = 0;
        cachedRowSetImpl.rows = new ArrayList();
        cachedRowSetImpl.sqlwarn = null;
        return cachedRowSetImpl;
    }

    @Override
    public RowSet createShared() throws SQLException {
        RowSet rowSet = null;
        try {
            rowSet = (RowSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException();
        }
        return rowSet;
    }

    @Override
    public void execute(Connection connection) throws SQLException {
        String string = this.getCommand();
        if (string == null || this.getParams() == null) {
            throw new SQLException();
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        Object[] objectArray = this.getParams();
        for (int i = 0; i < objectArray.length; ++i) {
            preparedStatement.setObject(i + 1, objectArray[i]);
        }
        if (preparedStatement.execute()) {
            this.doPopulate(preparedStatement.getResultSet(), true);
        }
    }

    @Override
    public int[] getKeyColumns() throws SQLException {
        return this.keyCols == null ? null : (int[])this.keyCols.clone();
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        return this.originalResultSet;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException();
        }
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        ArrayList<CachedRow> arrayList = new ArrayList<CachedRow>();
        CachedRow cachedRow = this.rows.get(this.getRow() - 1).getOriginal();
        arrayList.add(cachedRow);
        cachedRowSetImpl.setRows(arrayList, this.columnCount);
        cachedRowSetImpl.setType(1004);
        cachedRowSetImpl.setConcurrency(1008);
        return cachedRowSetImpl;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public SyncProvider getSyncProvider() throws SQLException {
        return this.syncProvider;
    }

    @Override
    public String getTableName() throws SQLException {
        return this.tableName;
    }

    @Override
    public boolean nextPage() throws SQLException {
        ++this.pageNumber;
        return false;
    }

    @Override
    public void populate(ResultSet resultSet) throws SQLException {
        this.doPopulate(resultSet, false);
    }

    @Override
    public void populate(ResultSet resultSet, int n) throws SQLException {
        if (n == 1) {
            resultSet.beforeFirst();
        } else if (n <= 0 || !resultSet.absolute(n - 1)) {
            throw new SQLException(Messages.getString("rowset.7"));
        }
        this.doPopulate(resultSet, true);
    }

    private void doPopulate(ResultSet resultSet, boolean bl) throws SQLException {
        this.meta = this.copyMetaData(resultSet.getMetaData());
        if (!bl) {
            int n = this.getPageSize();
            this.setPageSize(0);
            int n2 = this.getMaxRows();
            this.setMaxRows(0);
            new CachedRowSetReader(resultSet).readData(this);
            this.setPageSize(n);
            this.setMaxRows(n2);
        } else {
            new CachedRowSetReader(resultSet).readData(this);
        }
        this.setTableName(resultSet.getMetaData().getTableName(1));
        this.originalResultSet = new CachedRowSetImpl();
        new CachedRowSetReader(this).readData(this.originalResultSet);
        this.originalResultSet.setMetaData((RowSetMetaData)this.getMetaData());
        this.beforeFirst();
    }

    private RowSetMetaData copyMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
        RowSetMetaDataImpl rowSetMetaDataImpl = new RowSetMetaDataImpl();
        rowSetMetaDataImpl.setColumnCount(resultSetMetaData.getColumnCount());
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            rowSetMetaDataImpl.setAutoIncrement(i, resultSetMetaData.isAutoIncrement(i));
            rowSetMetaDataImpl.setCaseSensitive(i, resultSetMetaData.isCaseSensitive(i));
            rowSetMetaDataImpl.setCatalogName(i, resultSetMetaData.getCatalogName(i));
            rowSetMetaDataImpl.setColumnDisplaySize(i, resultSetMetaData.getColumnDisplaySize(i));
            rowSetMetaDataImpl.setColumnLabel(i, resultSetMetaData.getColumnLabel(i));
            rowSetMetaDataImpl.setColumnName(i, resultSetMetaData.getColumnName(i));
            rowSetMetaDataImpl.setColumnType(i, resultSetMetaData.getColumnType(i));
            rowSetMetaDataImpl.setColumnTypeName(i, resultSetMetaData.getColumnTypeName(i));
            rowSetMetaDataImpl.setCurrency(i, resultSetMetaData.isCurrency(i));
            rowSetMetaDataImpl.setNullable(i, resultSetMetaData.isNullable(i));
            rowSetMetaDataImpl.setPrecision(i, resultSetMetaData.getPrecision(i));
            rowSetMetaDataImpl.setScale(i, resultSetMetaData.getScale(i));
            rowSetMetaDataImpl.setSchemaName(i, resultSetMetaData.getSchemaName(i));
            rowSetMetaDataImpl.setSearchable(i, resultSetMetaData.isSearchable(i));
            rowSetMetaDataImpl.setSigned(i, resultSetMetaData.isSigned(i));
            rowSetMetaDataImpl.setTableName(i, resultSetMetaData.getTableName(i));
        }
        return rowSetMetaDataImpl;
    }

    @Override
    public boolean previousPage() throws SQLException {
        return false;
    }

    @Override
    public void release() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void rollback() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setKeyColumns(int[] nArray) throws SQLException {
        this.keyCols = (int[])nArray.clone();
    }

    @Override
    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.meta = rowSetMetaData;
    }

    @Override
    public void setOriginalRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException();
        }
        this.currentRow.setNonUpdateable();
    }

    @Override
    public void setPageSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(Messages.getString("rowset.2"));
        }
        if (this.getMaxRows() != 0 && this.getMaxRows() < n) {
            throw new SQLException(Messages.getString("rowset.9"));
        }
        this.pageSize = n;
    }

    @Override
    public void setSyncProvider(String string) throws SQLException {
        this.syncProvider = SyncFactory.getInstance(string);
    }

    @Override
    public void setTableName(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("rowset.3");
        }
        this.tableName = string;
    }

    @Override
    public int size() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    @Override
    public Collection<?> toCollection() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Collection<?> toCollection(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Collection<?> toCollection(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void undoDelete() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException();
        }
        if (this.currentRow.isDelete()) {
            this.currentRow.undoDelete();
        }
    }

    @Override
    public void undoInsert() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void undoUpdate() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public int[] getMatchColumnIndexes() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public String[] getMatchColumnNames() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setMatchColumn(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setMatchColumn(int[] nArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setMatchColumn(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setMatchColumn(String[] stringArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void unsetMatchColumn(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void unsetMatchColumn(int[] nArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void unsetMatchColumn(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        return this.doAbsolute(n, true);
    }

    private boolean doAbsolute(int n, boolean bl) throws SQLException {
        if (this.rows == null || this.rows.size() == 0) {
            return false;
        }
        if (bl && this.getType() == 1003) {
            throw new SQLException(Messages.getString("rowset.8"));
        }
        if (n < 0) {
            n = this.rows.size() + n + 1;
        }
        if (n <= 0) {
            this.currentRowIndex = 0;
            this.currentRow = null;
            return false;
        }
        if (n > this.rows.size()) {
            this.currentRowIndex = this.rows.size() + 1;
            this.currentRow = null;
            return false;
        }
        this.currentRowIndex = n;
        this.currentRow = this.rows.get(this.currentRowIndex - 1);
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.rows == null) {
            return;
        }
        this.doAbsolute(this.rows.size() + 1, true);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.doAbsolute(0, true);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void close() throws SQLException {
        if (this.rows != null) {
            this.rows.clear();
        }
        this.currentRowIndex = 0;
        this.currentRow = null;
        this.meta = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkValidRow();
        this.currentRow.setDelete();
    }

    private void checkValidRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException(Messages.getString("rowset.0"));
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean first() throws SQLException {
        return this.doAbsolute(1, true);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkValidRow();
        Object object = this.currentRow.getObject(n);
        if (object == null) {
            return null;
        }
        return (Blob)object;
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.getIndexByName(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkValidRow();
        Object object = this.currentRow.getObject(n);
        if (object == null) {
            return false;
        }
        return (Boolean)object;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getIndexByName(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkValidRow();
        Object object = this.currentRow.getObject(n);
        if (object == null) {
            return 0;
        }
        return (Byte)object;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getIndexByName(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkValidRow();
        Object object = this.currentRow.getObject(n);
        if (object == null) {
            return null;
        }
        return (byte[])object;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getIndexByName(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Date getDate(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public double getDouble(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public float getFloat(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkValidRow();
        Object object = this.currentRow.getObject(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.getIndexByName(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public long getLong(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.meta;
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.currentRow.getObject(n);
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.currentRow.getObject(this.getIndexByName(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public int getRow() throws SQLException {
        if (this.currentRow == null) {
            return 0;
        }
        return this.currentRowIndex;
    }

    @Override
    public short getShort(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public short getShort(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkValidRow();
        Object object = this.currentRow.getObject(n);
        if (object == null) {
            return null;
        }
        return (String)object;
    }

    private boolean checkCursorValid() throws SQLException {
        if (this.currentRowIndex <= 0 || this.currentRowIndex > this.rows.size()) {
            throw new SQLException(Messages.getString("rowset.7"));
        }
        return false;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.getIndexByName(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkValidRow();
        if (this.currentRow != this.insertRow) {
            throw new SQLException(Messages.getString("rowset.4"));
        }
        this.insertRow.setInsert();
        this.rows.add(this.insertRow);
        this.insertRow = null;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.rows == null || this.rows.size() == 0) {
            return false;
        }
        return this.currentRowIndex > this.rows.size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.rows == null || this.rows.size() == 0) {
            return false;
        }
        return this.currentRowIndex == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.currentRowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.rows == null || this.rows.size() == 0) {
            return false;
        }
        return this.currentRowIndex == this.rows.size();
    }

    @Override
    public boolean last() throws SQLException {
        return this.doAbsolute(-1, true);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        if (this.rememberedCursorPosition != -1) {
            this.currentRowIndex = this.rememberedCursorPosition;
            this.currentRow = this.currentRowIndex >= 1 && this.currentRowIndex <= this.size() ? this.rows.get(this.currentRowIndex - 1) : null;
            this.rememberedCursorPosition = -1;
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.currentRow = this.insertRow = new CachedRow(new Object[this.columnCount]);
        this.rememberedCursorPosition = this.currentRowIndex;
        this.currentRowIndex = -1;
    }

    @Override
    public boolean next() throws SQLException {
        return this.doAbsolute(this.currentRowIndex + 1, false);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.doAbsolute(this.currentRowIndex - 1, true);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException();
        }
        int n2 = this.getRow() + n;
        if (n2 <= 0) {
            this.beforeFirst();
            return false;
        }
        if (n2 > this.rows.size()) {
            this.afterLast();
            return false;
        }
        return this.doAbsolute(n2, true);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkValidRow();
        this.checkCursorValid();
        return this.currentRow.isDelete();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        if (this.currentRow == null || this.currentRow == this.insertRow) {
            throw new SQLException();
        }
        return this.currentRow.isInsert();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        if (!this.currentRow.isUpdate()) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < this.meta.getColumnCount(); ++i) {
            bl = this.currentRow.getUpdateMask(i) | bl;
        }
        return bl;
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.currentRow.updateObject(n, bigDecimal);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.getIndexByName(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        this.currentRow.updateObject(n, date);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.getIndexByName(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        this.currentRow.updateObject(n, d);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.getIndexByName(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        this.currentRow.updateObject(n, Float.valueOf(f));
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.getIndexByName(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        this.currentRow.updateObject(n, n2);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.getIndexByName(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        this.currentRow.updateObject(n, l);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.getIndexByName(string), l);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateRow() throws SQLException {
        if (this.currentRow == this.insertRow || this.getConcurrency() == 1007) {
            throw new SQLException();
        }
        this.currentRow.setUpdate();
        this.notifyRowChanged();
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        this.currentRow.updateObject(n, string);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.getIndexByName(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        this.currentRow.updateObject(n, time);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.getIndexByName(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.currentRow.updateObject(n, timestamp);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.getIndexByName(string), timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void execute() throws SQLException {
        this.execute(this.getConnection());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.getUrl());
    }

    CachedRow getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateRowId(String string, RowId rowId) {
        throw new NotImplementedException();
    }

    @Override
    public void updateRowId(int n, RowId rowId) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(int n, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(String string, NClob nClob) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(int n, NClob nClob) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNString(String string, String string2) {
        throw new NotImplementedException();
    }

    @Override
    public void updateNString(int n, String string) {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) {
        throw new NotImplementedException();
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(String string, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(int n, Reader reader) {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) {
        throw new NotImplementedException();
    }

    @Override
    public String getNString(int n) {
        throw new NotImplementedException();
    }

    @Override
    public String getNString(String string) {
        throw new NotImplementedException();
    }

    @Override
    public RowId getRowId(int n) {
        throw new NotImplementedException();
    }

    @Override
    public RowId getRowId(String string) {
        throw new NotImplementedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        throw new NotImplementedException();
    }

    @Override
    public Reader getNCharacterStream(int n) {
        throw new NotImplementedException();
    }

    @Override
    public Reader getNCharacterStream(String string) {
        throw new NotImplementedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        throw new NotImplementedException();
    }

    @Override
    public int getHoldability() {
        throw new NotImplementedException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        return null;
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        return null;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setCommand(String string) throws SQLException {
        this.initParams();
        super.setCommand(string);
    }
}

