/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.spi;

import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import javax.sql.rowset.spi.SyncProviderException;
import org.apache.harmony.sql.internal.nls.Messages;

class ProviderImpl
extends SyncProvider {
    private String className;
    private String vendor;
    private String version;
    private SyncProvider impl;
    private String errMsg;

    public ProviderImpl() {
    }

    public ProviderImpl(String string) {
        this.className = string;
        try {
            Class<?> clazz = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
            this.impl = (SyncProvider)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.errMsg = Messages.getString("sql.40", this.className);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProviderImpl(String string, String string2, String string3) {
        this(string);
        this.vendor = string2;
        this.version = string3;
    }

    public SyncProvider getImpl() throws SyncFactoryException {
        if (null == this.impl) {
            throw new SyncFactoryException(Messages.getString("sql.40", this.className));
        }
        return this.impl;
    }

    @Override
    public int getDataSourceLock() throws SyncProviderException {
        this.checkClassNameValid();
        return this.impl.getDataSourceLock();
    }

    @Override
    public int getProviderGrade() {
        return this.impl == null ? 0 : this.impl.getProviderGrade();
    }

    @Override
    public String getProviderID() {
        return this.impl == null ? this.className : this.impl.getProviderID();
    }

    @Override
    public RowSetReader getRowSetReader() {
        return this.impl == null ? null : this.impl.getRowSetReader();
    }

    @Override
    public RowSetWriter getRowSetWriter() {
        return this.impl == null ? null : this.impl.getRowSetWriter();
    }

    @Override
    public String getVendor() {
        return this.impl == null ? this.vendor : this.impl.getVendor();
    }

    @Override
    public String getVersion() {
        return this.impl == null ? this.version : this.impl.getVersion();
    }

    @Override
    public void setDataSourceLock(int n) throws SyncProviderException {
        this.checkClassNameValid();
        this.impl.setDataSourceLock(n);
    }

    @Override
    public int supportsUpdatableView() {
        return this.impl == null ? 0 : this.impl.supportsUpdatableView();
    }

    private void checkClassNameValid() throws SyncProviderException {
        if (null == this.impl) {
            throw new SyncProviderException(this.errMsg);
        }
    }
}

