/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SQLOutputImpl;
import javax.sql.rowset.serial.SerialException;

public class SerialStruct
implements Struct,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8322445504027483372L;
    private String SQLTypeName;
    private Object[] attribs;

    public SerialStruct(SQLData sQLData, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = sQLData.getSQLTypeName();
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
        Vector vector = new Vector();
        try {
            SQLOutputImpl sQLOutputImpl = new SQLOutputImpl(vector, map);
            sQLData.writeSQL(sQLOutputImpl);
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
        this.attribs = vector.toArray();
    }

    public SerialStruct(Struct struct, Map<String, Class<?>> map) throws SerialException {
        try {
            this.SQLTypeName = struct.getSQLTypeName();
            this.attribs = struct.getAttributes(map);
        }
        catch (SQLException sQLException) {
            throw new SerialException(sQLException.getMessage());
        }
    }

    @Override
    public Object[] getAttributes() throws SerialException {
        return this.attribs;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SerialException {
        return this.attribs;
    }

    @Override
    public String getSQLTypeName() throws SerialException {
        return this.SQLTypeName;
    }
}

