/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import javax.sql.rowset.serial.DefaultUDTMap;
import javax.sql.rowset.serial.SerialException;
import org.apache.harmony.sql.internal.nls.Messages;

public class SerialArray
implements Array,
Serializable,
Cloneable {
    private static final long serialVersionUID = -8466174297270688520L;
    Object[] elements;
    int baseType;
    String baseTypeName;
    int len;

    public SerialArray(Array array, Map<String, Class<?>> map) throws SerialException, SQLException {
        if (null == array || null == array.getArray() || null == map) {
            throw new SQLException(Messages.getString("sql.39"));
        }
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        Object[] objectArray = (Object[])array.getArray(map);
        if (objectArray.length == 0) {
            this.elements = new Object[0];
        } else {
            this.transferElements(this.baseType, objectArray);
        }
    }

    private void transferElements(int n, Object[] objectArray) throws SQLException {
        switch (n) {
            case 2002: {
                this.elements = DefaultUDTMap.processStruct(objectArray);
                break;
            }
            case 2003: {
                this.elements = DefaultUDTMap.processArray(objectArray);
                break;
            }
            case 2005: {
                this.elements = DefaultUDTMap.processClob(objectArray);
                break;
            }
            case 2004: {
                this.elements = DefaultUDTMap.processBlob(objectArray);
                break;
            }
            case 70: {
                this.elements = DefaultUDTMap.processDatalink(objectArray);
                break;
            }
            case 2000: {
                this.elements = DefaultUDTMap.processObject(objectArray);
                break;
            }
            default: {
                this.elements = new Object[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    this.elements[i] = objectArray[i];
                }
            }
        }
    }

    public SerialArray(Array array) throws SerialException, SQLException {
        if (null == array || null == array.getArray()) {
            throw new SQLException(Messages.getString("sql.39"));
        }
        this.baseType = array.getBaseType();
        this.baseTypeName = array.getBaseTypeName();
        Object[] objectArray = (Object[])array.getArray();
        if (objectArray.length == 0) {
            this.elements = new Object[0];
        } else {
            this.transferElements(this.baseType, objectArray);
        }
    }

    @Override
    public Object getArray() throws SerialException {
        Object[] objectArray = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
        return this.elements;
    }

    @Override
    public Object getArray(long l, int n) throws SerialException {
        if (l < 0L || (long)n + l > (long)this.elements.length) {
            throw new SerialException(Messages.getString("sql.42"));
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public Object getArray(long l, int n, Map<String, Class<?>> map) throws SerialException {
        if (l < 0L || (long)n + l > (long)this.elements.length) {
            throw new SerialException(Messages.getString("sql.40"));
        }
        Object[] objectArray = new Object[n];
        System.arraycopy(this.elements, (int)l, objectArray, 0, n);
        return objectArray;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SerialException {
        return this.getArray(0L, this.elements.length, null == map ? DefaultUDTMap.DEFAULTMAP : map);
    }

    @Override
    public int getBaseType() throws SerialException {
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    @Override
    public ResultSet getResultSet() throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long l, int n) throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(long l, int n, Map<String, Class<?>> map) throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SerialException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

