/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.SqlUtil;
import org.apache.harmony.sql.internal.nls.Messages;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private static final String EMPTY_STRING = "";
    private static final int DEFAULT_COLUMN_COUNT = 5;
    private static final long serialVersionUID = 6893806403181801867L;
    private static RowSetMetaDataImpl instance = new RowSetMetaDataImpl();
    private int colCount;
    private ColInfo[] colInfo;

    private void checkNegativeValue(int n, String string) throws SQLException {
        if (n < 0) {
            throw new SQLException(Messages.getString(string));
        }
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (null == this.colInfo || n < 1 || n >= this.colInfo.length) {
            throw new SQLException(Messages.getString("sql.27", n + 1));
        }
        if (null == this.colInfo[n]) {
            this.colInfo[n] = new ColInfo();
        }
    }

    @Override
    public void setColumnCount(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException(Messages.getString("sql.26"));
        }
        try {
            this.colInfo = n + 1 > 0 ? new ColInfo[n + 1] : new ColInfo[5];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.colInfo = new ColInfo[5];
        }
        this.colCount = n;
    }

    @Override
    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].autoIncrement = bl;
    }

    @Override
    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].caseSensitive = bl;
    }

    @Override
    public void setSearchable(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].searchable = bl;
    }

    @Override
    public void setCurrency(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].currency = bl;
    }

    @Override
    public void setNullable(int n, int n2) throws SQLException {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new SQLException(Messages.getString("sql.29"));
        }
        this.checkColumnIndex(n);
        this.colInfo[n].nullable = n2;
    }

    @Override
    public void setSigned(int n, boolean bl) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].signed = bl;
    }

    @Override
    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.checkNegativeValue(n2, "sql.30");
        this.checkColumnIndex(n);
        this.colInfo[n].columnDisplaySize = n2;
    }

    @Override
    public void setColumnLabel(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].columnLabel = string == null ? EMPTY_STRING : string;
    }

    @Override
    public void setColumnName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].columnName = string == null ? EMPTY_STRING : string;
    }

    @Override
    public void setSchemaName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].schemaName = string == null ? EMPTY_STRING : string;
    }

    @Override
    public void setPrecision(int n, int n2) throws SQLException {
        this.checkNegativeValue(n2, "sql.31");
        this.checkColumnIndex(n);
        this.colInfo[n].precision = n2;
    }

    @Override
    public void setScale(int n, int n2) throws SQLException {
        this.checkNegativeValue(n2, "sql.32");
        this.checkColumnIndex(n);
        this.colInfo[n].scale = n2;
    }

    @Override
    public void setTableName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].tableName = string == null ? EMPTY_STRING : string;
    }

    @Override
    public void setCatalogName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].catalogName = string == null ? EMPTY_STRING : string;
    }

    @Override
    public void setColumnType(int n, int n2) throws SQLException {
        SqlUtil.validateType(n2);
        this.checkColumnIndex(n);
        this.colInfo[n].colType = n2;
    }

    @Override
    public void setColumnTypeName(int n, String string) throws SQLException {
        this.checkColumnIndex(n);
        this.colInfo[n].colTypeName = string == null ? EMPTY_STRING : string;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].autoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].caseSensitive;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].searchable;
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].currency;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].nullable;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].signed;
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].columnDisplaySize;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].columnLabel;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].columnName;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].schemaName;
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].precision;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].scale;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].tableName;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].catalogName;
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].colType;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].colTypeName;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        return !this.isWritable(n);
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].writeable;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.colInfo[n].definiteWritable;
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        return SqlUtil.getClassNameByType(this.getColumnType(n));
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)instance;
    }

    private class ColInfo
    implements Serializable {
        private static final long serialVersionUID = 5490834817919311283L;
        public boolean autoIncrement;
        public boolean caseSensitive;
        public boolean currency;
        public boolean signed;
        public boolean searchable;
        public boolean writeable = true;
        public boolean definiteWritable = true;
        public String columnLabel;
        public String columnName;
        public String schemaName = "";
        public String colTypeName;
        public int colType;
        public int nullable;
        public int columnDisplaySize;
        public int precision;
        public int scale;
        public String tableName = "";
        public String catalogName = "";

        private ColInfo() {
        }
    }
}

