/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.setcommands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;

public class SetLoggingCommand
extends Command {
    public SetLoggingCommand(Output o) {
        super(o, "logging", "configures several logging-related parameters, starts/stops logging", "parameters: [on|off], file <filename>, overwrite [on|off], redirect [on|off]\n\n- [on|off] - turns logging on or off (default: off)\n- file <filename> - sets the file to log to; this will be relative to the directory returned by the \"pwd\" command unless an absolute path is specified; if the file is set while logging is on, the change will take effect the next time logging is started (default: <not set>)\n- overwrite [on|off] - turns overwriting of the specified log file on or off (off means that the log file will be appended to); if this is on, the log file will be cleared every time \"set logging on\" is run (default: off)\n- redirect [on|off] - turns redirecting to file on or off (on means that non-error output goes only to the log file (not the console) when logging is on, off means that non-error output goes to both the console and the log file); redirection must be turned off logging can be turned off (default: off)\n");
        this.child_commands = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (args.isEmpty()) {
            this.out.error("\"set logging\" requires at least one parameter");
            return;
        }
        String arg1 = (String)args.pop();
        if (arg1.equals("on")) {
            FileWriter f2;
            if (!args.isEmpty()) {
                this.out.error("\"set logging on\" does not take any additional parameters");
                return;
            }
            String logging = (String)properties.get("set_logging");
            if (null != logging && logging.equals("on")) {
                this.out.error("logging is already turned on");
                return;
            }
            String filename = (String)properties.get("set_logging_file");
            if (null == filename) {
                this.out.error("log file not yet set; set log file with \"set logging file <filename>\"");
                return;
            }
            File logfile = Utils.absPath(properties, filename);
            String filepath = logfile.getPath();
            try {
                f2 = new FileWriter(logfile, this.appendToFile(properties));
            }
            catch (IOException e) {
                Object f2 = null;
                this.out.error("IOException encountered while opening file \"" + filepath + "\"; make sure the file can be written to");
                return;
            }
            this.out.addChannel(new FileOutputChannel(f2), true);
            properties.put("set_logging", "on");
            properties.put("current_logging_file", filepath);
            this.out.print("\n");
            this.out.print("\tlogging turned on; outputting to \"" + filepath + "\"");
            this.out.print("\n\n");
            return;
        }
        if (arg1.equals("off")) {
            if (!args.isEmpty()) {
                this.out.error("\"set logging off\" does not take any additional parameters");
                return;
            }
            String redirect = (String)properties.get("set_logging_redirect");
            if (null != redirect && redirect.equals("on")) {
                this.out.error("cannot turn off logging when redirecting to only a file is turned on; turn off redirecting to only a file and try again");
                return;
            }
            String logging = (String)properties.get("set_logging");
            if (null != logging && !logging.equals("off")) {
                properties.put("set_logging", "off");
                this.out.print("\n");
                this.out.print("\tlogging turned off; was logging to \"" + (String)properties.get("current_logging_file") + "\"");
                this.out.print("\n\n");
                this.out.removeFileChannel();
                properties.put("current_logging_file", null);
                return;
            }
            this.out.error("logging is already turned off");
            return;
        }
        if (arg1.equals("file")) {
            if (args.isEmpty()) {
                this.out.error("\"set logging file\" requires a filename parameter");
                return;
            }
            String filename = (String)args.pop();
            if (!args.isEmpty()) {
                this.out.error("\"set logging file\" takes exactly one parameter");
                return;
            }
            String oldFile = properties.put("set_logging_file", filename);
            this.out.print("\n");
            if (null == oldFile) {
                this.out.print("\tlog file set to \"" + filename + "\"");
            } else {
                this.out.print("\tlog file changed from \"" + oldFile + "\" to \"" + filename + "\"");
            }
            this.out.print("\n\n");
            return;
        }
        if (arg1.equals("overwrite")) {
            if (args.isEmpty()) {
                this.out.error("\"set logging overwrite\" requires on/off parameter");
                return;
            }
            String param = (String)args.pop();
            if (!args.isEmpty()) {
                this.out.error("\"set logging overwrite\" takes exactly one parameter");
                return;
            }
            if (param.equals("on")) {
                String oldParam = properties.put("set_logging_overwrite", "on");
                if (null != oldParam && !oldParam.equals("off")) {
                    this.out.print("\n");
                    this.out.print("\toverwriting of log file option not changed (already \"on\")");
                    this.out.print("\n\n");
                    return;
                }
                this.out.print("\n");
                this.out.print("\toverwriting of log file option changed from \"off\" to \"on\"");
                this.out.print("\n\n");
                return;
            }
            if (!param.equals("off")) {
                this.out.error("parameter for \"set logging overwrite\" must be \"on\" or \"off\"");
                return;
            }
            String oldParam = properties.put("set_logging_overwrite", "off");
            if (null != oldParam && !oldParam.equals("off")) {
                this.out.print("\n");
                this.out.print("\toverwriting of log file option changed from \"on\" to \"off\"");
                this.out.print("\n\n");
                return;
            }
            this.out.print("\n");
            this.out.print("\toverwriting of log file option not changed (already \"off\")");
            this.out.print("\n\n");
            return;
        }
        if (!arg1.equals("redirect")) {
            this.out.error("\"" + arg1 + "\" is not a valid parameter for the \"set logging\" command");
            return;
        }
        if (args.isEmpty()) {
            this.out.error("\"set logging redirect\" requires on/off parameter");
            return;
        }
        String param = (String)args.pop();
        if (!args.isEmpty()) {
            this.out.error("\"set logging redirect\" takes exactly one parameter");
            return;
        }
        if (param.equals("on")) {
            String logging = (String)properties.get("set_logging");
            if (null == logging || logging.equals("off")) {
                this.out.error("cannot redirect to only a file because logging is off; turn logging on and try again");
                return;
            }
            String oldParam = properties.put("set_logging_redirect", "on");
            if (null != oldParam && !oldParam.equals("off")) {
                this.out.print("\n");
                this.out.print("\tredirecting to file only option not changed (already \"on\")");
                this.out.print("\n\n");
                return;
            }
            this.out.print("\n");
            this.out.print("\tredirecting to file only option changed from \"off\" to \"on\"");
            this.out.print("\n\n");
            this.out.setConsoleNoPrint(true);
            return;
        }
        if (!param.equals("off")) {
            this.out.error("parameter for \"set logging redirect\" must be \"on\" or \"off\"");
            return;
        }
        String oldParam = properties.put("set_logging_redirect", "off");
        if (null != oldParam && !oldParam.equals("off")) {
            this.out.setConsoleNoPrint(false);
            this.out.print("\n");
            this.out.print("\tredirecting to file only option changed from \"on\" to \"off\"");
            this.out.print("\n\n");
            return;
        }
        this.out.print("\n");
        this.out.print("\tredirecting to file only option not changed (already \"off\")");
        this.out.print("\n\n");
    }

    private boolean appendToFile(HashMap properties) {
        String append = (String)properties.get("set_logging_overwrite");
        return append == null || !append.equals("on");
    }
}

