/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class InfoSymCommand
extends Command {
    public InfoSymCommand(Output o) {
        super(o, "sym", "outputs a list of available modules", "parameters: none\n\nfor each process in the address spaces, outputs a list of module sections for each module with their start and end addresses, names, and sizes\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        int asnum = 0;
        Iterator itAddressSpace = loadedImage.getAddressSpaces();
        while (itAddressSpace.hasNext()) {
            ImageAddressSpace ias = (ImageAddressSpace)itAddressSpace.next();
            this.out.print("\n\tlibraries for address space # " + asnum + "\n");
            Iterator itProcess = ias.getProcesses();
            while (itProcess.hasNext()) {
                Iterator iLibs;
                ImageProcess ip = (ImageProcess)itProcess.next();
                this.out.print("\t process id: ");
                try {
                    this.out.print(ip.getID());
                }
                catch (DataUnavailable du) {
                    this.out.print(Exceptions.getDataUnavailableString());
                }
                catch (CorruptDataException cde) {
                    this.out.print(Exceptions.getCorruptDataExceptionString());
                }
                this.out.print("\n\n");
                try {
                    iLibs = ip.getLibraries();
                }
                catch (DataUnavailable du) {
                    iLibs = null;
                    this.out.println(Exceptions.getDataUnavailableString());
                }
                catch (CorruptDataException cde) {
                    iLibs = null;
                    this.out.println(Exceptions.getCorruptDataExceptionString());
                }
                while (null != iLibs && iLibs.hasNext()) {
                    Object next = iLibs.next();
                    if (next instanceof ImageModule) {
                        ImageModule imageModule = (ImageModule)next;
                        try {
                            this.out.print("\t  " + imageModule.getName());
                        }
                        catch (CorruptDataException cde) {
                            this.out.print("\t  " + Exceptions.getCorruptDataExceptionString());
                        }
                        this.out.print(", sections:\n");
                        Iterator itSection = imageModule.getSections();
                        while (itSection.hasNext()) {
                            next = itSection.next();
                            if (next instanceof ImageSection) {
                                ImageSection is = (ImageSection)next;
                                this.out.print("\t   0x" + Long.toHexString(is.getBaseAddress().getAddress()) + " - 0x" + Long.toHexString(is.getBaseAddress().getAddress() + is.getSize()));
                                this.out.print(", name: \"");
                                this.out.print(is.getName());
                                this.out.print("\", size: 0x");
                                this.out.print(Long.toHexString(is.getSize()));
                                this.out.print("\n");
                                continue;
                            }
                            if (next instanceof CorruptData) {
                                this.out.print("\t   <corrupt section encountered>\n");
                                continue;
                            }
                            this.out.print("\t   <corrupt section encountered>\n");
                        }
                        this.out.print("\n");
                        continue;
                    }
                    if (next instanceof CorruptData) {
                        CorruptData corruptObj = (CorruptData)next;
                        this.out.print("\t  <corrupt library encountered: " + corruptObj.toString() + ">\n\n");
                        continue;
                    }
                    this.out.print("\t  <corrupt library encountered>\n\n");
                }
            }
            ++asnum;
        }
    }
}

