/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaMethod;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class InfoJitmCommand
extends Command {
    public InfoJitmCommand(Output o) {
        super(o, "jitm", "displays JIT'ed methods and their addresses", "parameters: none\n\nprints the following information about each JIT'ed method\n\n  - method name and signature\n  - method start address\n  - method end address\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        if (!args.isEmpty()) {
            this.out.error("\"info jitm\" command does not take any parameters");
        } else {
            Iterator itJavaRuntime = Utils.getRuntimes(loadedImage);
            while (itJavaRuntime.hasNext()) {
                JavaRuntime jr = (JavaRuntime)itJavaRuntime.next();
                Iterator itJavaClassLoader = jr.getJavaClassLoaders();
                while (itJavaClassLoader.hasNext()) {
                    JavaClassLoader jcl = (JavaClassLoader)itJavaClassLoader.next();
                    Iterator itJavaClass = jcl.getDefinedClasses();
                    while (itJavaClass.hasNext()) {
                        String jcName;
                        JavaClass jc = (JavaClass)itJavaClass.next();
                        Iterator itJavaMethod = jc.getDeclaredMethods();
                        try {
                            jcName = jc.getName();
                        }
                        catch (CorruptDataException e) {
                            jcName = Exceptions.getCorruptDataExceptionString();
                        }
                        while (itJavaMethod.hasNext()) {
                            String sig;
                            String name;
                            JavaMethod jm = (JavaMethod)itJavaMethod.next();
                            try {
                                name = jm.getName();
                            }
                            catch (CorruptDataException e) {
                                name = Exceptions.getCorruptDataExceptionString();
                            }
                            try {
                                sig = jm.getSignature();
                            }
                            catch (CorruptDataException e) {
                                sig = Exceptions.getCorruptDataExceptionString();
                            }
                            if (!jm.getCompiledSections().hasNext()) continue;
                            Iterator itImageSection = jm.getCompiledSections();
                            while (itImageSection.hasNext()) {
                                ImageSection is = (ImageSection)itImageSection.next();
                                long startAddr = is.getBaseAddress().getAddress();
                                long size = is.getSize();
                                long endAddr = startAddr + size;
                                this.out.print("\n\tstart=" + Utils.toHex(startAddr) + "  " + "end=" + Utils.toHex(endAddr) + "   " + jcName + "::" + name + sig);
                            }
                        }
                    }
                }
            }
        }
        this.out.print("\n");
    }
}

