/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.runtime.ManagedRuntime;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.Command;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class InfoHeapCommand
extends Command {
    public InfoHeapCommand(Output o) {
        super(o, "heap", "displays information about Java heaps", "parameters: none, \"*\", or heap name\n\n none prints:\n - heap name\n - heap section\n \"*\" or heap name prints the following information\n about all heaps or the specified heap, respectively:\n - heap name\n - (heap size and occupancy)\n - heap sections\n  - section name\n  - section size\n  - whether the section is shared\n  - whether the section is executable\n  - whether the section is read only\n");
        this.child_commands = null;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        String param = null;
        StringBuffer paramsToString = new StringBuffer();
        if (!args.isEmpty()) {
            for (int i = args.size() - 1; i >= 0; --i) {
                paramsToString.append((String)args.get(i) + " ");
            }
            if (paramsToString != null) {
                param = paramsToString.toString();
                param = param.trim();
            }
        }
        Iterator itRuntime = Utils.getRuntimes(loadedImage);
        int count = 1;
        this.out.print("\n");
        while (itRuntime.hasNext()) {
            ManagedRuntime mr = (ManagedRuntime)itRuntime.next();
            if (mr instanceof JavaRuntime) {
                this.out.print("\tRuntime #" + count);
                this.out.print("\n");
                if (args.isEmpty()) {
                    this.printHeapInfo(null, (JavaRuntime)mr, this.out);
                    this.out.print("\nUse \"info heap *\" or \"info heap <heap_name>\" for more information.\n");
                } else if (param.indexOf("*") >= 0) {
                    this.printHeapInfo(param, (JavaRuntime)mr, this.out);
                } else {
                    boolean foundHeap = this.searchForHeap(param, (JavaRuntime)mr, this.out);
                    if (!foundHeap) {
                        this.out.error("Unable to locate heap: \"" + param + "\".");
                        this.out.print("\tAvailable heaps: \n");
                        this.printHeapInfo(null, (JavaRuntime)mr, this.out);
                    }
                }
            }
            ++count;
        }
    }

    private void printHeapInfo(String param, JavaRuntime runtime, Output out) {
        Iterator itHeaps = runtime.getHeaps();
        int countheaps = 1;
        while (itHeaps.hasNext()) {
            JavaHeap theHeap = (JavaHeap)itHeaps.next();
            out.print("\t Heap #" + countheaps + ":  " + theHeap.getName() + "\n");
            if (param != null) {
                this.printSectionInfo(theHeap, out);
            }
            ++countheaps;
        }
    }

    private void printSectionInfo(JavaHeap theHeap, Output out) {
        Iterator itSections = theHeap.getSections();
        int countSections = 1;
        while (itSections.hasNext()) {
            ImageSection theSection = (ImageSection)itSections.next();
            out.print("\t  Section #" + countSections + ":  " + theSection.getName() + "\n");
            out.print("\t   Size:        " + theSection.getSize() + " bytes\n");
            try {
                out.print("\t   Shared:      " + theSection.isShared() + "\n");
                out.print("\t   Executable:  " + theSection.isExecutable() + "\n");
                out.print("\t   Read Only:   " + theSection.isReadOnly() + "\n");
            }
            catch (DataUnavailable e) {
                out.print("\t   Shared:      <unknown>\n");
                out.print("\t   Executable:  <unknown>\n");
                out.print("\t   Read Only:   <unknown>\n");
            }
            ++countSections;
        }
    }

    private boolean searchForHeap(String param, JavaRuntime jr, Output out) {
        boolean foundHeap = false;
        Iterator itHeaps = jr.getHeaps();
        int countheaps = 1;
        while (itHeaps.hasNext()) {
            JavaHeap theHeap = (JavaHeap)itHeaps.next();
            if (theHeap.getName().indexOf(param) == 0) {
                out.print("\t Heap #" + countheaps + ":  " + theHeap.getName() + "\n");
                this.printOccupancyInfo(theHeap, out);
                this.printSectionInfo(theHeap, out);
                foundHeap = true;
            }
            ++countheaps;
        }
        return foundHeap;
    }

    private void printOccupancyInfo(JavaHeap theHeap, Output out) {
        long size = 0L;
        long totalObjectSize = 0L;
        Iterator itSections = theHeap.getSections();
        while (itSections.hasNext()) {
            ImageSection theSection = (ImageSection)itSections.next();
            size += theSection.getSize();
        }
        out.print("\t  Size of heap: " + size + " bytes\n");
        Iterator itObjects = theHeap.getObjects();
        try {
            while (itObjects.hasNext()) {
                JavaObject theObject = (JavaObject)itObjects.next();
                totalObjectSize += theObject.getSize();
            }
            float percentage = (float)totalObjectSize / (float)size * 10000.0f;
            int trimmedPercent = (int)percentage;
            percentage = (float)trimmedPercent / 100.0f;
            out.print("\t  Occupancy :   " + totalObjectSize + " bytes  (" + percentage + "%)\n");
        }
        catch (CorruptDataException e) {
            out.print("\t  Occupancy :   <unknown>\n");
        }
    }
}

