/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.helpers;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import com.ibm.jvm.dtfjview.commands.helpers.MonitorNode;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;

public class NodeList {
    private MonitorNode head;
    private MonitorNode tail;
    private int id;

    public NodeList(MonitorNode node, int _id) {
        this.head = node;
        this.tail = node;
        node.inList = this;
        this.id = _id;
    }

    public int getID() {
        return this.id;
    }

    public boolean equals(Object other) {
        return ((NodeList)other).getID() == this.id;
    }

    public NodeList attachOrSplit(NodeList other, int nodeListNum) {
        MonitorNode headToAttach = other.getHead();
        if (this.tail == headToAttach) {
            MonitorNode currNode = this.tail = other.getTail();
            currNode.inList = this;
            if (currNode != headToAttach) {
                do {
                    currNode = currNode.waitingOn;
                    currNode.inList = this;
                } while (currNode != headToAttach);
            }
            return null;
        }
        MonitorNode currNode = this.tail;
        NodeList split = new NodeList(this.tail, nodeListNum);
        do {
            if (currNode == headToAttach) {
                this.tail = currNode;
                return split;
            }
            currNode = currNode.waitingOn;
            split.add(currNode);
            if (currNode == this.head) continue;
            currNode.inList = split;
        } while (currNode != this.head);
        return null;
    }

    public void add(MonitorNode node) {
        this.head = node;
    }

    public MonitorNode getHead() {
        return this.head;
    }

    public MonitorNode getTail() {
        return this.tail;
    }

    public boolean isLoop() {
        return this.tail == this.head;
    }

    public String toString() {
        String retval = "";
        MonitorNode currNode = this.tail;
        MonitorNode lastNode = null;
        boolean firstTime = true;
        boolean done = false;
        do {
            String name = "";
            String objAddr = "";
            JavaObject object = null;
            JavaThread owner = null;
            try {
                owner = currNode.getMonitor().getOwner();
            }
            catch (CorruptDataException e) {
                name = Exceptions.getCorruptDataExceptionString() + " in owner";
            }
            if (name.equals("")) {
                try {
                    name = owner.getName();
                }
                catch (CorruptDataException e) {
                    name = Exceptions.getCorruptDataExceptionString() + " in owner's ID";
                }
            }
            objAddr = null == (object = currNode.getMonitor().getObject()) ? "raw" : Utils.toHex(object.getID().getAddress());
            retval = retval + "thread: " + name + " (monitor object: " + objAddr + ") waiting for =>\n\t  ";
            lastNode = currNode;
            currNode = currNode.waitingOn;
            if (this.head == lastNode) {
                done = !firstTime || this.head != this.tail;
            }
            firstTime = false;
        } while (!done);
        retval = retval.substring(0, retval.length() - 18);
        return retval;
    }
}

