/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.Image;
import com.ibm.jvm.dtfjview.Output;
import com.ibm.jvm.dtfjview.commands.RootCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public abstract class Command {
    private String name;
    private String desc;
    private String longDesc;
    protected Vector child_commands;
    protected Output out;

    protected Command(Output o, String aName, String aDesc, String aLongDesc) {
        this.out = o;
        this.name = aName;
        this.desc = aDesc;
        this.longDesc = aLongDesc;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Vector getChildCommands() {
        return this.child_commands;
    }

    public void printHelp(String indent, int descOffset, Stack currArgs, Stack prevArgs) {
        if (null == currArgs) {
            String spaces = "";
            int numSpaces = descOffset;
            numSpaces -= indent.length();
            numSpaces -= this.name.length();
            for (int i = 0; i < numSpaces; ++i) {
                spaces = spaces + " ";
            }
            this.out.print(indent + this.name + spaces + this.desc + "\n");
            if (null != this.child_commands) {
                for (Command command : this.child_commands) {
                    command.printHelp(indent + " ", descOffset, currArgs, prevArgs);
                }
            }
            return;
        }
        if (currArgs.isEmpty()) {
            String cmdName = this.getNameFromStack(prevArgs);
            if (null == this.child_commands) {
                if (null == this.longDesc) {
                    this.out.error("<long descriptions not implemented for \"" + cmdName + "\" command>");
                } else {
                    if (cmdName != null && cmdName != "") {
                        this.out.print("\n");
                        this.out.print("\t");
                        this.out.print("\"" + cmdName + "\" command");
                    }
                    this.out.print("\n");
                    this.out.print(this.formatDesc(this.longDesc));
                    this.out.print("\n");
                }
            } else {
                indent = "\t";
                this.out.print("\n");
                this.out.print(indent + cmdName);
                this.out.print("\n");
                for (Command command : this.child_commands) {
                    command.printHelp(indent + " ", descOffset, null, prevArgs);
                }
                this.out.print("\n");
            }
            return;
        }
        String arg = (String)currArgs.pop();
        if (null == this.child_commands) {
            String cmdName = this.getNameFromStack(prevArgs);
            this.out.error("\"" + cmdName + "\" does not have any sub-commands");
            return;
        }
        Iterator itCommand = this.child_commands.iterator();
        boolean found = false;
        Command currCommand = null;
        while (itCommand.hasNext() && !found) {
            currCommand = (Command)itCommand.next();
            if (!currCommand.getName().equals(arg)) continue;
            found = true;
        }
        if (!found) {
            String cmdName = this.getNameFromStack(prevArgs);
            this.out.error("\"" + arg + "\" is not a sub-command of \"" + cmdName + "\"");
            return;
        }
        prevArgs.push(arg);
        currCommand.printHelp(indent, descOffset, currArgs, prevArgs);
    }

    private String getNameFromStack(Stack args) {
        String cmdName = "";
        while (!args.isEmpty()) {
            String currArg = (String)args.pop();
            if (currArg.endsWith("/")) {
                cmdName = currArg + cmdName;
                continue;
            }
            cmdName = currArg + " " + cmdName;
        }
        if (cmdName.length() > 0 && cmdName.endsWith(" ")) {
            cmdName = cmdName.substring(0, cmdName.length() - 1);
        }
        return cmdName;
    }

    private String formatDesc(String sDesc) {
        int nIndent = 8;
        String sIndent = "\t";
        int nWrapIndent = 3;
        String sWrapIndent = "   ";
        int nWidth = 80;
        char[] aDesc = sDesc.toCharArray();
        String formatted = "";
        formatted = formatted + sIndent;
        int charsInLine = nIndent;
        int i = 0;
        while (i < aDesc.length) {
            String currWord = "";
            while (i < aDesc.length && '\n' != aDesc[i] && ' ' != aDesc[i]) {
                currWord = currWord + aDesc[i];
                ++i;
            }
            ++i;
            int currWordLength = currWord.length() + 1;
            if (currWordLength + charsInLine > nWidth) {
                formatted = formatted + "\n";
                formatted = formatted + sIndent;
                formatted = formatted + sWrapIndent;
                charsInLine = nIndent + nWrapIndent;
            }
            formatted = formatted + " " + currWord;
            charsInLine += currWordLength;
            if (i > aDesc.length || '\n' != aDesc[i - 1]) continue;
            formatted = formatted + "\n";
            formatted = formatted + sIndent;
            charsInLine = nIndent;
        }
        return formatted;
    }

    public void doCommand(Stack args, Image loadedImage, HashMap properties) {
        boolean found = false;
        String nextCommand = null;
        if (args.isEmpty()) {
            this.out.error("specified command requires additional subcommand");
            return;
        }
        nextCommand = (String)args.pop();
        nextCommand = nextCommand.toLowerCase();
        Command currCommand = null;
        Iterator itCommand = this.child_commands.iterator();
        while (itCommand.hasNext() && !found) {
            currCommand = (Command)itCommand.next();
            if (!nextCommand.equals(currCommand.getName())) continue;
            found = true;
        }
        if (!found) {
            this.out.error("command \"" + nextCommand + "\" does not exist; type \"help\" " + "for a list of available commands");
            return;
        }
        currCommand.doCommand(args, loadedImage, properties);
    }

    protected void doScrollCommand(Image loadedImage, HashMap properties, boolean direction) {
        RootCommand rootCommand = (RootCommand)properties.get("RootCommandObject");
        if (null == rootCommand) {
            this.out.error("ERROR - No mapping found for RootCommand object");
            return;
        }
        Long currentMemAddress = (Long)properties.get("currentMemPtrAddress");
        Integer currentNumBytesToPrint = (Integer)properties.get("currentNumBytes");
        if (null == currentMemAddress || null == currentNumBytesToPrint) {
            this.out.error("ERROR - starting mem address or the number of bytes to print needs to be set by running hexdump command");
            return;
        }
        long newMemAddrss = direction ? currentMemAddress + (long)currentNumBytesToPrint.intValue() : currentMemAddress - (long)currentNumBytesToPrint.intValue();
        Stack plusCommandStack = Utils.constructStackFromString("hexdump " + Long.toHexString(newMemAddrss) + " " + currentNumBytesToPrint.toString());
        rootCommand.doCommand(plusCommandStack, loadedImage, properties);
        properties.put("currentMemPtrAddress", new Long(newMemAddrss));
    }
}

