/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.OutputChannel;
import com.ibm.jvm.dtfjview.commands.helpers.Utils;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class FileOutputChannel
implements OutputChannel {
    private FileWriter fw;

    public FileOutputChannel(FileWriter f) {
        this.fw = f;
    }

    public void print(String outputString) {
        try {
            this.fw.write(Utils.toString(outputString));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printPrompt(String prompt) {
    }

    public void println(String outputString) {
        try {
            this.fw.write(Utils.toString(outputString) + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void error(String outputString) {
        try {
            this.fw.write("\n");
            this.fw.write("\tERROR: " + Utils.toString(outputString) + "\n");
            this.fw.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void printInput(long timestamp, String prompt, String outputString) {
        try {
            this.fw.write(new Date(timestamp).toString() + " " + prompt + Utils.toString(outputString) + "\n");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

