/*
 * Decompiled with CFR 0.152.
 */
package xlxp.samples.val.xs;

import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.XMLString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import xlxp.samples.val.xs.ParserBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class TestAll
extends ParserBase {
    private static final boolean TEST_ALL_DEBUG = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            try {
                return Boolean.getBoolean("debug.testAll");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
    });
    private static final String FILE_V = "schemaValidtest.lst";
    private static final String FILE_V_E = "schemaValid-Erratatest.lst";
    private static final String FILE_I = "schemaInvalidtest.lst";
    private static final String FILE_I_E = "schemaInvalid-Erratatest.lst";
    private String testDir = null;
    private final SAXParser xsdParser = new SAXParser();
    private boolean toFile = false;
    private int list = 0;
    private String errorStr;
    private InputSource in = new InputSource();
    protected final StringBuilder names = new StringBuilder();
    protected String insName;
    private static final String URI_XSD = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String SLOC = "schemaLocation";
    private static final String NSLOC = "noNamespaceSchemaLocation";

    public static void main(String[] stringArray) {
        int n = 0;
        if (n < stringArray.length && stringArray[n].equals("-v")) {
            VALIDATION = true;
            ++n;
        } else if (n < stringArray.length && stringArray[n].equals("-V")) {
            VALIDATION = false;
            ++n;
        }
        if (n < stringArray.length && stringArray[n].equals("-soap")) {
            SOAP = true;
            ++n;
        }
        TestAll testAll = new TestAll();
        testAll.runTests(stringArray, n);
    }

    public TestAll() {
        this.xsdParser.setContentHandler((ContentHandler)new SAX_HANDLER());
    }

    public void runTests(String[] stringArray, int n) {
        try {
            PrintWriter printWriter;
            Object object;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            for (int i = n; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-d")) {
                    if (++i == stringArray.length) {
                        this.usage();
                    }
                    string = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-vl")) {
                    this.list |= 1;
                    continue;
                }
                if (stringArray[i].equals("-il")) {
                    this.list |= 2;
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    if (++i == stringArray.length) {
                        this.usage();
                    }
                    string2 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-i")) {
                    if (++i == stringArray.length) {
                        this.usage();
                    }
                    string3 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-o")) {
                    if (++i == stringArray.length) {
                        this.usage();
                    }
                    string4 = stringArray[i];
                    this.toFile = true;
                    continue;
                }
                if (stringArray[i].equals("-e")) {
                    if (++i == stringArray.length) {
                        this.usage();
                    }
                    string5 = stringArray[i];
                    continue;
                }
                if (stringArray[i].equals("-t")) {
                    if (++i == stringArray.length) {
                        this.usage();
                    }
                    this.testDir = stringArray[i];
                    continue;
                }
                this.usage();
            }
            if (this.list == 0 && string2 == null && string3 == null) {
                this.list = 3;
            }
            if (string == null) {
                string = "";
            } else if (string.charAt(string.length() - 1) != '/') {
                string = string + '/';
            }
            ArrayList<String> arrayList = this.processExclude(string5);
            if (this.toFile) {
                object = new File(string4);
                FileWriter fileWriter = new FileWriter((File)object);
                printWriter = new PrintWriter(fileWriter);
            } else {
                printWriter = new PrintWriter(System.out);
            }
            if (string2 != null) {
                this.processFile(string2, true, printWriter, arrayList);
            }
            if (string3 != null) {
                this.processFile(string3, false, printWriter, arrayList);
            }
            if (this.list == 1 || this.list == 3) {
                object = string + FILE_V;
                this.processFile((String)object, true, printWriter, arrayList);
                object = string + FILE_V_E;
                this.processFile((String)object, true, printWriter, arrayList);
            }
            if (this.list == 2 || this.list == 3) {
                object = string + FILE_I;
                this.processFile((String)object, false, printWriter, arrayList);
                object = string + FILE_I_E;
                this.processFile((String)object, false, printWriter, arrayList);
            }
            if (this.toFile) {
                printWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList<String> processExclude(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private void processFile(String string, boolean bl, PrintWriter printWriter, ArrayList<String> arrayList) throws Exception {
        try {
            File file = new File(string);
            FileReader fileReader = new FileReader(file);
            printWriter.println();
            printWriter.println("# List: " + string);
            printWriter.println();
            this.processList(fileReader, bl, printWriter, arrayList);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private void processList(Reader reader, boolean bl, PrintWriter printWriter, ArrayList<String> arrayList) throws Exception {
        String string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() == 0 || string.charAt(0) == '#' || arrayList.contains(string)) continue;
            if (this.testDir != null) {
                string = this.testDir + string;
            }
            ++n;
            this.errorStr = null;
            schemaErr = false;
            if (TEST_ALL_DEBUG) {
                System.out.println(string);
            }
            try {
                this.loadGrammar(this.getXSDNames(string));
                this.in.setSystemId("file:///" + string);
                this.parseXML(this.in);
            }
            catch (Exception exception) {
                if (schemaErr) {
                    ++n4;
                    printWriter.println("# Invalid Schema: " + string);
                } else {
                    printWriter.println(string);
                    printWriter.println("# Reason: " + exception.getMessage());
                }
                if (!TEST_ALL_DEBUG) continue;
                exception.printStackTrace(System.err);
                continue;
            }
            if (schemaErr) {
                ++n4;
                printWriter.println("# Invalid Schema: " + string);
                continue;
            }
            if (bl && this.errorStr == null || !bl && this.errorStr != null) {
                ++n2;
            } else {
                printWriter.println(string);
                if (bl) {
                    printWriter.println("# Reason: " + this.errorStr);
                }
            }
            printWriter.flush();
        }
        printWriter.println();
        printWriter.println("# Result: total " + n + ", " + n2 + " passed, " + (n - n2 - n3 - n4) + " failed, " + n3 + " without schema, " + n4 + " invalid schema.");
        reader.close();
    }

    @Override
    protected XMLErrorHandler createXercesErrorHandler() {
        return new XMLErrorHandler(){

            public void warning(String string, String string2, XMLParseException xMLParseException) {
            }

            public void error(String string, String string2, XMLParseException xMLParseException) {
                if (TEST_ALL_DEBUG) {
                    System.err.println(xMLParseException.getMessage());
                }
                ParserBase.schemaErr = true;
            }

            public void fatalError(String string, String string2, XMLParseException xMLParseException) {
                if (TEST_ALL_DEBUG) {
                    System.err.println(xMLParseException.getMessage());
                }
                ParserBase.schemaErr = true;
            }
        };
    }

    @Override
    protected void printRecoverableError(String string, int n, int n2, XMLString[] xMLStringArray, long l) {
        if (string == "http://www.w3.org/2001/XMLSchema") {
            if (this.errorStr == null) {
                this.errorStr = super.generateErrorMessage(string, n, n2, xMLStringArray);
                if (TEST_ALL_DEBUG) {
                    System.err.println("# ERROR: " + this.errorStr);
                }
            }
        } else {
            super.printRecoverableError(string, n, n2, xMLStringArray, l);
        }
    }

    private String getXSDNames(String string) {
        this.insName = string;
        this.names.setLength(0);
        this.in.setSystemId(string);
        try {
            this.xsdParser.parse(this.in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.names.length() == 0) {
            int n = string.lastIndexOf(46);
            String string2 = string.substring(0, n) + ".xsd";
            if (!new File(string2).exists()) {
                n = string.lastIndexOf(46, n - 1);
                string2 = string.substring(0, n) + ".xsd";
            }
            if (new File(string2).exists()) {
                return string2;
            }
        }
        return this.names.toString();
    }

    private void usage() {
        System.err.println("Usage:");
        System.err.println("  java xs.parser.TestAll (-d dir | -vl | -il | -v file | -i file | -o file | -t dir)*");
        System.err.println("Meaning:");
        System.err.println("  -d dir:  the directory where the test list file is located");
        System.err.println("  -vl:     run the tests in the schema valid bucket");
        System.err.println("  -il:     run the tests in the instance invalid bucket");
        System.err.println("  -v file: run the schema valid tests listed in the specified file");
        System.err.println("  -i file: run the instance invalid tests listed in the specified file");
        System.err.println("  -o file: write the output to the specified file");
        System.err.println("  -t dir:  prepend dir to each test in a list");
        System.err.println("Defaults:");
        System.err.println("  -vl -il: run standard tests, write output to the console");
        System.err.println("Note:");
        System.err.println("  If \"-d\" option is not specified, the list files are searched in the working directory");
        System.err.println("  Please use the DOS format for file names on the command line");
        System.err.println("  Please use forward slash in the list files: d:/dir1/dir2/file.xml");
        System.err.println("  The output can easily be modified to be used as a list file");
        System.exit(-1);
    }

    @Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
    private final class SAX_HANDLER
    extends DefaultHandler {
        private SAX_HANDLER() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            Object object;
            String string4 = attributes.getValue(TestAll.URI_XSD, TestAll.SLOC);
            if (string4 != null) {
                object = new StringTokenizer(string4);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ((StringTokenizer)object).nextToken();
                    if (!((StringTokenizer)object).hasMoreTokens()) continue;
                    String string5 = ((StringTokenizer)object).nextToken();
                    if (!new File(string5).exists()) {
                        int n = TestAll.this.insName.lastIndexOf(47);
                        string5 = TestAll.this.insName.substring(0, n + 1) + string5;
                    }
                    if (!new File(string5).exists()) continue;
                    TestAll.this.names.append(' ');
                    TestAll.this.names.append(string5);
                }
            }
            if ((object = attributes.getValue(TestAll.URI_XSD, TestAll.NSLOC)) != null) {
                if (!new File((String)object).exists()) {
                    int n = TestAll.this.insName.lastIndexOf(47);
                    object = TestAll.this.insName.substring(0, n + 1) + (String)object;
                }
                if (new File((String)object).exists()) {
                    TestAll.this.names.append(' ');
                    TestAll.this.names.append((String)object);
                }
            }
        }
    }
}

