/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.MessageFactory;

public class EnumConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Enum";
    public static final String ENUM_ID = "javax.faces.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "javax.faces.converter.EnumConverter.ENUM_NO_CLASS";
    private Class<? extends Enum> targetClass;
    private boolean isTransient = false;

    public EnumConverter() {
    }

    public EnumConverter(Class targetClass) {
        this.targetClass = targetClass;
    }

    @Override
    public Object getAsObject(FacesContext context, UIComponent component, String value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.targetClass == null) {
            throw new ConverterException(MessageFactory.getMessage(context, ENUM_NO_CLASS_ID, value2, MessageFactory.getLabel(context, component)));
        }
        if (value2 == null) {
            return null;
        }
        if ((value2 = value2.trim()).length() < 1) {
            return null;
        }
        try {
            return Enum.valueOf(this.targetClass, value2);
        }
        catch (IllegalArgumentException iae) {
            throw new ConverterException(MessageFactory.getMessage(context, ENUM_ID, value2, value2, MessageFactory.getLabel(context, component)));
        }
    }

    @Override
    public String getAsString(FacesContext context, UIComponent component, Object value2) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (this.targetClass == null) {
            throw new ConverterException(MessageFactory.getMessage(context, ENUM_NO_CLASS_ID, value2, MessageFactory.getLabel(context, component)));
        }
        if (value2 == null) {
            return null;
        }
        if (this.targetClass.isInstance(value2)) {
            return value2.toString();
        }
        throw new ConverterException(MessageFactory.getMessage(context, ENUM_ID, value2, value2, MessageFactory.getLabel(context, component)));
    }

    @Override
    public void restoreState(FacesContext facesContext, Object object) {
        this.targetClass = (Class)object;
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        return this.targetClass;
    }

    @Override
    public void setTransient(boolean b) {
        this.isTransient = b;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }
}

