/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.converter;

import com.ibm.xml.xlxp.compiler.impl.idc.XPathAction;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathAttributeInfo;
import com.ibm.xml.xlxp.compiler.impl.idc.XPathDFA;
import com.ibm.xml.xlxp2.converter.SimpleTypeUtil;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.util.BitSet;
import com.ibm.xml.xlxp2.validation.idc.EndIDC;
import com.ibm.xml.xlxp2.validation.idc.QNameKey;
import com.ibm.xml.xlxp2.validation.idc.StartIDC;
import com.ibm.xml.xlxp2.validation.idc.XPathAttribute;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class IDCInstructionBuilder {
    private int fTypeOwnedAttrsSize;
    private int fFinalKeyUniqueStartActionsSize;
    private int fFinalMatchActionsSize;
    private int fFinalKeyrefStartActionsSize;
    private ArrayList<XPathAction> fKeyrefStartActions;
    private ArrayList<XPathAction> fKeyUniqueStartActions;
    private ArrayList<XPathAction> fMatchActions;
    private ArrayList<XPathAction> fKeyUniqueStartNilActions;
    private ArrayList<XPathAction> fKeyrefStartNilActions;
    private ArrayList<XPathAction> fMatchNilActions;
    private ArrayList<XPathAction> fEndActions;

    public IDCInstructionBuilder(int n) {
        this.fTypeOwnedAttrsSize = n;
    }

    public void addAction(XPathAction xPathAction) {
        if (xPathAction.action() == 1) {
            this.addStartAction(xPathAction);
        } else {
            this.addMatchAction(xPathAction);
        }
    }

    public void addEndAction(XPathAction xPathAction) {
        if (this.fEndActions == null) {
            this.fEndActions = new ArrayList();
        }
        this.fEndActions.add(xPathAction);
    }

    public void addNilAction(XPathAction xPathAction) {
        if (xPathAction.action() == 1) {
            this.addNilStartAction(xPathAction);
        } else {
            this.addNilMatchAction(xPathAction);
        }
    }

    public StartIDC createStartIDCInstruction(SimpleTypeUtil simpleTypeUtil, boolean bl) {
        if (bl) {
            return this.createStartIDCInstruction(simpleTypeUtil, this.fKeyrefStartNilActions, this.fKeyrefStartNilActions.size(), this.fKeyUniqueStartNilActions, this.fKeyUniqueStartNilActions.size(), this.fMatchNilActions, this.fMatchNilActions.size(), this.fTypeOwnedAttrsSize);
        }
        return this.createStartIDCInstruction(simpleTypeUtil, this.fKeyrefStartActions, this.fFinalKeyrefStartActionsSize, this.fKeyUniqueStartActions, this.fFinalKeyUniqueStartActionsSize, this.fMatchActions, this.fFinalMatchActionsSize, this.fTypeOwnedAttrsSize);
    }

    private StartIDC createStartIDCInstruction(SimpleTypeUtil simpleTypeUtil, List<XPathAction> list, int n, List<XPathAction> list2, int n2, List<XPathAction> list3, int n3, int n4) {
        StartIDC startIDC = new StartIDC();
        startIDC.startKeyrefActions = IDCInstructionBuilder.convertIDCActions(list, simpleTypeUtil, n4);
        startIDC.finalKeyrefStartSize = n;
        startIDC.startKeyOrUniqueActions = IDCInstructionBuilder.convertIDCActions(list2, simpleTypeUtil, n4);
        startIDC.finalKeyOrUniqueStartSize = n2;
        startIDC.matchActions = IDCInstructionBuilder.convertIDCActions(list3, simpleTypeUtil, n4);
        startIDC.finalMatchSize = n3;
        return startIDC;
    }

    public EndIDC createEndIDCInstruction() {
        return new EndIDC();
    }

    public boolean hasActions(boolean bl) {
        if (bl) {
            return this.fKeyUniqueStartNilActions != null || this.fKeyrefStartNilActions != null || this.fMatchNilActions != null;
        }
        return this.fKeyrefStartActions != null || this.fKeyUniqueStartActions != null || this.fMatchActions != null;
    }

    private void addStartAction(XPathAction xPathAction) {
        if (xPathAction.idcCategory() == 2) {
            this.addKeyrefStartAction(xPathAction);
        } else {
            this.addKeyUniqueStartAction(xPathAction);
        }
    }

    private void addKeyUniqueStartAction(XPathAction xPathAction) {
        if (this.fKeyUniqueStartActions == null) {
            this.fKeyUniqueStartActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalKeyUniqueStartActionsSize;
            if (this.fFinalKeyUniqueStartActionsSize <= this.fKeyUniqueStartActions.size()) {
                this.fKeyUniqueStartActions.add(this.fFinalKeyUniqueStartActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fKeyUniqueStartActions.add(xPathAction);
    }

    private void addKeyrefStartAction(XPathAction xPathAction) {
        if (this.fKeyrefStartActions == null) {
            this.fKeyrefStartActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalKeyrefStartActionsSize;
            if (this.fFinalKeyrefStartActionsSize <= this.fKeyrefStartActions.size()) {
                this.fKeyrefStartActions.add(this.fFinalKeyrefStartActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fKeyrefStartActions.add(xPathAction);
    }

    private void addMatchAction(XPathAction xPathAction) {
        if (this.fMatchActions == null) {
            this.fMatchActions = new ArrayList();
        }
        if (xPathAction.isNewStateFinal()) {
            ++this.fFinalMatchActionsSize;
            if (this.fFinalMatchActionsSize <= this.fMatchActions.size()) {
                this.fMatchActions.add(this.fFinalMatchActionsSize - 1, xPathAction);
                return;
            }
        }
        this.fMatchActions.add(xPathAction);
    }

    private void addNilStartAction(XPathAction xPathAction) {
        if (xPathAction.idcCategory() == 2) {
            this.addNilKeyrefAction(xPathAction);
        } else {
            this.addNilKeyUniqueAction(xPathAction);
        }
    }

    private void addNilKeyrefAction(XPathAction xPathAction) {
        if (this.fKeyrefStartNilActions == null) {
            this.fKeyrefStartNilActions = new ArrayList();
        }
        this.fKeyrefStartNilActions.add(xPathAction);
    }

    private void addNilKeyUniqueAction(XPathAction xPathAction) {
        if (this.fKeyUniqueStartNilActions == null) {
            this.fKeyUniqueStartNilActions = new ArrayList();
        }
        this.fKeyUniqueStartNilActions.add(xPathAction);
    }

    private void addNilMatchAction(XPathAction xPathAction) {
        if (this.fMatchNilActions == null) {
            this.fMatchNilActions = new ArrayList();
        }
        this.fMatchNilActions.add(xPathAction);
    }

    static com.ibm.xml.xlxp2.validation.idc.XPathDFA[] createXPathDFAs(List list, SimpleTypeUtil simpleTypeUtil, int n) {
        int n2 = list.size();
        com.ibm.xml.xlxp2.validation.idc.XPathDFA[] xPathDFAArray = new com.ibm.xml.xlxp2.validation.idc.XPathDFA[n2];
        for (int i = 0; i < n2; ++i) {
            XPathAttributeInfo[][] xPathAttributeInfoArray;
            int n3;
            XPathDFA xPathDFA = (XPathDFA)list.get(i);
            com.ibm.xml.xlxp2.validation.idc.XPathDFA xPathDFA2 = new com.ibm.xml.xlxp2.validation.idc.XPathDFA();
            xPathDFA2.idcID = xPathDFA.idcId();
            xPathDFA2.xpathID = xPathDFA.id();
            xPathDFA2.isSelector = xPathDFA2.xpathID < n;
            xPathDFA2.transitionTable = xPathDFA.transitionTable();
            String[] stringArray = xPathDFA.transitionSymbols();
            if (stringArray != null && stringArray.length > 0) {
                int n4 = stringArray.length / 2;
                xPathDFA2.transitionSymbols = new QNameKey[n4];
                for (n3 = 0; n3 < n4; ++n3) {
                    String string = stringArray[n3 * 2];
                    String string2 = stringArray[n3 * 2 + 1];
                    string = string != null ? simpleTypeUtil.internString(string) : null;
                    string2 = string2 != null ? simpleTypeUtil.internString(string2) : null;
                    xPathDFA2.transitionSymbols[n3] = new QNameKey();
                    xPathDFA2.transitionSymbols[n3].fill(string, string2);
                }
            }
            int n5 = n3 = (xPathAttributeInfoArray = xPathDFA.finalAttrDecls()) == null ? 0 : xPathAttributeInfoArray.length;
            if (n3 > 0) {
                xPathDFA2.finalAttrDecls = new XPathAttribute[n3][];
            }
            for (int j = 0; j < n3; ++j) {
                int n6;
                int n7 = n6 = xPathAttributeInfoArray[j] == null ? 0 : xPathAttributeInfoArray[j].length;
                if (n6 > 0) {
                    xPathDFA2.finalAttrDecls[j] = new XPathAttribute[n6];
                }
                for (int k = 0; k < n6; ++k) {
                    String string = xPathAttributeInfoArray[j][k].namespace();
                    String string3 = xPathAttributeInfoArray[j][k].name();
                    xPathDFA2.finalAttrDecls[j][k] = new XPathAttribute();
                    string = string != null ? simpleTypeUtil.internString(string) : null;
                    string3 = string3 != null ? simpleTypeUtil.internString(string3) : null;
                    xPathDFA2.finalAttrDecls[j][k].nsURI = string;
                    xPathDFA2.finalAttrDecls[j][k].localName = string3;
                    xPathDFA2.finalAttrDecls[j][k].index = xPathAttributeInfoArray[j][k].index();
                }
            }
            xPathDFA2.allowMoreInput = xPathDFA.allowMoreInput();
            xPathDFA2.startFieldActions = IDCInstructionBuilder.convertIDCActions(xPathDFA.startFieldActions(), simpleTypeUtil, 0);
            xPathDFA2.finalFieldsStartSize = xPathDFA.finalFieldsStartSize();
            xPathDFAArray[i] = xPathDFA2;
        }
        return xPathDFAArray;
    }

    private static com.ibm.xml.xlxp2.validation.idc.XPathAction[] convertIDCActions(List list, SimpleTypeUtil simpleTypeUtil, int n) {
        if (list == null || list.size() == 0) {
            return null;
        }
        com.ibm.xml.xlxp2.validation.idc.XPathAction[] xPathActionArray = new com.ibm.xml.xlxp2.validation.idc.XPathAction[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            XPathAction xPathAction = (XPathAction)list.get(i);
            com.ibm.xml.xlxp2.validation.idc.XPathAction xPathAction2 = new com.ibm.xml.xlxp2.validation.idc.XPathAction();
            xPathAction2.isSelector = xPathAction.isSelector();
            xPathAction2.xpathID = xPathAction.xpathId();
            xPathAction2.oldState = xPathAction.oldState();
            xPathAction2.newState = xPathAction.newState();
            xPathAction2.isNewStateFinal = xPathAction.isNewStateFinal();
            xPathAction2.allowMoreInput = xPathAction.allowMoreInput();
            xPathAction2.idcID = xPathAction.idcId();
            xPathAction2.idcCategory = xPathAction.idcCategory();
            xPathAction2.idcID4Key = xPathAction.idcId4Key();
            xPathAction2.fieldIndex = xPathAction.fieldIndex();
            xPathAction2.fieldCount = xPathAction.fieldCount();
            XPathAttributeInfo[] xPathAttributeInfoArray = xPathAction.attributes();
            int n3 = n2 = xPathAttributeInfoArray == null ? 0 : xPathAttributeInfoArray.length;
            if (n2 > 0) {
                int n4;
                boolean bl = true;
                if (n <= 0) {
                    bl = false;
                } else {
                    for (n4 = 0; n4 < n2; ++n4) {
                        if (xPathAttributeInfoArray[n4].index() > 0) continue;
                        bl = false;
                    }
                }
                xPathAction2.finalAttrDecls = new XPathAttribute[n2];
                if (bl) {
                    xPathAction2.finalAttrs = new BitSet(n);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    String string = xPathAttributeInfoArray[n4].namespace();
                    String string2 = xPathAttributeInfoArray[n4].name();
                    xPathAction2.finalAttrDecls[n4] = new XPathAttribute();
                    xPathAction2.finalAttrDecls[n4].nsURI = string != null ? simpleTypeUtil.internString(string) : null;
                    xPathAction2.finalAttrDecls[n4].localName = string2 != null ? simpleTypeUtil.internString(string2) : null;
                    xPathAction2.finalAttrDecls[n4].index = xPathAttributeInfoArray[n4].index();
                    if (!bl) continue;
                    xPathAction2.finalAttrs.setBit(xPathAttributeInfoArray[n4].index());
                }
            }
            xPathAction2.startFieldActions = IDCInstructionBuilder.convertIDCActions(xPathAction.startFieldActions(), simpleTypeUtil, n);
            xPathAction2.finalFieldsStartSize = xPathAction.startFieldActionsFinalSize();
            xPathAction2.depthIncrement = 1;
            xPathActionArray[i] = xPathAction2;
        }
        return xPathActionArray;
    }
}

