/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public abstract class UCSEncodingSupport
implements EncodingSupport {
    public static final int UTF_16 = 0;
    public static final int UTF_16BE = 1;
    public static final int UTF_16LE = 2;
    public static final int UTF_32BE = 3;
    public static final int UTF_32LE = 4;
    private static final int ENCODINGS_COUNT = 5;
    private static EncodingSupport[] fgSingletons;

    public static EncodingSupport getInstance(int n) {
        if (n < 0 || n > 5) {
            return null;
        }
        if (fgSingletons == null) {
            fgSingletons = ArrayAllocator.newObjectArray(EncodingSupport.class, 5);
        } else if (fgSingletons[n] != null) {
            return fgSingletons[n];
        }
        switch (n) {
            case 0: {
                UCSEncodingSupport.fgSingletons[n] = new UTF16();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 1: {
                UCSEncodingSupport.fgSingletons[n] = new UTF16BE();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 2: {
                UCSEncodingSupport.fgSingletons[n] = new UTF16LE();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 3: {
                UCSEncodingSupport.fgSingletons[n] = new UTF32BE();
                return UCSEncodingSupport.fgSingletons[n];
            }
            case 4: {
                UCSEncodingSupport.fgSingletons[n] = new UTF32LE();
                return UCSEncodingSupport.fgSingletons[n];
            }
        }
        return null;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        return byteStreamDataSource.load(parsedEntity);
    }

    protected UCSEncodingSupport() {
    }

    static final class UTF32LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n3 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n4 = 0;
                if (byteStreamDataSource.stream != null && n3 < byteStreamDataSource.readLength && (n4 = byteStreamDataSource.stream.read(byArray2, n3, byteStreamDataSource.readLength - n3)) == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (n3 == 0) {
                        byteStreamDataSource.readOffset = n3;
                        dataBuffer.endOffset = n2;
                        return null;
                    }
                    n4 = 0;
                }
                n4 += n3;
                n3 = 0;
                while (n3 + 3 < n4 && n2 < n) {
                    int n5;
                    int n6;
                    int n7 = byArray2[n3++] & 0xFF;
                    int n8 = byArray2[n3++] & 0xFF;
                    int n9 = byArray2[n3++] & 0xFF;
                    if ((n6 = byArray2[n3++] & 0xFF) == 0 && n9 == 0) {
                        if (n8 == 0 && n7 < 128) {
                            if (n7 != 13) {
                                byArray[n2++] = (byte)n7;
                                continue;
                            }
                            if (n3 + 3 < n4) {
                                byArray[n2++] = 10;
                                n7 = byArray2[n3++] & 0xFF;
                                n8 = byArray2[n3++] & 0xFF;
                                n9 = byArray2[n3++] & 0xFF;
                                if ((n6 = byArray2[n3++] & 0xFF) == 0 && n9 == 0 && n8 == 0 && (n7 == 10 || !bl && n7 == 133)) continue;
                                n3 -= 4;
                                continue;
                            }
                            if (byteStreamDataSource.stream == null) {
                                byArray[n2++] = 10;
                                break;
                            }
                            n3 -= 4;
                            break;
                        }
                        n5 = (n8 << 8) + n7;
                        if (!(bl || n5 != 133 && n5 != 8232)) {
                            byArray[n2++] = 10;
                            continue;
                        }
                        if (n5 < 2048) {
                            if (n2 + 1 < n) {
                                byArray[n2++] = (byte)(0xC0 | n5 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n5);
                                continue;
                            }
                            n3 -= 4;
                            break;
                        }
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n5 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n5 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n5);
                            continue;
                        }
                        n3 -= 4;
                        break;
                    }
                    if (n2 + 3 < n) {
                        n5 = (n6 << 24) + (n9 << 16) + (n8 << 8) + n7;
                        byArray[n2++] = (byte)(0xF0 | n5 >> 18);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n5 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n5 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n5);
                        continue;
                    }
                    n3 -= 4;
                    break;
                }
                if (n3 < n4) {
                    System.arraycopy(byArray2, n3, byArray2, 0, n4 -= n3);
                    n3 = n4;
                } else {
                    n3 = 0;
                }
                byteStreamDataSource.readOffset = n3;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    static final class UTF32BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n3 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n4 = 0;
                if (byteStreamDataSource.stream != null && n3 < byteStreamDataSource.readLength && (n4 = byteStreamDataSource.stream.read(byArray2, n3, byteStreamDataSource.readLength - n3)) == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (n3 == 0) {
                        byteStreamDataSource.readOffset = n3;
                        dataBuffer.endOffset = n2;
                        return null;
                    }
                    n4 = 0;
                }
                n4 += n3;
                n3 = 0;
                while (n3 + 3 < n4 && n2 < n) {
                    int n5;
                    int n6 = byArray2[n3++] & 0xFF;
                    int n7 = byArray2[n3++] & 0xFF;
                    int n8 = byArray2[n3++] & 0xFF;
                    int n9 = byArray2[n3++] & 0xFF;
                    if (n6 == 0 && n7 == 0) {
                        if (n8 == 0 && n9 < 128) {
                            if (n9 != 13) {
                                byArray[n2++] = (byte)n9;
                                continue;
                            }
                            if (n3 + 3 < n4) {
                                byArray[n2++] = 10;
                                n6 = byArray2[n3++] & 0xFF;
                                n7 = byArray2[n3++] & 0xFF;
                                n8 = byArray2[n3++] & 0xFF;
                                n9 = byArray2[n3++] & 0xFF;
                                if (n6 == 0 && n7 == 0 && n8 == 0 && (n9 == 10 || !bl && n9 == 133)) continue;
                                n3 -= 4;
                                continue;
                            }
                            if (byteStreamDataSource.stream == null) {
                                byArray[n2++] = 10;
                                break;
                            }
                            n3 -= 4;
                            break;
                        }
                        n5 = (n8 << 8) + n9;
                        if (!(bl || n5 != 133 && n5 != 8232)) {
                            byArray[n2++] = 10;
                            continue;
                        }
                        if (n5 < 2048) {
                            if (n2 + 1 < n) {
                                byArray[n2++] = (byte)(0xC0 | n5 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n5);
                                continue;
                            }
                            n3 -= 4;
                            break;
                        }
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n5 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n5 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n5);
                            continue;
                        }
                        n3 -= 4;
                        break;
                    }
                    if (n2 + 3 < n) {
                        n5 = (n6 << 24) + (n7 << 16) + (n8 << 8) + n9;
                        byArray[n2++] = (byte)(0xF0 | n5 >> 18);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n5 >> 12);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n5 >> 6);
                        byArray[n2++] = (byte)(0x80 | 0x3F & n5);
                        continue;
                    }
                    n3 -= 4;
                    break;
                }
                if (n3 < n4) {
                    System.arraycopy(byArray2, n3, byArray2, 0, n4 -= n3);
                    n3 = n4;
                } else {
                    n3 = 0;
                }
                byteStreamDataSource.readOffset = n3;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    static final class UTF16LE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n3 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n4 = 0;
                if (byteStreamDataSource.stream != null && n3 < byteStreamDataSource.readLength && (n4 = byteStreamDataSource.stream.read(byArray2, n3, byteStreamDataSource.readLength - n3)) == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (n3 == 0) {
                        byteStreamDataSource.readOffset = n3;
                        dataBuffer.endOffset = n2;
                        return null;
                    }
                    n4 = 0;
                }
                n4 += n3;
                n3 = 0;
                while (n3 + 1 < n4 && n2 < n) {
                    int n5;
                    int n6 = byArray2[n3++] & 0xFF;
                    if ((n5 = byArray2[n3++] & 0xFF) == 0 && n6 < 128) {
                        if (n6 != 13) {
                            byArray[n2++] = (byte)n6;
                            continue;
                        }
                        if (n3 + 1 < n4) {
                            byArray[n2++] = 10;
                            n6 = byArray2[n3++] & 0xFF;
                            if ((n5 = byArray2[n3++] & 0xFF) == 0 && (n6 == 10 || !bl && n6 == 133)) continue;
                            n3 -= 2;
                            continue;
                        }
                        if (byteStreamDataSource.stream == null) {
                            byArray[n2++] = 10;
                            break;
                        }
                        n3 -= 2;
                        break;
                    }
                    int n7 = (n5 << 8) + n6;
                    if (!(bl || n7 != 133 && n7 != 8232)) {
                        byArray[n2++] = 10;
                        continue;
                    }
                    if (n7 < 2048) {
                        if (n2 + 1 < n) {
                            byArray[n2++] = (byte)(0xC0 | n7 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n7);
                            continue;
                        }
                        n3 -= 2;
                        break;
                    }
                    if (n7 < 55296 || n7 >= 57344) {
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n7 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n7 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n7);
                            continue;
                        }
                        n3 -= 2;
                        break;
                    }
                    if (n7 < 56320) {
                        if (n3 < n4 && n2 + 3 < n) {
                            int n8;
                            if ((n8 = ((n5 = byArray2[n3++] & 0xFF) << 8) + (n6 = byArray2[n3++] & 0xFF)) >= 56320 && n8 < 57344) {
                                n7 = 65536 + (n7 - 55296 << 10) + (n8 - 56320);
                                byArray[n2++] = (byte)(0xF0 | n7 >> 18);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n7 >> 12);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n7 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n7);
                                continue;
                            }
                            return CharConversionError.invalidSecondHalfOfSurrogatePair();
                        }
                        n3 -= 2;
                        break;
                    }
                    return CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
                if (n3 < n4) {
                    System.arraycopy(byArray2, n3, byArray2, 0, n4 -= n3);
                    n3 = n4;
                } else {
                    n3 = 0;
                }
                byteStreamDataSource.readOffset = n3;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    static final class UTF16BE
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            byte[] byArray = dataBuffer.bytes;
            int n = dataBuffer.endOffset;
            int n2 = 0;
            try {
                int n3;
                byte[] byArray2 = byteStreamDataSource.readBuffer;
                int n4 = byteStreamDataSource.readOffset;
                boolean bl = byteStreamDataSource.isXML10;
                int n5 = 0;
                if (byteStreamDataSource.stream != null && n4 < byteStreamDataSource.readLength) {
                    n3 = byteStreamDataSource.stream.read(byArray2, n4, byteStreamDataSource.readLength - n4);
                    if (n3 == -1) {
                        byteStreamDataSource.stream.close();
                        byteStreamDataSource.stream = null;
                        if (n4 == 0) {
                            byteStreamDataSource.readOffset = n4;
                            dataBuffer.endOffset = n2;
                            return null;
                        }
                    } else {
                        n5 = n3;
                    }
                }
                n5 += n4;
                n4 = 0;
                while (n4 + 1 < n5 && n2 < n) {
                    n3 = byArray2[n4++] & 0xFF;
                    int n6 = byArray2[n4++] & 0xFF;
                    if (n3 == 0 && n6 < 128) {
                        if (n6 != 13) {
                            byArray[n2++] = (byte)n6;
                            continue;
                        }
                        if (n4 + 1 < n5) {
                            byArray[n2++] = 10;
                            n3 = byArray2[n4++] & 0xFF;
                            n6 = byArray2[n4++] & 0xFF;
                            if (n3 == 0 && (n6 == 10 || !bl && n6 == 133)) continue;
                            n4 -= 2;
                            continue;
                        }
                        if (byteStreamDataSource.stream == null) {
                            byArray[n2++] = 10;
                            break;
                        }
                        n4 -= 2;
                        break;
                    }
                    int n7 = (n3 << 8) + n6;
                    if (!(bl || n7 != 133 && n7 != 8232)) {
                        byArray[n2++] = 10;
                        continue;
                    }
                    if (n7 < 2048) {
                        if (n2 + 1 < n) {
                            byArray[n2++] = (byte)(0xC0 | n7 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n7);
                            continue;
                        }
                        n4 -= 2;
                        break;
                    }
                    if (n7 < 55296 || n7 >= 57344) {
                        if (n2 + 2 < n) {
                            byArray[n2++] = (byte)(0xE0 | n7 >> 12);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n7 >> 6);
                            byArray[n2++] = (byte)(0x80 | 0x3F & n7);
                            continue;
                        }
                        n4 -= 2;
                        break;
                    }
                    if (n7 < 56320) {
                        if (n4 < n5 && n2 + 3 < n) {
                            int n8;
                            if ((n8 = ((n3 = byArray2[n4++] & 0xFF) << 8) + (n6 = byArray2[n4++] & 0xFF)) >= 56320 && n8 < 57344) {
                                n7 = 65536 + (n7 - 55296 << 10) + (n8 - 56320);
                                byArray[n2++] = (byte)(0xF0 | n7 >> 18);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n7 >> 12);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n7 >> 6);
                                byArray[n2++] = (byte)(0x80 | 0x3F & n7);
                                continue;
                            }
                            byteStreamDataSource.readOffset = n4 - 2;
                            return CharConversionError.invalidSecondHalfOfSurrogatePair();
                        }
                        n4 -= 2;
                        break;
                    }
                    byteStreamDataSource.readOffset = n4 - 2;
                    return CharConversionError.invalidFirstHalfOfSurrogatePair();
                }
                if (n4 < n5) {
                    System.arraycopy(byArray2, n4, byArray2, 0, n5 -= n4);
                    n4 = n5;
                } else {
                    n4 = 0;
                }
                byteStreamDataSource.readOffset = n4;
                dataBuffer.endOffset = n2;
                return null;
            }
            catch (IOException iOException) {
                return CharConversionError.runtimeIOError(iOException);
            }
        }
    }

    static final class UTF16
    extends UCSEncodingSupport {
        public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
            return CharConversionError.inconsistentEncoding();
        }
    }
}

