/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.util.encoding;

import com.ibm.xml.xlxp2.api.util.encoding.ByteStreamDataSource;
import com.ibm.xml.xlxp2.api.util.encoding.EncodingSupport;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.CharConversionError;
import com.ibm.xml.xlxp2.scan.util.DataBuffer;
import com.ibm.xml.xlxp2.scan.util.ParsedEntity;
import java.io.IOException;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2002, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
final class ASCIIEncodingSupport
implements EncodingSupport {
    private static EncodingSupport fgSingleton = new ASCIIEncodingSupport();

    public static EncodingSupport getInstance() {
        return fgSingleton;
    }

    public CharConversionError loadFromByteStream(ParsedEntity parsedEntity, ByteStreamDataSource byteStreamDataSource) {
        byteStreamDataSource.setEncodingSupport(this);
        byteStreamDataSource.createReadBuffer();
        return byteStreamDataSource.load(parsedEntity);
    }

    public CharConversionError load(ByteStreamDataSource byteStreamDataSource, DataBuffer dataBuffer) {
        byte[] byArray = dataBuffer.bytes;
        int n = dataBuffer.endOffset;
        int n2 = byteStreamDataSource.readOffset;
        int n3 = 0;
        try {
            boolean bl;
            int n4;
            int n5;
            if (byteStreamDataSource.stream != null && (n2 == 0 || n2 < n && byteStreamDataSource.stream.available() > 0)) {
                n5 = byteStreamDataSource.stream.read(byArray, n2, n - n2);
                if (n5 == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    if (n2 == 0) {
                        byteStreamDataSource.readOffset = 0;
                        dataBuffer.endOffset = n3;
                        return null;
                    }
                    n4 = 0;
                } else {
                    n4 = n5;
                }
                bl = true;
            } else {
                n4 = 0;
                bl = false;
            }
            n3 = this.normalizeLineBreaks(byArray, 0, n4 += n2, byteStreamDataSource);
            if (byteStreamDataSource.readOffset == -1) {
                byteStreamDataSource.readOffset = 0;
                dataBuffer.endOffset = n3;
                return CharConversionError.unableToConvertOutOfRangeUnicodeCharacter();
            }
            if (byteStreamDataSource.readOffset < n4) {
                n2 = byteStreamDataSource.readOffset;
                byteStreamDataSource.readOffset = n4 - n2;
                System.arraycopy(byArray, n2, byteStreamDataSource.readBuffer, 0, byteStreamDataSource.readOffset);
                byteStreamDataSource.createReadBuffer();
            } else if (n4 < n && byteStreamDataSource.stream != null && !bl && byteStreamDataSource.stream.available() > 0) {
                n5 = byteStreamDataSource.stream.read();
                if (n5 == -1) {
                    byteStreamDataSource.stream.close();
                    byteStreamDataSource.stream = null;
                    byteStreamDataSource.readOffset = 0;
                } else {
                    byteStreamDataSource.readBuffer[0] = (byte)n5;
                    byteStreamDataSource.readOffset = 1;
                }
            } else {
                byteStreamDataSource.readOffset = 0;
            }
            dataBuffer.endOffset = n3;
            return null;
        }
        catch (IOException iOException) {
            return CharConversionError.runtimeIOError(iOException);
        }
    }

    private ASCIIEncodingSupport() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public int normalizeLineBreaks(byte[] byArray, int n, int n2, ByteStreamDataSource byteStreamDataSource) {
        byte by;
        int n3 = n;
        int n4 = 0;
        byArray[n2] = 13;
        while ((by = byArray[n3]) >= 0 && by != 13) {
            ++n3;
        }
        if (n3 == n2) {
            byteStreamDataSource.readOffset = n3;
            byArray[n2] = 0;
            return n3;
        }
        n4 = n3;
        while (true) {
            if (by < 0) {
                byteStreamDataSource.readOffset = -1;
                byArray[n2] = 0;
                return n4;
            }
            if (++n3 < n2) {
                if ((by = byArray[n3++]) != 10) {
                    --n3;
                }
                byArray[n4++] = 10;
                by = byArray[n3];
                if (by < 0) continue;
            } else {
                if (n3 <= n2 && byteStreamDataSource.stream == null) {
                    byArray[n4++] = 10;
                    break;
                }
                --n3;
                break;
            }
            if (by == 13) continue;
            int n5 = n3++;
            while ((by = byArray[n3]) >= 0 && by != 13) {
                ++n3;
            }
            if (n5 != n4) {
                System.arraycopy(byArray, n5, byArray, n4, n3 - n5);
            }
            n4 += n3 - n5;
        }
        byteStreamDataSource.readOffset = n3;
        byArray[n2] = 0;
        return n4;
    }
}

