/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax.serializer;

import com.ibm.xml.xlxp2.api.util.Pool;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
abstract class StAXWriter
extends Writer
implements Pool.Poolable {
    protected OutputStream fStream;
    protected int fNumBytes;
    protected final byte[] fBuffer = ArrayAllocator.newByteArray(65536);
    protected Pool.PoolableHelper fPoolableHelper;
    protected char[] fCharBuffer = ArrayAllocator.newCharArray(128);

    public StAXWriter() {
        this.fPoolableHelper = new Pool.PoolableHelper(this);
    }

    public Pool.PoolableHelper getPoolableHelper() {
        return this.fPoolableHelper;
    }

    public void reset(OutputStream outputStream) {
        this.fNumBytes = 0;
        this.fStream = outputStream;
    }

    public void write(String string) throws IOException {
        int n = string.length();
        if (this.fCharBuffer.length < n) {
            int n2;
            for (n2 = this.fCharBuffer.length << 1; n2 < n; n2 <<= 1) {
            }
            this.fCharBuffer = ArrayAllocator.replaceCharArray(this.fCharBuffer, n2);
        }
        string.getChars(0, n, this.fCharBuffer, 0);
        this.write(this.fCharBuffer, 0, n);
    }

    protected void flushInternal() throws IOException {
        this.fStream.write(this.fBuffer, 0, this.fNumBytes);
        this.fNumBytes = 0;
    }

    public void flush() throws IOException {
        this.flushInternal();
        this.fStream.flush();
    }

    public void close() throws IOException {
        this.fStream = null;
        this.release();
    }

    protected void release() {
        this.fPoolableHelper.returnToPool();
    }
}

