/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp2.api.stax;

import com.ibm.xml.xlxp2.api.stax.msg.StAXMessageProvider;
import com.ibm.xml.xlxp2.scan.Copyright;
import com.ibm.xml.xlxp2.scan.util.ArrayAllocator;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Copyright(value="Licensed Materials - Property of IBM\nXL XML Processor for Java (XLXP-J) - Part of various IBM products\n\u00a9 Copyright IBM Corp. 2006, 2008. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.")
public class JavaXNamespaceContext
implements NamespaceContext {
    private static final String XML_PREFIX = "xml".intern();
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace".intern();
    private static final String XMLNS_PREFIX = "xmlns".intern();
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/".intern();
    protected String[] fMapping = ArrayAllocator.newStringArray(32);
    protected int fMappingSize = 0;
    protected int[] fScopes = ArrayAllocator.newIntArray(8);
    protected int fScope = 0;

    public JavaXNamespaceContext() {
        this.fMapping[this.fMappingSize++] = XML_PREFIX;
        this.fMapping[this.fMappingSize++] = XML_NS;
        this.fMapping[this.fMappingSize++] = XMLNS_PREFIX;
        this.fMapping[this.fMappingSize++] = XMLNS_NS;
    }

    public JavaXNamespaceContext(JavaXNamespaceContext javaXNamespaceContext, boolean bl) {
        this.fMappingSize = javaXNamespaceContext.fMappingSize;
        if (bl) {
            this.fMapping = ArrayAllocator.copyStringArray(javaXNamespaceContext.fMapping);
            this.fScope = javaXNamespaceContext.fScope;
            this.fScopes = ArrayAllocator.copyIntArray(javaXNamespaceContext.fScopes);
        } else {
            this.fMapping = ArrayAllocator.newStringArray(this.fMappingSize);
            System.arraycopy(javaXNamespaceContext.fMapping, 0, this.fMapping, 0, this.fMappingSize);
        }
    }

    public void reset() {
        this.fMappingSize = 4;
        this.fScope = 0;
    }

    public int getNamespaceCount() {
        return (this.fMappingSize - this.fScopes[this.fScope]) / 2;
    }

    public String getNamespacePrefix(int n) throws IndexOutOfBoundsException {
        if ((n = this.fMappingSize - n * 2 - 2) < this.fScopes[this.fScope] || n >= this.fMappingSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.fMapping[n];
    }

    public String getNamespaceURI(int n) {
        if ((n = this.fMappingSize - n * 2 - 1) < this.fScopes[this.fScope] || n >= this.fMappingSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.fMapping[n];
    }

    public void startScope() {
        ++this.fScope;
        if (this.fScope == this.fScopes.length) {
            this.fScopes = ArrayAllocator.resizeIntArray(this.fScopes, this.fScope << 1);
        }
        this.fScopes[this.fScope] = this.fMappingSize;
    }

    public void endScope() {
        this.fMappingSize = this.fScopes[this.fScope--];
    }

    public void declareNamespace(String string, String string2) {
        if (this.fMappingSize == this.fMapping.length) {
            this.fMapping = ArrayAllocator.resizeStringArray(this.fMapping, this.fMappingSize << 1);
        }
        if (string == null) {
            string = "";
        }
        string = string.intern();
        if (string2 != null) {
            string2 = string2.intern();
        }
        this.fMapping[this.fMappingSize++] = string;
        this.fMapping[this.fMappingSize++] = string2;
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
        }
        string = string.intern();
        for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
            if (this.fMapping[i] != string) continue;
            return this.fMapping[i + 1];
        }
        return null;
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
        } else {
            string = string.intern();
        }
        for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
            if (this.fMapping[i + 1] != string || this.getNamespaceURI(this.fMapping[i]) != string) continue;
            return this.fMapping[i];
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
        } else {
            string = string.intern();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = this.fMappingSize - 2; i >= 0; i -= 2) {
            if (this.fMapping[i + 1] != string || this.getNamespaceURI(this.fMapping[i]) != string) continue;
            hashSet.add(this.fMapping[i]);
        }
        return hashSet.iterator();
    }
}

