/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdUtil
implements IDResolver {
    private static final TraceComponent tc = Tr.register(IdUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = IdUtil.class.getName();
    private static final String NS_XHTML = "http://www.w3.org/1999/xhtml";
    private static final String[][] KNOWN_IDATTRS = new String[][]{{Constants.NS_WSSE, "*", "Id"}, {Constants.NS_WSSE200207, "*", "Id"}, {Constants.NS_WSSE200204, "*", "Id"}, {Constants.NS_DSIG, "*", "Id"}, {Constants.NS_ENC, "*", "Id"}, {"http://www.w3.org/1999/xhtml", "*", "id"}};
    private static final String[][] KNOWN_GLOBAL_IDATTRS = new String[][]{{Constants.NS_WSU, "Id"}, {Constants.NS_WSU200207, "Id"}};
    private static Random randomgen = new Random();
    private static IdUtil instance = new IdUtil();
    protected String[][] known_idattrs = KNOWN_IDATTRS;
    protected String[][] known_global_idattrs = KNOWN_GLOBAL_IDATTRS;
    private static long id = 0L;

    protected IdUtil() {
    }

    public static IdUtil getInstance() {
        return instance;
    }

    public String getIdAttributeName(Element element) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIdAttributeName(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        String ret = null;
        String ns = element.getNamespaceURI();
        String local = element.getLocalName();
        for (i = 0; i < this.known_idattrs.length; ++i) {
            if (!this.known_idattrs[i][0].equals(ns) || !"*".equals(this.known_idattrs[i][1]) && !this.known_idattrs[i][1].equals(local) || !element.hasAttribute(this.known_idattrs[i][2])) continue;
            ret = this.known_idattrs[i][2];
            break;
        }
        for (i = 0; i < this.known_global_idattrs.length; ++i) {
            Attr a = element.getAttributeNodeNS(this.known_global_idattrs[i][0], this.known_global_idattrs[i][1]);
            if (a == null) continue;
            ret = a.getNodeName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIdAttributeName(Element element) returns String[" + ret + "]");
        }
        return ret;
    }

    private boolean matchId(Element element, String id, boolean onlyWsu) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchId(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String id[" + id + "]," + "boolean onlyWsu[" + onlyWsu + "])");
        }
        boolean ret = false;
        if (onlyWsu) {
            ret = id.equals(NamespaceUtil.getWsuAttribute(element, "Id"));
        } else {
            String idattr = this.getIdAttributeName(element);
            boolean bl = ret = idattr != null && id.equals(element.getAttribute(idattr));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchId(Element element,String id,boolean onlyWsu) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public String makeUniqueId(Document doc, String base) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeUniqueId(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String base[" + base + "])");
        }
        String ret = base + id++;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeUniqueId(Document doc,String base) returns String[" + ret + "]");
        }
        return ret;
    }

    public void checkIdUniqueness(Document doc) throws SoapSecurityException {
        Element e;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIdUniqueness(Document doc[" + DOMUtil.getDisplayName(doc) + "])");
        }
        if (doc != null && (e = doc.getDocumentElement()) != null) {
            HashSet ids = new HashSet();
            IdUtil.checkIdUniqueness(e, ids);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIdUniqueness(Document doc)");
        }
    }

    private static void checkIdUniqueness(Node node, Set ids) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIdUniqueness(Node node[" + DOMUtil.getDisplayName(node) + "]," + "Set ids[" + ids + "])");
        }
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            String s = IdUtil.getInstance().getIdAttributeName(e);
            if (s != null) {
                String id = e.getAttribute(s);
                if (ids.contains(id)) {
                    throw SoapSecurityException.format((String)"security.wssecurity.IdUtil.s01", (String)id);
                }
                ids.add(id);
            }
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1 && n.getNodeType() != 5) continue;
            IdUtil.checkIdUniqueness(n, ids);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIdUniqueness(Node node,Set ids)");
        }
    }

    public Element resolveID(Document doc, String id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveID(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String id[" + id + "])");
        }
        Element ret = this.resolveId0(doc, id, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveID(Document doc,String id) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    public boolean findId(Document doc, String id) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findId(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String id[" + id + "])");
        }
        boolean bl = ret = this.resolveId0(doc, id, false) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findId(Document doc,String id) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public boolean findWsuId(Document doc, String id) {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findWsuId(Document doc[" + DOMUtil.getDisplayName(doc) + "]," + "String id[" + id + "])");
        }
        boolean bl = ret = this.resolveId0(doc, id, true) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findWsuId(Document doc,String id) returns boolean[" + ret + "]");
        }
        return ret;
    }

    private Element resolveId0(Document doc, String id, boolean onlyWsu) {
        if (doc == null) {
            return null;
        }
        Element el = doc.getElementById(id);
        if (el != null) {
            return el;
        }
        return this.resolve(doc.getDocumentElement(), id, onlyWsu);
    }

    protected Element resolveId(Node node, String id) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveId(Node node[" + DOMUtil.getDisplayName(node) + "]," + "String id[" + id + "])");
        }
        Element ret = null;
        if (node != null) {
            ret = this.resolve(node, id, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveId(Node node,String id) returns Element[" + DOMUtil.getDisplayName(ret) + "]");
        }
        return ret;
    }

    private Element resolve(Node node, String id, boolean onlyWsu) {
        if (node.getNodeType() == 1 && this.matchId((Element)node, id, onlyWsu)) {
            return (Element)node;
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element element;
            if (child.getNodeType() != 1 && child.getNodeType() != 5 || (element = this.resolve(child, id, onlyWsu)) == null) continue;
            return element;
        }
        return null;
    }

    public String getId(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getId(Element element[" + DOMUtil.getDisplayName(element) + "])");
        }
        String value2 = null;
        String name2 = this.getIdAttributeName(element);
        if (name2 != null) {
            value2 = element.getAttribute(name2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getId(Element element) returns String[" + value2 + "]");
        }
        return value2;
    }
}

