/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.util;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.ws.webservices.wssecurity.config.Configuration;
import com.ibm.ws.webservices.wssecurity.config.EncryptionGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.webservices.wssecurity.config.SignatureGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.webservices.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Initializable;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigUtil {
    private static final String clsName = ConfigUtil.class.getName();
    private static final String comp = "security.wssecurity";
    private static final TraceComponent tc = Tr.register(ConfigUtil.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String[] TRUE_VALUES = new String[]{"yes", "on", "true", "1"};
    private static final String[] FALSE_VALUES = new String[]{"no", "off", "false", "0"};
    private static final PrivilegedAction contextLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final PrivilegedAction thisClassLoaderGetter = new PrivilegedAction(){

        public Object run() {
            return this.getClass().getClassLoader();
        }
    };
    private static final String[] USAGE_VALUES = new String[]{"required", "optional", "rejected", "observed", "ignored"};
    private static final String[] KEYINFO_TYPES = new String[]{"STRREF", "EMB", "KEYID", "KEYNAME", "X509ISSUER"};
    private static final Set C14N_TRANSFORMS = new HashSet();
    private static final Set DOMREQUIRED_TRANSFORMS;
    private static final Set SECRETKEY_ALGORITHMS;

    public static boolean isTrue(String flag) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTrue(String flag[" + flag + "])");
        }
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < TRUE_VALUES.length; ++i) {
                if (!TRUE_VALUES[i].equalsIgnoreCase(flag)) continue;
                ret = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTrue(String flag) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isFalse(String flag) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFalse(String flag[" + flag + "])");
        }
        boolean ret = false;
        if (flag != null) {
            flag = flag.trim();
            for (int i = 0; i < FALSE_VALUES.length; ++i) {
                if (!FALSE_VALUES[i].equalsIgnoreCase(flag)) continue;
                ret = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFalse returns [" + ret + "]");
        }
        return ret;
    }

    public static boolean hasValue(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean getIsTrueProperty(Map _map, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty(_map, " + propName + ")");
        }
        String propValue = (String)_map.get(propName);
        boolean retVal = false;
        if (ConfigUtil.hasValue(propValue) && ConfigUtil.isTrue(propValue)) {
            retVal = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTrueProperty returns [" + retVal + "]");
        }
        return retVal;
    }

    public static boolean getIsTruePropertyEnv(Map _map, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsTruePropertyEnv(_map, " + propName + ")");
        }
        boolean retVal = false;
        String propValue = ConfigUtil.getPropertyEnv(_map, propName);
        if (ConfigUtil.hasValue(propValue) && ConfigUtil.isTrue(propValue)) {
            retVal = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsTruePropertyEnv returns [" + retVal + "]");
        }
        return retVal;
    }

    public static boolean getIsFalseProperty(Map _map, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIsFalseProperty(_map, " + propName + ")");
        }
        String propValue = (String)_map.get(propName);
        boolean retVal = true;
        if (ConfigUtil.hasValue(propValue) && ConfigUtil.isFalse(propValue)) {
            retVal = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIsFalseProperty returns [" + retVal + "]");
        }
        return retVal;
    }

    public static String getPropertyEnv(Map _map, String propName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertyEnv(_map, " + propName + ")");
        }
        String propValue = null;
        if (_map != null && propName != null && propName.length() != 0 && !ConfigUtil.hasValue(propValue = (String)_map.get(propName)) && ConfigUtil.hasValue(propValue = System.getProperty(propName)) && tc.isDebugEnabled()) {
            Tr.exit(tc, propName + "=" + propValue + " in the JVM.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertyEnv returns [" + propValue + "]");
        }
        return propValue;
    }

    public static boolean isValidWSKeyStore(String keyStoreName) {
        return KeyStoreManager.getInstance().getKeyStore(keyStoreName) != null;
    }

    public static boolean isHWKeyStore(String keyStoreName) {
        return KeyStoreManager.getInstance().isHWKeyStore(keyStoreName);
    }

    public static Provider getHWCryptoProviderInstance(String keyStoreName) {
        return KeyStoreManager.getInstance().getHWCryptoProviderInstance(keyStoreName);
    }

    public static void returnHWCryptoProviderInstance(String keyStoreName, Provider hwProviderInstance) {
        KeyStoreManager.getInstance().returnHWCryptoProviderInstance(keyStoreName, hwProviderInstance);
    }

    public static String getHWKeyStorePassword(String keyStoreName) {
        String pwd = null;
        WSKeyStore wsk = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
        if (wsk != null) {
            pwd = wsk.getProperty("com.ibm.ssl.keyStorePassword");
        }
        return pwd;
    }

    public static KeyStore getHWKeyStore(String keyStoreName) {
        KeyStore keyStore = null;
        WSKeyStore wsk = KeyStoreManager.getInstance().getKeyStore(keyStoreName);
        if (wsk != null) {
            try {
                keyStore = wsk.getKeyStore(false, false);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cannot get the HW KeyStore referenced by :" + keyStoreName);
                }
                Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreName});
            }
            if (keyStore == null) {
                Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreName});
            }
        } else {
            Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreName});
        }
        return keyStore;
    }

    public static File fixPath(String path, String base) {
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixPath(String path[" + path + "]," + "String base[" + base + "])");
        }
        if (!(file = new File(path)).isAbsolute()) {
            file = base != null ? new File(base, path) : new File(file.getAbsolutePath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixPath(String path,String base) returns File[" + file + "]");
        }
        return file;
    }

    public static String fixKeystorePath(String path, String base) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixKeystorePath", "String path[" + path + "]," + "String base[" + base + "]");
        }
        String retval = null;
        String newPath = path;
        String newBase = base;
        if (base != null) {
            try {
                URL url = new URL(base);
                StringBuffer sbPath = new StringBuffer(base);
                if (base.charAt(base.length() - 1) != '/') {
                    sbPath.append("/");
                }
                sbPath.append(path);
                newPath = sbPath.toString();
                newBase = null;
                Tr.debug(tc, "base is a URL, concat path=" + newPath);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (newBase == null) {
            try {
                String protocol2;
                URL urlPath = new URL(newPath);
                String prepend = "";
                if (base == null) {
                    prepend = "path is a ";
                }
                if ((protocol2 = urlPath.getProtocol()).equalsIgnoreCase("file")) {
                    newPath = urlPath.getPath();
                    Tr.debug(tc, prepend + "file URL, extracting file portion: " + newPath);
                } else {
                    Tr.debug(tc, prepend + "normal URL, returning unchanged");
                    retval = newPath;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retval == null) {
            try {
                File file = null;
                file = base != null ? new File(base, path) : new File(newPath);
                retval = file.getAbsolutePath();
            }
            catch (Exception e) {
                Tr.debug(tc, "Exception caught while creating a File object from " + newPath + ": " + e);
                Tr.debug(tc, "Returning unchanged.");
                retval = newPath;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixKeystorePath returns [" + retval + "]");
        }
        return retval;
    }

    public static KeyStore getKeyStore(String keyStoreRef) throws SoapSecurityException {
        Tr.entry(tc, "getKeyStore(String keyStoreRef[" + keyStoreRef + "])");
        if (keyStoreRef == null || keyStoreRef.length() == 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s08", (String)keyStoreRef);
        }
        KeyStore keystore = ConfigUtil.createKeyStore(null, null, null, keyStoreRef);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String keyStoreRef)");
        }
        return keystore;
    }

    public static KeyStore getKeyStore(String type, String path, char[] storepass) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            String passStr = storepass == null ? "null" : "not null";
            Tr.entry(tc, "getKeyStore(String type[" + type + "]," + "String path[" + path + "]," + "char[] storepass[" + passStr + "])");
        }
        if (storepass == null || storepass.length == 0) {
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s03", (String)path);
        }
        KeyStore keystore = ConfigUtil.createKeyStore(type, path, storepass, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyStore(String type,String path,char[] storepass)");
        }
        return keystore;
    }

    private static KeyStore createKeyStore(final String type, final String inPath, final char[] storepass, String keyStoreRef) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            String passStr = storepass == null ? "null" : "not null";
            Tr.entry(tc, "createKeyStore(String type[" + type + "]," + "String path[" + inPath + "]," + "char[] storepass[" + passStr + "]," + "KeyStore Reference[" + keyStoreRef + "])");
        }
        KeyStore keyStore = null;
        try {
            if (keyStoreRef != null && keyStoreRef.length() != 0) {
                WSKeyStore wsk = KeyStoreManager.getInstance().getKeyStore(keyStoreRef);
                if (wsk != null) {
                    keyStore = wsk.getKeyStore(false, false);
                    if (keyStore == null) {
                        Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreRef});
                    }
                } else {
                    Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreRef});
                }
            } else {
                keyStore = (KeyStore)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SoapSecurityException {
                        String path = ConfigUtil.fixKeystorePath(inPath, null);
                        KeyStore kstore = null;
                        InputStream in = null;
                        try {
                            kstore = KeyStore.getInstance(type);
                            in = ConfigUtil.openKeyStore(path);
                            kstore.load(in, storepass);
                        }
                        catch (FileNotFoundException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "199");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s04", new Object[]{path});
                            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s04", (String)path);
                        }
                        catch (IOException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "205");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s05", new Object[]{path});
                            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s05", (String)path);
                        }
                        catch (CertificateException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "211");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage()});
                            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)path, (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
                        }
                        catch (NoSuchAlgorithmException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "219");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage()});
                            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)path, (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
                        }
                        catch (KeyStoreException e) {
                            Tr.processException(e, clsName + ".createKeyStore", "227");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage()});
                            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)path, (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
                        }
                        catch (UnsatisfiedLinkError e) {
                            Tr.processException(e, clsName + ".createKeyStore", "235");
                            Tr.error(tc, "security.wssecurity.ConfigUtil.s06", new Object[]{path, e.getClass().getName(), e.getMessage()});
                            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s06", (String)path, (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                        return kstore;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            Throwable th = e.getCause();
            Tr.processException(th, clsName + ".createKeyStore", "244");
            if (th instanceof SoapSecurityException) {
                throw (SoapSecurityException)th;
            }
            throw new SoapSecurityException(th);
        }
        catch (Exception e) {
            Tr.processException(e, clsName + ".createKeyStore", "252");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s28", new Object[]{keyStoreRef, e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s28", (String)keyStoreRef, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyStore(String type,String path,char[] storepass) returns KeyStore[" + keyStore + "]");
        }
        return keyStore;
    }

    public static InputStream openKeyStore(String fileName) throws MalformedURLException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "openKeyStore", fileName);
        }
        InputStream fis = null;
        URL urlFile = null;
        File fFile = new File(fileName);
        if (fFile.exists() && fFile.length() == 0L) {
            throw new IOException("Keystore file exists, but is empty: " + fileName);
        }
        try {
            urlFile = new URL(fileName);
            fis = urlFile.openStream();
        }
        catch (MalformedURLException ex) {
            fis = new FileInputStream(fileName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openKeyStore");
        }
        return fis;
    }

    public static Key getKey(KeyStore keyStore, String alias, char[] keypass) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            String passStr = keypass == null ? "null" : "not null";
            Tr.entry(tc, "getKey(KeyStore keyStore,String alias[" + alias + "]," + "char[] keypass[" + passStr + "])");
        }
        Key key = null;
        try {
            key = keyStore.getKey(alias, keypass);
        }
        catch (KeyStoreException e) {
            Tr.processException(e, clsName + ".getKey", "276");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s07", new Object[]{alias, keyStore.toString(), e.getClass().getName(), e.getMessage(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s07", (String)alias, (String)keyStore.toString(), (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Tr.processException(e, clsName + ".getKey", "284");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s07", new Object[]{alias, keyStore.toString(), e.getClass().getName(), e.getMessage(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s07", (String)alias, (String)keyStore.toString(), (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            Tr.processException(e, clsName + ".getKey", "292");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s27", new Object[]{alias, keyStore.toString(), e.getClass().getName(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s27", (String)alias, (String)keyStore.toString(), (String)e.getClass().getName(), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKey(KeyStore keyStore,String alias,char[] keypass) returns Key[" + key + "]");
        }
        return key;
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertificate(KeyStore keyStore,String alias[" + alias + "])");
        }
        Certificate cert = null;
        try {
            cert = keyStore.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            Tr.processException(e, clsName + ".getCertificate", "322");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s13", new Object[]{alias, keyStore.toString(), e.getClass().getName(), e.getMessage(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.FileConfigSSR.s13", (String)alias, (String)keyStore.toString(), (String)e.getClass().getName(), (String)e.getMessage(), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertificate(KeyStore keyStore,String alias) returns Certificate[" + cert + "]");
        }
        return cert;
    }

    public static X509Certificate getX509Certificate(File path, CertificateFactory certificateFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509Certificate(File path[" + path + "]," + "CertificateFactory certificateFactory[" + certificateFactory + "])");
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)certificateFactory.generateCertificate(new FileInputStream(path));
        }
        catch (IOException e) {
            Tr.processException(e, clsName + ".getX509Certificate", "351");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s23", new Object[]{path.getAbsolutePath(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s23", (String)path.getAbsolutePath(), (Throwable)e);
        }
        catch (CertificateException e) {
            Tr.processException(e, clsName + ".getX509Certificate", "357");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s24", new Object[]{path.getAbsolutePath(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s24", (String)path.getAbsolutePath(), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509Certificate(File path,CertificateFactory certificateFactory) returns X509Certificate[" + cert + "]");
        }
        return cert;
    }

    public static X509CRL getX509CRL(File path, CertificateFactory certificateFactory) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getX509CRL(File path[" + path + "]," + "CertificateFactory certificateFactory[" + certificateFactory + "])");
        }
        X509CRL crl = null;
        try {
            crl = (X509CRL)certificateFactory.generateCRL(new FileInputStream(path));
        }
        catch (IOException e) {
            Tr.processException(e, clsName + ".getX509CRL", "384");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s25", new Object[]{path.getAbsolutePath(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s25", (String)path.getAbsolutePath(), (Throwable)e);
        }
        catch (CRLException e) {
            Tr.processException(e, clsName + ".getX509CRL", "390");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s26", new Object[]{path.getAbsolutePath(), e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s26", (String)path.getAbsolutePath(), (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getX509CRL(File path,CertificateFactory certificateFactory) returns X509CRL[" + crl + "]");
        }
        return crl;
    }

    public static CertificateFactory createCertificateFactory(String provider) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertificateFactory(String provider[" + provider + "])");
        }
        CertificateFactory factory = null;
        try {
            factory = provider == null || "".equals(provider) ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", provider);
        }
        catch (CertificateException e) {
            Tr.processException(e, clsName + ".createCertificateFactory", "419");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s24", new Object[]{provider, e});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s24", (String)provider, (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            Tr.processException(e, clsName + ".createCertificateFactory", "425");
            Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s22", new Object[]{provider, e});
            throw SoapSecurityException.format((String)"security.wssecurity.CommonReceiverConfig.s22", (String)provider, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertificateFactory(String provider) returns CertificateFactory[" + factory + "]");
        }
        return factory;
    }

    public static Document mergeDocuments(Document[] docs) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeDocuments(Document[] docs[" + docs + "])");
        }
        Document doc = DOMUtil.createDocument();
        Element root = doc.createElement("root");
        doc.appendChild(root);
        if (docs != null) {
            for (int i = 0; i < docs.length; ++i) {
                Element elem;
                if (docs[i] == null || (elem = docs[i].getDocumentElement()) == null) continue;
                root.appendChild(doc.importNode(elem, true));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeDocuments(Document[] docs) returns Document[" + doc + "]");
        }
        return doc;
    }

    public static Object instantiate(String cls, Class type, ClassLoader acl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate(String cls[" + cls + "]," + "Class type[" + type + "]," + "ClassLoader acl)");
        }
        Object obj = null;
        ClassLoader loader = acl;
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(thisClassLoaderGetter);
        }
        if (tc.isDebugEnabled()) {
            if (loader != null) {
                Tr.debug(tc, "Classloader: " + loader.getClass().getName());
                Tr.debug(tc, "Classloader dump: " + loader.toString());
            } else {
                Tr.debug(tc, "Classloader: <null>");
            }
        }
        try {
            Class<?> c = loader != null ? loader.loadClass(cls) : Class.forName(cls);
            if (type != null && !type.isAssignableFrom(c)) {
                throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s17", (String)cls, (String)type.getName());
            }
            obj = c.newInstance();
        }
        catch (ClassNotFoundException e) {
            Tr.processException(e, clsName + ".instantiate", "514");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s09", new Object[]{cls});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s09", (String)cls);
        }
        catch (InstantiationException e) {
            Tr.processException(e, clsName + ".instantiate", "519");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s10", new Object[]{cls});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s10", (String)cls);
        }
        catch (IllegalAccessException e) {
            Tr.processException(e, clsName + ".instantiate", "524");
            Tr.error(tc, "security.wssecurity.ConfigUtil.s11", new Object[]{cls});
            throw SoapSecurityException.format((String)"security.wssecurity.ConfigUtil.s11", (String)cls);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate(String cls,Class type,ClassLoader acl) returns Object[" + obj + "]");
        }
        return obj;
    }

    public static Initializable instantiate(String cls, Class type, Map map, ClassLoader acl) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "instantiate(String cls[" + cls + "]," + "Class type[" + type + "]," + "Map map," + "ClassLoader acl)");
        }
        Initializable instance = (Initializable)ConfigUtil.instantiate(cls, type, acl);
        instance.init(map);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "instantiate(String cls,Class type,Map map,ClassLoader acl) returns Initializable[" + instance + "]");
        }
        return instance;
    }

    public static void getProperties(Map properties, Element parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Map properties,Element parent[" + DOMUtil.getDisplayName(parent) + "])");
        }
        NodeList list = DOMUtil.getChildElements(parent, Constants.NS_CONFIG, "Property");
        Element property = null;
        for (int i = 0; i < list.getLength(); ++i) {
            property = (Element)list.item(i);
            String name2 = DOMUtil.getAttribute(property, "name");
            String value2 = DOMUtil.getAttribute(property, "value");
            properties.put(name2, value2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + name2 + "], Value [" + value2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProperties(Map properties,Element parent)");
        }
    }

    public static Map getProperties(Element parent) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Element parent[" + DOMUtil.getDisplayName(parent) + "])");
        }
        NodeList properties = DOMUtil.getChildElements(parent, Constants.NS_CONFIG, "Property");
        HashMap<String, String> map = new HashMap<String, String>();
        Element property = null;
        for (int i = 0; i < properties.getLength(); ++i) {
            property = (Element)properties.item(i);
            String name2 = DOMUtil.getAttribute(property, "name");
            String value2 = DOMUtil.getAttribute(property, "value");
            map.put(name2, value2);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Added a property (Name [" + name2 + "], Value [" + value2 + "].");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperties(Element parent)");
        }
        return map;
    }

    public static KeyLocator findKeyLocator(Element element, String name2, String parentPath) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findKeyLocator(Element element[" + DOMUtil.getDisplayName(element) + "]," + "String name[" + name2 + "]," + "String parentPath[" + parentPath + "])");
        }
        NodeList locators = element.getElementsByTagNameNS(Constants.NS_CONFIG, "KeyLocator");
        Element locatorElem = null;
        String cls = null;
        KeyLocator locator = null;
        for (int i = 0; i < locators.getLength(); ++i) {
            locatorElem = (Element)locators.item(i);
            if (!name2.equals(DOMUtil.getAttribute(locatorElem, "name"))) continue;
            cls = DOMUtil.getAttribute(locatorElem, "classname");
            Map map = ConfigUtil.getProperties(locatorElem);
            if (cls.equals("com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator")) {
                map.put("base", parentPath);
            }
            locator = (KeyLocator)ConfigUtil.instantiate(cls, KeyLocator.class, map, null);
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findKeyLocator(Element element,String name,String parentPath) returns KeuLocator[" + locator + "]");
        }
        return locator;
    }

    public static String getMessage(String key) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage(String key[" + key + "]");
        }
        String ret = key;
        if (_MessageCatalog.instance != null) {
            try {
                ret = _MessageCatalog.instance.getString(key);
            }
            catch (MissingResourceException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception", new Object[]{e});
                }
                Tr.processException(e, ConfigUtil.class.getName() + ".getMessage", "673");
                ret = key;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage(String key) returns String[" + ret + "]");
        }
        return ret;
    }

    public static String getMessage(String key, String[] args) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessage(String key[" + key + "]," + "String[] args[" + args + "])");
        }
        String ret = ConfigUtil.getMessage(key);
        if (args != null && args.length > 0) {
            ret = MessageFormat.format(ret, args);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessage(String key,String[] args) returns String[" + ret + "]");
        }
        return ret;
    }

    public static int isIntegralWASDialect(String keyword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isIntegralWASDialect(String keyword[" + keyword + "])");
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < IntegralDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!keyword.equals(IntegralDialectElementSelector.WASDIALECTS[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isIntegralWASDialect(String keyword) returns int[" + index + "]");
        }
        return index;
    }

    public static int isConfidentialWASDialect(String keyword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConfidentialWASDialect(String keyword[" + keyword + "])");
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < ConfidentialDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!keyword.equals(ConfidentialDialectElementSelector.WASDIALECTS[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConfidentialWASDialect(String keyword) returns int[" + index + "]");
        }
        return index;
    }

    public static int isTimestampWASDialect(String keyword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTimestampWASDialect(String keyword[" + keyword + "])");
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < TimestampDialectElementSelector.WASDIALECTS.length; ++i) {
                if (!keyword.equals(TimestampDialectElementSelector.WASDIALECTS[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTimestampWASDialect(String keyword) returns int[" + index + "]");
        }
        return index;
    }

    public static int isUsage(String usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsage(String usage[" + usage + "])");
        }
        int index = -1;
        if (usage != null) {
            usage = usage.trim();
            for (int i = 0; i < USAGE_VALUES.length; ++i) {
                if (!USAGE_VALUES[i].equalsIgnoreCase(usage)) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsage(String usage) returns int[" + index + "]");
        }
        return index;
    }

    public static boolean isUsageRequired(String usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageRequired(String usage[" + usage + "])");
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[0].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageRequired(String usage) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isUsageOptional(String usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageOptional(String usage[" + usage + "])");
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[1].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageOptional(String usage) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isUsageRejected(String usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageRejected(String usage[" + usage + "])");
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[2].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageRejected(String usage) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isUsageObserved(String usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageObserved(String usage[" + usage + "])");
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[3].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageObserved(String usage) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isUsageIgnored(String usage) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUsageIgnored(String usage[" + usage + "])");
        }
        boolean ret = false;
        if (usage != null) {
            usage = usage.trim();
            ret = USAGE_VALUES[4].equalsIgnoreCase(usage);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUsageIgnored(String usage) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static int isKeyInfoSignature(String keyword) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoSignature(String keyword[" + keyword + "])");
        }
        int index = -1;
        if (keyword != null) {
            keyword = keyword.trim();
            for (int i = 0; i < IntegralDialectElementSelector.KEYSIGNMETHOD.length; ++i) {
                if (!keyword.equals(IntegralDialectElementSelector.KEYSIGNMETHOD[i])) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoSignature(String keyword) returns int[" + index + "]");
        }
        return index;
    }

    public static int isKeyInfoType(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoType(String type[" + type + "])");
        }
        int index = -1;
        if (type != null) {
            type = type.trim();
            for (int i = 0; i < KEYINFO_TYPES.length; ++i) {
                if (!KEYINFO_TYPES[i].equalsIgnoreCase(type)) continue;
                index = i;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoType(String type) returns int[" + index + "]");
        }
        return index;
    }

    public static boolean isKeyInfoStrref(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoStrref(String type[" + type + "])");
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[0].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoStrref(String type) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isKeyInfoEmb(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoEmb(String type[" + type + "])");
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[1].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoEmb(String type) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isKeyInfoKeyid(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoKeyid(String type[" + type + "])");
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[2].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoKeyid(String type) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isKeyInfoKeyname(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoKeyname(String type[" + type + "])");
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[3].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoKeyname(String type) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isKeyInfoX509issuer(String type) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isKeyInfoX509issuer(String type[" + type + "])");
        }
        boolean ret = false;
        if (type != null) {
            type = type.trim();
            ret = KEYINFO_TYPES[4].equalsIgnoreCase(type);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isKeyInfoX509issuer(String type) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isC14nTransform(String algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isC14nTransform(String algorithm[" + algorithm + "])");
        }
        boolean ret = C14N_TRANSFORMS.contains(algorithm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isC14nTransform(String algorithm) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isDOMRequiredTransform(String algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isDOMRequiredTransform(String algorithm[" + algorithm + "])");
        }
        boolean ret = DOMREQUIRED_TRANSFORMS.contains(algorithm);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isDOMRequiredTransform(String algorithm) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static boolean isSecretKeyAlgorithm(String algorithm) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecretKeyAlgorithm(String algorithm[" + algorithm + "])");
        }
        boolean ret = false;
        if (algorithm != null) {
            ret = SECRETKEY_ALGORITHMS.contains(algorithm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSecretKeyAlgorithm(String algorithm) returns boolean[" + ret + "]");
        }
        return ret;
    }

    public static int getMinimumPosition(List order, List references) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order[" + order + "]," + "List references[" + references + "])");
        }
        int pos = 10000;
        for (SigningReferenceConfig srconfig : references) {
            int j = ConfigUtil.getPosition(order, srconfig.getReference());
            if (j >= pos) continue;
            pos = j;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order,List references) returns int[" + pos + "]");
        }
        return pos;
    }

    public static int getPosition(List order, ReferencePartConfig reference) {
        ReferencePartConfig rpart;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order[" + order + "]," + "ReferencePartConfig reference[" + reference + "])");
        }
        int pos = 0;
        Iterator i = order.iterator();
        while (i.hasNext() && !(rpart = (ReferencePartConfig)i.next()).equals(reference)) {
            if (!i.hasNext()) continue;
            ++pos;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMinimumPosition(List order,ReferencePartConfig reference) returns int[" + pos + "]");
        }
        return pos;
    }

    public static void insertGenerator(List operationGenerators, List order, int orderNumber, Configuration config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertGenerator(List operationGenerators[" + operationGenerators + "]," + "List order[" + order + "]," + "int orderNumber[" + orderNumber + "]," + "Configuration config)");
        }
        int pos = 0;
        for (Object obj : operationGenerators) {
            int j = 0;
            if (obj instanceof EncryptionGeneratorConfig) {
                j = ConfigUtil.getPosition(order, ((EncryptionGeneratorConfig)obj).getReference());
            } else if (obj instanceof SignatureGeneratorConfig) {
                j = ConfigUtil.getMinimumPosition(order, ((SignatureGeneratorConfig)obj).getReferences());
            }
            if (j > orderNumber) {
                operationGenerators.add(pos, config);
                return;
            }
            ++pos;
        }
        operationGenerators.add(config);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertGenerator(List operationGenerators,List order,int orderNumber,Configuration config)");
        }
    }

    public static String trim(String value2) {
        String ret = null;
        if (value2 != null) {
            ret = value2.trim();
        }
        return ret;
    }

    public static void logProperties(Map properties, Map consumerProps, String prop, String value2, String consumerName) {
        if (tc.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            if (consumerName != null) {
                buf.append("Consumer name: " + consumerName);
            }
            if (ConfigUtil.hasValue(prop)) {
                if (value2 != null) {
                    buf.append("\nSystem property: {" + prop + "=" + value2 + "}");
                } else {
                    buf.append("\nSystem property: {}");
                }
            }
            if (properties != null) {
                buf.append("\nApplication properties: " + properties);
            }
            if (consumerProps != null) {
                buf.append("\nThis consumer's properties: " + consumerProps);
            }
            Tr.debug(tc, buf.toString());
        }
    }

    public static Provider setupCertStoreProvider(Map properties, Map tokenProperties, String consumerName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupCertStoreProvider");
        }
        String cspConstant = "com.ibm.wsspi.wssecurity.config.CertStore.Provider";
        ConfigUtil.logProperties(properties, tokenProperties, cspConstant, System.getProperty(cspConstant), consumerName);
        HashMap tempMap = new HashMap();
        if (properties != null) {
            tempMap.putAll(properties);
        }
        if (tokenProperties != null) {
            tempMap.putAll(tokenProperties);
        }
        String csp = ConfigUtil.getPropertyEnv(tempMap, cspConstant);
        Provider provider = null;
        if (ConfigUtil.hasValue(csp)) {
            if (tokenProperties != null) {
                tokenProperties.put(cspConstant, csp);
            }
            if (tc.isDebugEnabled()) {
                if (ConfigUtil.hasValue(consumerName)) {
                    Tr.debug(tc, "Cert store security provider for " + consumerName + " is: '" + csp + "'.");
                } else {
                    Tr.debug(tc, "Cert store security provider is: '" + csp + "'.");
                }
            }
            if ((provider = Security.getProvider(csp)) == null) {
                Tr.debug(tc, "Provider '" + csp + "' not found.");
            }
        } else if (tc.isDebugEnabled()) {
            if (ConfigUtil.hasValue(consumerName)) {
                Tr.debug(tc, "No user-specified cert store security provider is active for " + consumerName);
            } else {
                Tr.debug(tc, "No user-specified cert store security provider is active.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupCertStoreProvider");
        }
        return provider;
    }

    public static void setMustUnderstand(SOAPMessageContext messageContext, boolean mustUnderstand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMustUnderstand(messageContext)=" + mustUnderstand);
        }
        if (messageContext != null) {
            messageContext.setProperty(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND, new Boolean(mustUnderstand));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMustUnderstand");
        }
    }

    public static void setMustUnderstand(MessageContextProxy messageContext, boolean mustUnderstand) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMustUnderstand(MessageContextProxy)=" + mustUnderstand);
        }
        if (messageContext != null) {
            messageContext.setConfig(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND, new Boolean(mustUnderstand));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMustUnderstand");
        }
    }

    public static boolean getMustUnderstand(SOAPMessageContext messageContext) {
        Boolean mUnderstand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(messageContext)");
        }
        boolean mustUnderstand = true;
        if (messageContext != null && (mUnderstand = (Boolean)messageContext.getProperty(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND)) != null) {
            mustUnderstand = mUnderstand;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + mustUnderstand);
        }
        return mustUnderstand;
    }

    public static boolean getMustUnderstand(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(context)");
        }
        boolean mustUnderstand = true;
        if (context != null) {
            SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            mustUnderstand = ConfigUtil.getMustUnderstand(messageContext);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + mustUnderstand);
        }
        return mustUnderstand;
    }

    public static boolean getMustUnderstand(MessageContextProxy messageContext) {
        Boolean mUnderstand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMustUnderstand(MessageContextProxy)");
        }
        boolean mustUnderstand = true;
        if (messageContext != null && (mUnderstand = (Boolean)messageContext.getConfig(com.ibm.ws.webservices.wssecurity.Constants.MUST_UNDERSTAND)) != null) {
            mustUnderstand = mUnderstand;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMustUnderstand=" + mustUnderstand);
        }
        return mustUnderstand;
    }

    static {
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#");
        C14N_TRANSFORMS.add("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        C14N_TRANSFORMS.add("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        DOMREQUIRED_TRANSFORMS = new HashSet();
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xpath-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/06/xmldsig-filter2");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/TR/1999/REC-xslt-19991116");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        DOMREQUIRED_TRANSFORMS.add("http://www.w3.org/2002/07/decrypt#XML");
        SECRETKEY_ALGORITHMS = new HashSet();
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes128");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes192");
        SECRETKEY_ALGORITHMS.add("http://www.w3.org/2001/04/xmlenc#kw-aes256");
    }

    private static class _MessageCatalog {
        private static final TraceComponent tc1 = Tr.register(_MessageCatalog.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        private static ResourceBundle instance;

        private _MessageCatalog() {
        }

        private static void init() {
            block5: {
                if (tc1.isEntryEnabled()) {
                    Tr.entry(tc1, "init()");
                }
                try {
                    instance = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
                    if (tc1.isDebugEnabled()) {
                        Tr.debug(tc1, "Initialize resource bundle: com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
                    }
                }
                catch (Throwable t) {
                    instance = null;
                    Tr.processException(t, _MessageCatalog.class.getName(), "1230");
                    Tr.warning(tc1, "security.wssecurity.cannot.laod.resource", new Object[]{t});
                    if (!tc1.isDebugEnabled()) break block5;
                    Tr.debug(tc1, "Failed to initialize resource bundle: com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
                }
            }
            if (tc1.isEntryEnabled()) {
                Tr.exit(tc1, "init()");
            }
        }

        static {
            _MessageCatalog.init();
        }
    }
}

