/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.token.BinaryTokenSender;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLTokenSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(XMLTokenSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public void init(Map map) throws Exception {
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        Request[] requests = RequestPool.get(context, TokenRequest.XML.class);
        for (int i = 0; i < requests.length; ++i) {
            TokenRequest.XML request = (TokenRequest.XML)requests[i];
            Element[] tokens = request.getTokens();
            for (int j = tokens.length - 1; j >= 0; --j) {
                if (request.getSignature()) {
                    String id;
                    String idattr = IdUtil.getInstance().getIdAttributeName(tokens[j]);
                    String string = id = idattr == null ? null : tokens[j].getAttribute(idattr);
                    if (id == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding ID attribute to XML token.");
                        }
                        id = IdUtil.getInstance().makeUniqueId(doc, "wssecurity_xml_token_id_");
                        BinaryTokenSender.addIdAttribute(tokens[j], id, Constants.getWSSENS(context), Constants.getWSUNS(context));
                    }
                    RequestPool.add(context, new SignatureRequest(id));
                }
                target.insertBefore(doc.importNode(tokens[j], true), target.getFirstChild());
            }
            RequestPool.remove(context, requests[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }
}

