/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.dsig.SignatureRequest;
import com.ibm.xml.soapsec.enc.EncryptionRequest;
import com.ibm.xml.soapsec.token.BinaryTokenSender;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.token.TokenRequest;
import com.ibm.xml.soapsec.token.TokenSenderConfig;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Hex;
import com.ibm.xml.soapsec.util.IdUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Date;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UsernameTokenSender
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(UsernameTokenSender.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    SenderConfig gconfig = null;
    TokenSenderConfig conf = null;

    public void init(Map map) throws Exception {
        this.gconfig = (SenderConfig)map.get(SenderConfig.class);
        this.conf = (TokenSenderConfig)map.get(TokenSenderConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        Request[] requests = RequestPool.get(context, TokenRequest.Username.class);
        for (int i = 0; i < requests.length; ++i) {
            this.insertToken(doc, target, context, (TokenRequest.Username)requests[i]);
            RequestPool.remove(context, requests[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    private void insertToken(Document doc, Element target, Map context, TokenRequest.Username request) throws SoapSecurityException {
        String prefix = target.getPrefix();
        prefix = prefix == null || prefix.length() == 0 ? "" : prefix + ":";
        String wsseNSSent = Constants.getWSSENS(context);
        String wsuNSSent = Constants.getWSUNS(context);
        Element usernameToken = doc.createElementNS(wsseNSSent, prefix + "UsernameToken");
        if (request.getSignature() || this.conf.isConfidential()) {
            String id = IdUtil.getInstance().makeUniqueId(doc, "usernametoken_");
            BinaryTokenSender.addIdAttribute(usernameToken, id, wsseNSSent, wsuNSSent);
            if (request.getSignature()) {
                RequestPool.add(context, new SignatureRequest(id));
            }
            if (this.conf.isConfidential()) {
                RequestPool.add(context, new EncryptionRequest(id, false, this.conf.getEncryptionSettings()));
            }
        }
        Element usernameElem = doc.createElementNS(wsseNSSent, prefix + "Username");
        if (request.getName() == null) {
            Tr.error(tc, "security.wssecurity.WSEC5199E");
            throw SoapSecurityException.format((String)"security.wssecurity.WSEC5199E");
        }
        usernameElem.appendChild(doc.createTextNode(request.getName()));
        usernameToken.appendChild(usernameElem);
        if (request.getPassword() != null) {
            Element passwordElem = doc.createElementNS(wsseNSSent, prefix + "Password");
            passwordElem.appendChild(doc.createTextNode(request.getPassword()));
            usernameToken.appendChild(passwordElem);
        }
        if (request.isNonceAdded()) {
            NonceManager nonceMgr = this.conf.getNonceManager();
            if (nonceMgr == null) {
                Tr.error(tc, "security.wssecurity.UsernameToken.token56");
                throw SoapSecurityException.format((String)"security.wssecurity.UsernameToken.token56");
            }
            byte[] nonce = nonceMgr.generate();
            Element nonceElem = doc.createElementNS(wsseNSSent, prefix + "Nonce");
            QName encType = request.getEncodingType();
            String nonceStr = null;
            if (encType == null || NamespaceUtil.equals(encType, Constants.getQName(wsseNSSent, "Base64Binary"))) {
                nonceStr = Base64.encode((byte[])nonce);
            } else if (NamespaceUtil.equals(encType, Constants.getQName(wsseNSSent, "HexBinary"))) {
                DOMUtil.setQNameAttr(nonceElem, null, "EncodingType", encType);
                nonceStr = Hex.encode(nonce);
            } else {
                Tr.error(tc, "security.wssecurity.UsernameToken.token55", encType.toString());
                throw SoapSecurityException.format((String)"security.wssecurity.UsernameToken.token55", (String)encType.toString());
            }
            nonceElem.appendChild(doc.createTextNode(nonceStr));
            usernameToken.appendChild(nonceElem);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce is enabled and added");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce is disabled and not added");
        }
        if (request.isTimestampAdded()) {
            Date created = new Date();
            Element createdElem = null;
            if (DOMUtil.hasNamespaceDeclaration(usernameToken, wsuNSSent)) {
                String wsuPrefix = DOMUtil.getNamespacePrefix(usernameToken, wsuNSSent);
                createdElem = doc.createElementNS(wsuNSSent, wsuPrefix + ":Created");
            } else {
                createdElem = doc.createElementNS(wsuNSSent, "Created");
                createdElem.setAttributeNS(Constants.NS_XMLNS, "xmlns", wsuNSSent);
            }
            String createdStr = UTC.format(created);
            createdElem.appendChild(doc.createTextNode(createdStr));
            usernameToken.appendChild(createdElem);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nonce timestamp is enabled, timestamp = " + createdStr + " is added");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Nonce timestamp is disabled and not added");
        }
        target.insertBefore(usernameToken, target.getFirstChild());
        if (this.gconfig.doIndentation()) {
            DOMUtil.indent(usernameToken, 6, 2);
            target.insertBefore(doc.createTextNode("\n      "), usernameToken);
        }
    }
}

