/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.token;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class UTC {
    private static final DateFormat fFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'", Locale.US);
    private static final DateFormat fParser;
    private static final Object lock;

    public static Date parse(String time) throws ParseException {
        return UTC.parse(fParser, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date parse(DateFormat parser, String src) throws ParseException {
        long msec;
        int t_ind;
        int cc_start = 0;
        if (src.charAt(0) == '+') {
            cc_start = 1;
        }
        if ((t_ind = src.indexOf(84)) < 0) {
            throw new ParseException("'T' is needed in a timestamp", 0);
        }
        int second_end = src.indexOf(46);
        int tz_ind = src.indexOf(45, t_ind);
        if (tz_ind < 0 && (tz_ind = src.indexOf(43, t_ind)) < 0 && (tz_ind = src.indexOf(90, t_ind)) < 0) {
            tz_ind = src.length();
        }
        long tz_offset = UTC.parseTimeZone(src, tz_ind);
        long fraction = 0L;
        if (second_end < 0) {
            second_end = tz_ind;
        } else {
            for (int i = second_end + 1; i < tz_ind; ++i) {
                char ch = src.charAt(i);
                if (ch < '0' || '9' < ch) {
                    throw new ParseException("Non-digit in fractional part: " + ch, i);
                }
                if (i == second_end + 1) {
                    fraction += (long)((ch - 48) * 100);
                    continue;
                }
                if (i == second_end + 2) {
                    fraction += (long)((ch - 48) * 10);
                    continue;
                }
                if (i != second_end + 3) continue;
                fraction += (long)(ch - 48);
            }
        }
        String parsed = src.substring(cc_start, second_end);
        Object object = lock;
        synchronized (object) {
            msec = parser.parse(parsed).getTime();
        }
        return new Date(msec + fraction + tz_offset);
    }

    private static long parseTimeZone(String src, int ind) throws ParseException {
        int len = src.length();
        int sign = 1;
        if (len <= ind) {
            return 0L;
        }
        if (src.charAt(ind) == 'Z') {
            if (ind + 1 != len) {
                throw new ParseException("Invalid timezone format", ind);
            }
            return 0L;
        }
        if (src.indexOf(ind) == 45) {
            sign = -1;
        }
        if (len != ++ind + 5) {
            throw new ParseException("Invalid timezone format", ind);
        }
        int h = Integer.parseInt(src.substring(ind, ind + 2));
        int m = Integer.parseInt(src.substring(ind + 3, ind + 5));
        return (long)(sign * (h * 60 + m)) * 60L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(Date time) {
        String v = null;
        Object object = lock;
        synchronized (object) {
            v = fFormat.format(time);
        }
        return v;
    }

    static {
        fFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        fParser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
        fParser.setTimeZone(TimeZone.getTimeZone("UTC"));
        lock = new Object();
    }
}

