/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soapsec.time;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Constants;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.SoapSecurityComponent;
import com.ibm.xml.soapsec.SoapSecuritySender;
import com.ibm.xml.soapsec.WriteBackResult;
import com.ibm.xml.soapsec.time.TimestampReceiverConfig;
import com.ibm.xml.soapsec.time.TimestampResult;
import com.ibm.xml.soapsec.token.UTC;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.NamespaceUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TimestampReceiver
implements SoapSecurityComponent {
    private static final TraceComponent tc = Tr.register(TimestampReceiver.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TimestampReceiver.class.getName();
    static final boolean DO_INDENT = true;
    TimestampReceiverConfig config;

    public void init(Map map) throws Exception {
        this.config = (TimestampReceiverConfig)map.get(TimestampReceiverConfig.class);
    }

    public void invoke(Document doc, Element target, Map context) throws SoapSecurityException {
        Element timestamp;
        Date created = null;
        Date expires = null;
        String id = null;
        Element cel = null;
        Element eel = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke(" + doc + "," + target + "," + context + ")");
        }
        if (this.config.addReceivedTimestamp()) {
            Node t;
            String wsuNSSent = Constants.getWSUNS(context);
            Element tstrace = TimestampReceiver.getTimestampHeader(doc, true);
            if (tstrace == null) {
                tstrace = doc.createElementNS(wsuNSSent, "wsu:TimestampTrace");
                tstrace.setAttributeNS(Constants.NS_XMLNS, "xmlns:wsu", wsuNSSent);
                Element header2 = SoapSecuritySender.getHeader(doc);
                header2.insertBefore(tstrace, header2.getFirstChild());
            }
            Element received = doc.createElementNS(wsuNSSent, "wsu:Received");
            received.setAttributeNS(null, "Role", this.config.getActor());
            received.appendChild(doc.createTextNode(UTC.format(new Date())));
            Node before = tstrace.getLastChild();
            if (before != null && before.getNodeType() != 3) {
                before = null;
            }
            if ((t = tstrace.getFirstChild()) == null) {
                tstrace.insertBefore(doc.createTextNode("\n      "), before);
            } else if (t.getNodeType() == 3) {
                tstrace.insertBefore(doc.createTextNode(t.getNodeValue()), before);
            }
            tstrace.insertBefore(received, before);
            ResultPool.add(context, new WriteBackResult(){});
        }
        if ((timestamp = TimestampReceiver.getTimestampHeader(doc, false)) != null) {
            id = NamespaceUtil.getWsuAttribute(timestamp, "Id");
            if (id.length() == 0) {
                id = null;
            }
            cel = NamespaceUtil.getFirstChildWsuElement(timestamp, "Created");
            eel = NamespaceUtil.getFirstChildWsuElement(timestamp, "Expires");
        }
        try {
            if (cel != null) {
                created = UTC.parse(DOMUtil.getStringValue(cel));
            }
            if (eel != null) {
                expires = UTC.parse(DOMUtil.getStringValue(eel));
            }
        }
        catch (ParseException pe) {
            String msgKey = "security.wssecurity.TimestampReceiver.parse";
            Tr.processException((Throwable)pe, clsName + ".invoke", "134", this);
            Tr.error(tc, msgKey, pe);
            throw SoapSecurityException.format((String)msgKey, (String)pe.toString(), (Throwable)pe);
        }
        if (created != null || expires != null) {
            ResultPool.add(context, new TimestampResult(created, expires, id));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(Document doc, Element target,Map context)");
        }
    }

    public static Element getTimestampHeader(Document doc, boolean trace) {
        Element header2;
        String elemName;
        String string = elemName = trace ? "TimestampTrace" : "Timestamp";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimestampHeader(" + doc + ")");
        }
        if ((header2 = DOMUtil.getFirstElement(doc.getDocumentElement(), "http://schemas.xmlsoap.org/soap/envelope/", "Header")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimestampHeader(Document doc) returns null");
            }
            return null;
        }
        Element el = DOMUtil.getFirstElement(header2);
        while (el != null) {
            if (NamespaceUtil.isWsu(el.getNamespaceURI()) && elemName.equals(el.getLocalName())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTimestampHeader(Document doc) returns " + el);
                }
                return el;
            }
            el = DOMUtil.getNextElement(el);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimestampHeader(Document doc) returns null");
        }
        return null;
    }
}

